/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher;

import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.query.Constraint;
import io.evitadb.api.query.Query;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.QueryUtils;
import io.evitadb.api.query.RequireConstraint;
import io.evitadb.api.query.filter.EntityLocaleEquals;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.query.filter.PriceInCurrency;
import io.evitadb.api.query.filter.PriceInPriceLists;
import io.evitadb.api.query.filter.PriceValidIn;
import io.evitadb.api.query.head.Collection;
import io.evitadb.api.query.order.OrderBy;
import io.evitadb.api.query.require.EntityFetch;
import io.evitadb.api.query.require.Require;
import io.evitadb.api.query.require.Strip;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.externalApi.graphql.api.catalog.GraphQLContextKey;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.model.ListEntitiesHeaderDescriptor;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.EntityFetchRequireResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.FilterConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.OrderConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.constraint.RequireConstraintResolver;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.resolver.dataFetcher.EntityQueryContext;
import io.evitadb.externalApi.graphql.api.resolver.SelectionSetAggregator;
import io.evitadb.externalApi.graphql.api.resolver.dataFetcher.ReadDataFetcher;
import io.evitadb.externalApi.graphql.metric.event.request.ExecutedEvent;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Currency;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListEntitiesDataFetcher
implements DataFetcher<DataFetcherResult<List<EntityClassifier>>>,
ReadDataFetcher {
    private static final Logger log = LoggerFactory.getLogger(ListEntitiesDataFetcher.class);
    @Nonnull
    private final EntitySchemaContract entitySchema;
    @Nonnull
    private final FilterConstraintResolver filterConstraintResolver;
    @Nonnull
    private final OrderConstraintResolver orderConstraintResolver;
    @Nonnull
    private final EntityFetchRequireResolver entityFetchRequireResolver;

    public ListEntitiesDataFetcher(@Nonnull CatalogSchemaContract catalogSchema, @Nonnull EntitySchemaContract entitySchema) {
        this.entitySchema = entitySchema;
        this.filterConstraintResolver = new FilterConstraintResolver(catalogSchema);
        this.orderConstraintResolver = new OrderConstraintResolver(catalogSchema);
        RequireConstraintResolver requireConstraintResolver = new RequireConstraintResolver(catalogSchema, new AtomicReference<FilterConstraintResolver>(this.filterConstraintResolver));
        this.entityFetchRequireResolver = new EntityFetchRequireResolver(arg_0 -> ((CatalogSchemaContract)catalogSchema).getEntitySchemaOrThrowException(arg_0), this.filterConstraintResolver, this.orderConstraintResolver, requireConstraintResolver);
    }

    @Nonnull
    public DataFetcherResult<List<EntityClassifier>> get(@Nonnull DataFetchingEnvironment environment) {
        Arguments arguments = Arguments.from(environment);
        ExecutedEvent requestExecutedEvent = (ExecutedEvent)((Object)environment.getGraphQlContext().get((Object)GraphQLContextKey.METRIC_EXECUTED_EVENT));
        Query query = requestExecutedEvent.measureInternalEvitaDBInputReconstruction(() -> {
            FilterBy filterBy = this.buildFilterBy(arguments);
            OrderBy orderBy = this.buildOrderBy(arguments);
            Require require = this.buildRequire(environment, arguments, filterBy);
            return Query.query((Collection)QueryConstraints.collection((String)this.entitySchema.getName()), (FilterBy)filterBy, (OrderBy)orderBy, (Require)require);
        });
        log.debug("Generated evitaDB query for entity list fetch of type `{}` is `{}`.", (Object)this.entitySchema.getName(), (Object)query);
        EvitaSessionContract evitaSession = (EvitaSessionContract)environment.getGraphQlContext().get((Object)GraphQLContextKey.EVITA_SESSION);
        List entities = requestExecutedEvent.measureInternalEvitaDBExecution(() -> evitaSession.queryList(query, EntityClassifier.class));
        DataFetcherResult.Builder resultBuilder = DataFetcherResult.newResult().data((Object)entities);
        if (!entities.isEmpty()) {
            resultBuilder.localContext((Object)this.buildResultContext(query));
        }
        return resultBuilder.build();
    }

    @Nullable
    private <A extends Serializable & Comparable<A>> FilterBy buildFilterBy(@Nonnull Arguments arguments) {
        if (arguments.filterBy() == null) {
            return null;
        }
        return (FilterBy)this.filterConstraintResolver.resolve(this.entitySchema.getName(), ListEntitiesHeaderDescriptor.FILTER_BY.name(), arguments.filterBy());
    }

    @Nullable
    private OrderBy buildOrderBy(Arguments arguments) {
        if (arguments.orderBy() == null) {
            return null;
        }
        return (OrderBy)this.orderConstraintResolver.resolve(this.entitySchema.getName(), ListEntitiesHeaderDescriptor.ORDER_BY.name(), arguments.orderBy());
    }

    @Nonnull
    private Require buildRequire(@Nonnull DataFetchingEnvironment environment, @Nonnull Arguments arguments, @Nullable FilterBy filterBy) {
        LinkedList<Strip> requireConstraints = new LinkedList<Strip>();
        Optional<EntityFetch> entityFetch = this.entityFetchRequireResolver.resolveEntityFetch(SelectionSetAggregator.from(environment.getSelectionSet()), ListEntitiesDataFetcher.extractDesiredLocale(filterBy), this.entitySchema);
        entityFetch.ifPresent(requireConstraints::add);
        if (arguments.offset() != null || arguments.limit() != null) {
            requireConstraints.add(QueryConstraints.strip((Integer)Optional.ofNullable(arguments.offset()).orElse(0), (Integer)Optional.ofNullable(arguments.limit()).orElse(20)));
        }
        return QueryConstraints.require((RequireConstraint[])((RequireConstraint[])requireConstraints.toArray(RequireConstraint[]::new)));
    }

    @Nonnull
    private EntityQueryContext buildResultContext(@Nonnull Query query) {
        Locale desiredLocale = Optional.ofNullable((EntityLocaleEquals)QueryUtils.findFilter((Query)query, EntityLocaleEquals.class)).map(EntityLocaleEquals::getLocale).orElse(null);
        Currency desiredPriceInCurrency = Optional.ofNullable((PriceInCurrency)QueryUtils.findFilter((Query)query, PriceInCurrency.class)).map(PriceInCurrency::getCurrency).orElse(null);
        Optional<PriceValidIn> priceValidInConstraint = Optional.ofNullable((PriceValidIn)QueryUtils.findFilter((Query)query, PriceValidIn.class));
        OffsetDateTime desiredPriceValidIn = priceValidInConstraint.map(it -> it.getTheMoment(() -> OffsetDateTime.MIN)).orElse(null);
        String[] desiredPriceInPriceLists = Optional.ofNullable((PriceInPriceLists)QueryUtils.findFilter((Query)query, PriceInPriceLists.class)).map(PriceInPriceLists::getPriceLists).orElse(null);
        return new EntityQueryContext(desiredLocale, desiredPriceInCurrency, desiredPriceInPriceLists, desiredPriceValidIn == OffsetDateTime.MIN ? null : desiredPriceValidIn, desiredPriceValidIn == OffsetDateTime.MIN);
    }

    @Nullable
    private static Locale extractDesiredLocale(@Nullable FilterBy filterBy) {
        return Optional.ofNullable(filterBy).map(it -> (EntityLocaleEquals)QueryUtils.findConstraint((Constraint)it, EntityLocaleEquals.class)).map(EntityLocaleEquals::getLocale).orElse(null);
    }

    private record Arguments(@Nullable Object filterBy, @Nullable Object orderBy, @Nullable Integer offset, @Nullable Integer limit) {
        private static Arguments from(@Nonnull DataFetchingEnvironment environment) {
            Object filterBy = environment.getArgument(ListEntitiesHeaderDescriptor.FILTER_BY.name());
            Object orderBy = environment.getArgument(ListEntitiesHeaderDescriptor.ORDER_BY.name());
            Integer offset = (Integer)environment.getArgument(ListEntitiesHeaderDescriptor.OFFSET.name());
            Integer limit = (Integer)environment.getArgument(ListEntitiesHeaderDescriptor.LIMIT.name());
            return new Arguments(filterBy, orderBy, offset, limit);
        }
    }
}

