/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType.coercing;

import graphql.schema.Coercing;
import graphql.schema.CoercingSerializeException;
import io.evitadb.dataType.BigDecimalNumberRange;
import io.evitadb.dataType.ByteNumberRange;
import io.evitadb.dataType.DateTimeRange;
import io.evitadb.dataType.EvitaDataTypes;
import io.evitadb.dataType.IntegerNumberRange;
import io.evitadb.dataType.LongNumberRange;
import io.evitadb.dataType.Predecessor;
import io.evitadb.dataType.ReferencedEntityPredecessor;
import io.evitadb.dataType.ShortNumberRange;
import io.evitadb.externalApi.graphql.api.dataType.GraphQLScalars;
import io.evitadb.externalApi.graphql.api.dataType.coercing.ObjectCoercing;
import io.evitadb.utils.CollectionUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;

public class AnyCoercing
extends ObjectCoercing {
    private static final Map<Class<?>, Coercing<?, ?>> SERIALIZATION_COERCING_MAPPINGS = CollectionUtils.createHashMap((int)32);

    @Override
    public Object serialize(@Nonnull Object dataFetcherResult) throws CoercingSerializeException {
        Class<?> dataFetcherResultClass = dataFetcherResult.getClass();
        Coercing<?, ?> coercing = dataFetcherResultClass.isPrimitive() ? SERIALIZATION_COERCING_MAPPINGS.get(EvitaDataTypes.getWrappingPrimitiveClass(dataFetcherResultClass)) : SERIALIZATION_COERCING_MAPPINGS.get(dataFetcherResultClass);
        if (coercing == null) {
            throw new CoercingSerializeException("Could not find coercing for value of type `" + dataFetcherResult.getClass().getName() + "`.");
        }
        return coercing.serialize(dataFetcherResult);
    }

    static {
        SERIALIZATION_COERCING_MAPPINGS.put(String.class, GraphQLScalars.STRING_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(Byte.class, GraphQLScalars.BYTE_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(Short.class, GraphQLScalars.SHORT_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(Integer.class, GraphQLScalars.INT_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(Long.class, GraphQLScalars.LONG_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(Boolean.class, GraphQLScalars.BOOLEAN_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(Character.class, GraphQLScalars.STRING_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(BigDecimal.class, GraphQLScalars.BIG_DECIMAL_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(OffsetDateTime.class, GraphQLScalars.OFFSET_DATE_TIME_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(LocalDateTime.class, GraphQLScalars.LOCAL_DATE_TIME_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(LocalDate.class, GraphQLScalars.LOCAL_DATE_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(LocalTime.class, GraphQLScalars.LOCAL_TIME_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(DateTimeRange.class, GraphQLScalars.DATE_TIME_RANGE_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(BigDecimalNumberRange.class, GraphQLScalars.BIG_DECIMAL_NUMBER_RANGE_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(ByteNumberRange.class, GraphQLScalars.BYTE_NUMBER_RANGE_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(ShortNumberRange.class, GraphQLScalars.SHORT_NUMBER_RANGE_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(IntegerNumberRange.class, GraphQLScalars.INTEGER_NUMBER_RANGE_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(LongNumberRange.class, GraphQLScalars.LONG_NUMBER_RANGE_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(Locale.class, GraphQLScalars.LOCALE_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(Currency.class, GraphQLScalars.CURRENCY_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(UUID.class, GraphQLScalars.UUID_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(Predecessor.class, GraphQLScalars.PREDECESSOR_COERCING);
        SERIALIZATION_COERCING_MAPPINGS.put(ReferencedEntityPredecessor.class, GraphQLScalars.REFERENCED_ENTITY_PREDECESSOR_COERCING);
    }
}

