/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType.coercing;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import io.evitadb.dataType.EvitaDataTypes;
import io.evitadb.externalApi.graphql.api.catalog.dataApi.dto.FormattableBigDecimal;
import java.io.Serializable;
import java.math.BigDecimal;
import javax.annotation.Nonnull;

public class BigDecimalCoercing
implements Coercing<BigDecimal, String> {
    public String serialize(@Nonnull Object dataFetcherResult) throws CoercingSerializeException {
        if (dataFetcherResult instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)dataFetcherResult;
            return EvitaDataTypes.formatValue((Serializable)bigDecimal);
        }
        if (dataFetcherResult instanceof FormattableBigDecimal) {
            FormattableBigDecimal formattableBigDecimal = (FormattableBigDecimal)dataFetcherResult;
            return formattableBigDecimal.toFormattedString();
        }
        throw new CoercingSerializeException("Big decimal data fetcher result is not a form of big decimal value.");
    }

    @Nonnull
    public BigDecimal parseValue(@Nonnull Object input) throws CoercingParseValueException {
        if (!(input instanceof String)) {
            throw new CoercingParseValueException("Big decimal input is not a string.");
        }
        try {
            return new BigDecimal((String)input);
        }
        catch (NumberFormatException ex) {
            throw new CoercingParseValueException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Nonnull
    public BigDecimal parseLiteral(@Nonnull Object input) throws CoercingParseLiteralException {
        if (!(input instanceof StringValue)) {
            throw new CoercingParseLiteralException("Big decimal input is not a StringValue.");
        }
        try {
            return new BigDecimal(((StringValue)input).getValue());
        }
        catch (NumberFormatException ex) {
            throw new CoercingParseLiteralException(ex.getMessage(), (Throwable)ex);
        }
    }
}

