/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.api.dataType.coercing;

import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import java.time.DateTimeException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import javax.annotation.Nonnull;

public class LocalTimeCoercing
implements Coercing<LocalTime, String> {
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_TIME;

    public String serialize(@Nonnull Object dataFetcherResult) throws CoercingSerializeException {
        if (!(dataFetcherResult instanceof LocalTime)) {
            throw new CoercingSerializeException("Local time data fetcher result is not a local date.");
        }
        try {
            return ((LocalTime)dataFetcherResult).truncatedTo(ChronoUnit.MILLIS).format(FORMATTER);
        }
        catch (DateTimeException ex) {
            throw new CoercingSerializeException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Nonnull
    public LocalTime parseValue(@Nonnull Object input) throws CoercingParseValueException {
        if (!(input instanceof String)) {
            throw new CoercingParseValueException("Local time input is not a string.");
        }
        try {
            return LocalTime.parse((String)input, FORMATTER).truncatedTo(ChronoUnit.MILLIS);
        }
        catch (DateTimeParseException ex) {
            throw new CoercingParseValueException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Nonnull
    public LocalTime parseLiteral(@Nonnull Object input) throws CoercingParseLiteralException {
        if (!(input instanceof StringValue)) {
            throw new CoercingParseValueException("Local time input is not a StringValue.");
        }
        try {
            return LocalTime.parse(((StringValue)input).getValue(), FORMATTER).truncatedTo(ChronoUnit.MILLIS);
        }
        catch (DateTimeParseException ex) {
            throw new CoercingParseLiteralException(ex.getMessage(), (Throwable)ex);
        }
    }
}

