/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.graphql.metric.event.instance;

import io.evitadb.api.configuration.metric.MetricType;
import io.evitadb.api.observability.annotation.ExportInvocationMetric;
import io.evitadb.api.observability.annotation.ExportMetric;
import io.evitadb.api.observability.annotation.ExportMetricLabel;
import io.evitadb.api.observability.annotation.HistogramSettings;
import io.evitadb.externalApi.graphql.io.GraphQLInstanceType;
import io.evitadb.externalApi.graphql.metric.event.instance.AbstractGraphQLInstanceEvent;
import javax.annotation.Nonnull;
import jdk.jfr.Description;
import jdk.jfr.Label;
import jdk.jfr.Name;

@Name(value="io.evitadb.externalApi.graphql.instance.Built")
@Description(value="Event that is fired when a GraphQL instance is built.")
@ExportInvocationMetric(label="GraphQL instance built total")
@Label(value="GraphQL instance built")
public class BuiltEvent
extends AbstractGraphQLInstanceEvent {
    @Label(value="GraphQL instance type")
    @Description(value="Domain of the GraphQL API used in connection with this event/metric: SYSTEM, SCHEMA, or DATA")
    @ExportMetricLabel
    @Nonnull
    private final String graphQLInstanceType;
    @Label(value="Build type")
    @Description(value="Type of the instance build: NEW or REFRESH")
    @ExportMetricLabel
    @Nonnull
    private final String buildType;
    @Label(value="Catalog")
    @Description(value="The name of the catalog to which this event/metric is associated.")
    @ExportMetricLabel
    @Nonnull
    private final String catalogName;
    @Label(value="API build duration")
    @Description(value="Duration of build of a single API in milliseconds.")
    @ExportMetric(metricType=MetricType.HISTOGRAM)
    @HistogramSettings(factor=2.5)
    private final long graphQLInstanceBuildDurationMilliseconds;
    @Label(value="GraphQL schema build duration")
    @Description(value="Duration of build of a single GraphQL API schema in milliseconds.")
    @ExportMetric(metricType=MetricType.HISTOGRAM)
    @HistogramSettings(factor=2.5)
    private final long graphQLSchemaBuildDurationMilliseconds;
    @Label(value="Number of lines")
    @Description(value="Number of lines generated in the built GraphQL schema DSL.")
    @ExportMetric(metricType=MetricType.GAUGE)
    private final long graphQLSchemaDslLines;

    public BuiltEvent(@Nonnull GraphQLInstanceType graphQLInstanceType, @Nonnull BuildType buildType, long graphQLInstanceBuildDurationMilliseconds, long graphQLSchemaBuildDurationMilliseconds, long graphQLSchemaDslLines) {
        this(null, graphQLInstanceType, buildType, graphQLInstanceBuildDurationMilliseconds, graphQLSchemaBuildDurationMilliseconds, graphQLSchemaDslLines);
    }

    public BuiltEvent(@Nonnull String catalogName, @Nonnull GraphQLInstanceType graphQLInstanceType, @Nonnull BuildType buildType, long graphQLInstanceBuildDurationMilliseconds, long graphQLSchemaBuildDurationMilliseconds, long graphQLSchemaDslLines) {
        this.catalogName = catalogName;
        this.graphQLInstanceType = graphQLInstanceType.name();
        this.buildType = buildType.name();
        this.graphQLInstanceBuildDurationMilliseconds = graphQLInstanceBuildDurationMilliseconds;
        this.graphQLSchemaBuildDurationMilliseconds = graphQLSchemaBuildDurationMilliseconds;
        this.graphQLSchemaDslLines = graphQLSchemaDslLines;
    }

    @Nonnull
    public String getGraphQLInstanceType() {
        return this.graphQLInstanceType;
    }

    @Nonnull
    public String getBuildType() {
        return this.buildType;
    }

    @Nonnull
    public String getCatalogName() {
        return this.catalogName;
    }

    public long getGraphQLInstanceBuildDurationMilliseconds() {
        return this.graphQLInstanceBuildDurationMilliseconds;
    }

    public long getGraphQLSchemaBuildDurationMilliseconds() {
        return this.graphQLSchemaBuildDurationMilliseconds;
    }

    public long getGraphQLSchemaDslLines() {
        return this.graphQLSchemaDslLines;
    }

    public static enum BuildType {
        NEW,
        REFRESH;

    }
}

