/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.grpc;

import io.evitadb.externalApi.grpc.configuration.GrpcConfig;
import io.evitadb.externalApi.grpc.exception.GrpcServerStartFailedException;
import io.evitadb.externalApi.http.ExternalApiProvider;
import io.evitadb.utils.NetworkUtils;
import io.grpc.Server;
import java.io.IOException;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class GrpcProvider
implements ExternalApiProvider<GrpcConfig> {
    public static final String CODE = "gRPC";
    @Nonnull
    private final GrpcConfig configuration;
    private final Server server;
    private String reachableUrl;

    @Nonnull
    public String getCode() {
        return CODE;
    }

    public boolean isManagedByUndertow() {
        return false;
    }

    public void afterStart() {
        try {
            this.server.start();
        }
        catch (IOException e) {
            throw new GrpcServerStartFailedException("Failed to start gRPC server due to: " + e.getMessage(), "Failed to start gRPC server.", e);
        }
    }

    public void beforeStop() {
        this.server.shutdown();
    }

    public boolean isReady() {
        Predicate<String> isReady = url -> {
            int responseCode = NetworkUtils.getHttpStatusCode((String)url, (String)"GET", (String)"application/grpc").orElse(-1);
            return responseCode == 405;
        };
        String[] baseUrls = this.configuration.getBaseUrls(this.configuration.getExposedHost());
        if (this.reachableUrl == null) {
            for (String baseUrl : baseUrls) {
                if (!isReady.test(baseUrl)) continue;
                this.reachableUrl = baseUrl;
                return true;
            }
            return false;
        }
        return isReady.test(this.reachableUrl);
    }

    public GrpcProvider(@Nonnull GrpcConfig configuration, Server server) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.configuration = configuration;
        this.server = server;
    }

    @Nonnull
    public GrpcConfig getConfiguration() {
        return this.configuration;
    }

    public Server getServer() {
        return this.server;
    }
}

