/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.grpc.builders.query.extraResults;

import io.evitadb.api.requestResponse.EvitaResponse;
import io.evitadb.api.requestResponse.EvitaResponseExtraResult;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.api.requestResponse.extraResult.AttributeHistogram;
import io.evitadb.api.requestResponse.extraResult.FacetSummary;
import io.evitadb.api.requestResponse.extraResult.Hierarchy;
import io.evitadb.api.requestResponse.extraResult.PriceHistogram;
import io.evitadb.api.requestResponse.extraResult.QueryTelemetry;
import io.evitadb.externalApi.grpc.builders.query.extraResults.GrpcFacetSummaryBuilder;
import io.evitadb.externalApi.grpc.builders.query.extraResults.GrpcHierarchyStatisticsBuilder;
import io.evitadb.externalApi.grpc.builders.query.extraResults.GrpcHistogramBuilder;
import io.evitadb.externalApi.grpc.builders.query.extraResults.GrpcQueryTelemetryBuilder;
import io.evitadb.externalApi.grpc.generated.GrpcExtraResults;
import io.evitadb.externalApi.grpc.generated.GrpcHistogram;
import java.util.Map;
import javax.annotation.Nonnull;

public class GrpcExtraResultsBuilder {
    @Nonnull
    public static <T extends EntityClassifier> GrpcExtraResults buildExtraResults(@Nonnull EvitaResponse<T> evitaResponse) {
        GrpcExtraResults.Builder extraResults = GrpcExtraResults.newBuilder();
        evitaResponse.getExtraResultTypes().forEach(extraResultType -> {
            EvitaResponseExtraResult extraResult = evitaResponse.getExtraResult(extraResultType);
            if (extraResult instanceof AttributeHistogram) {
                AttributeHistogram erHistogram = (AttributeHistogram)extraResult;
                Map<String, GrpcHistogram> attributeHistograms = GrpcHistogramBuilder.buildAttributeHistogram(erHistogram);
                extraResults.putAllAttributeHistogram(attributeHistograms);
            } else if (extraResult instanceof PriceHistogram) {
                PriceHistogram erHistogram = (PriceHistogram)extraResult;
                extraResults.setPriceHistogram(GrpcHistogramBuilder.buildPriceHistogram(erHistogram));
            } else if (extraResult instanceof FacetSummary) {
                FacetSummary erFacetSummary = (FacetSummary)extraResult;
                GrpcFacetSummaryBuilder.buildFacetSummary(extraResults, erFacetSummary);
            } else if (extraResult instanceof Hierarchy) {
                Hierarchy erHierarchy = (Hierarchy)extraResult;
                GrpcHierarchyStatisticsBuilder.buildHierarchy(extraResults, erHierarchy);
            } else if (extraResult instanceof QueryTelemetry) {
                QueryTelemetry erQueryTelemetry = (QueryTelemetry)extraResult;
                extraResults.setQueryTelemetry(GrpcQueryTelemetryBuilder.buildQueryTelemetry(erQueryTelemetry));
            }
        });
        return extraResults.build();
    }

    private GrpcExtraResultsBuilder() {
    }
}

