/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.grpc.builders.query.extraResults;

import com.google.protobuf.Int32Value;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.api.requestResponse.data.SealedEntity;
import io.evitadb.api.requestResponse.data.structure.EntityReference;
import io.evitadb.api.requestResponse.extraResult.FacetSummary;
import io.evitadb.externalApi.grpc.generated.GrpcEntityReference;
import io.evitadb.externalApi.grpc.generated.GrpcExtraResults;
import io.evitadb.externalApi.grpc.generated.GrpcFacetGroupStatistics;
import io.evitadb.externalApi.grpc.generated.GrpcFacetStatistics;
import io.evitadb.externalApi.grpc.requestResponse.data.EntityConverter;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;

public class GrpcFacetSummaryBuilder {
    public static void buildFacetSummary(@Nonnull GrpcExtraResults.Builder extraResults, @Nonnull FacetSummary facetSummary) {
        Collection originalGroupStatistics = facetSummary.getReferenceStatistics();
        ArrayList<GrpcFacetGroupStatistics> facetGroupStatistics = new ArrayList<GrpcFacetGroupStatistics>(originalGroupStatistics.size());
        for (FacetSummary.FacetGroupStatistics groupStatistics : originalGroupStatistics) {
            Collection originalFacetStatistics = groupStatistics.getFacetStatistics();
            ArrayList<GrpcFacetStatistics> facetStatistics = new ArrayList<GrpcFacetStatistics>(originalFacetStatistics.size());
            for (FacetSummary.FacetStatistics facetStatistic : originalFacetStatistics) {
                GrpcFacetStatistics.Builder statisticsBuilder = GrpcFacetStatistics.newBuilder().setRequested(facetStatistic.isRequested()).setCount(facetStatistic.getCount());
                EntityClassifier entityClassifier = facetStatistic.getFacetEntity();
                if (entityClassifier instanceof EntityReference) {
                    EntityReference entityReference = (EntityReference)entityClassifier;
                    statisticsBuilder.setFacetEntityReference(GrpcEntityReference.newBuilder().setEntityType(entityReference.getType()).setPrimaryKey(entityReference.getPrimaryKey().intValue()));
                } else {
                    entityClassifier = facetStatistic.getFacetEntity();
                    if (entityClassifier instanceof SealedEntity) {
                        SealedEntity entity = (SealedEntity)entityClassifier;
                        statisticsBuilder.setFacetEntity(EntityConverter.toGrpcSealedEntity((SealedEntity)entity));
                    }
                }
                if (facetStatistic.getImpact() != null) {
                    statisticsBuilder.setImpact(Int32Value.newBuilder().setValue(facetStatistic.getImpact().difference()).build());
                    statisticsBuilder.setMatchCount(Int32Value.newBuilder().setValue(facetStatistic.getImpact().matchCount()).build());
                }
                GrpcFacetStatistics statistics = statisticsBuilder.build();
                facetStatistics.add(statistics);
            }
            GrpcFacetGroupStatistics.Builder groupStatisticBuilder = GrpcFacetGroupStatistics.newBuilder().setReferenceName(groupStatistics.getReferenceName()).setCount(groupStatistics.getCount()).addAllFacetStatistics(facetStatistics);
            if (groupStatistics.getGroupEntity() != null) {
                EntityClassifier entityClassifier = groupStatistics.getGroupEntity();
                if (entityClassifier instanceof EntityReference) {
                    EntityReference entityReference = (EntityReference)entityClassifier;
                    groupStatisticBuilder.setGroupEntityReference(GrpcEntityReference.newBuilder().setEntityType(entityReference.getType()).setPrimaryKey(entityReference.getPrimaryKey().intValue()));
                } else {
                    entityClassifier = groupStatistics.getGroupEntity();
                    if (entityClassifier instanceof SealedEntity) {
                        SealedEntity entity = (SealedEntity)entityClassifier;
                        groupStatisticBuilder.setGroupEntity(EntityConverter.toGrpcSealedEntity((SealedEntity)entity));
                    }
                }
            }
            facetGroupStatistics.add(groupStatisticBuilder.build());
        }
        extraResults.addAllFacetGroupStatistics(facetGroupStatistics);
    }

    private GrpcFacetSummaryBuilder() {
    }
}

