/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.grpc.builders.query.extraResults;

import com.google.protobuf.Int32Value;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.api.requestResponse.data.SealedEntity;
import io.evitadb.api.requestResponse.data.structure.EntityReference;
import io.evitadb.api.requestResponse.extraResult.Hierarchy;
import io.evitadb.externalApi.grpc.generated.GrpcEntityReference;
import io.evitadb.externalApi.grpc.generated.GrpcExtraResults;
import io.evitadb.externalApi.grpc.generated.GrpcHierarchy;
import io.evitadb.externalApi.grpc.generated.GrpcLevelInfo;
import io.evitadb.externalApi.grpc.generated.GrpcLevelInfos;
import io.evitadb.externalApi.grpc.requestResponse.data.EntityConverter;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;

public class GrpcHierarchyStatisticsBuilder {
    public static void buildHierarchy(@Nonnull GrpcExtraResults.Builder extraResults, @Nonnull Hierarchy hierarchy) {
        Map hierarchyIndex = hierarchy.getSelfHierarchy();
        if (!hierarchyIndex.isEmpty()) {
            extraResults.setSelfHierarchy(GrpcHierarchyStatisticsBuilder.buildHierarchy(hierarchy.getSelfHierarchy()));
        }
        for (Map.Entry hierarchyIndexOfReference : hierarchy.getReferenceHierarchies().entrySet()) {
            extraResults.putHierarchy((String)hierarchyIndexOfReference.getKey(), GrpcHierarchyStatisticsBuilder.buildHierarchy((Map)hierarchyIndexOfReference.getValue()));
        }
    }

    @Nonnull
    public static GrpcHierarchy buildHierarchy(@Nonnull Map<String, List<Hierarchy.LevelInfo>> hierarchies) {
        GrpcHierarchy.Builder builder = GrpcHierarchy.newBuilder();
        if (!hierarchies.isEmpty()) {
            for (Map.Entry<String, List<Hierarchy.LevelInfo>> entry : hierarchies.entrySet()) {
                builder.putHierarchy(entry.getKey(), GrpcHierarchyStatisticsBuilder.buildLevelInfos(entry.getValue()));
            }
        }
        return builder.build();
    }

    @Nonnull
    public static GrpcLevelInfos buildLevelInfos(@Nonnull List<Hierarchy.LevelInfo> levelInfos) {
        GrpcLevelInfos.Builder builder = GrpcLevelInfos.newBuilder();
        for (Hierarchy.LevelInfo levelInfo : levelInfos) {
            builder.addLevelInfos(GrpcHierarchyStatisticsBuilder.buildLevelInfo(levelInfo));
        }
        return builder.build();
    }

    @Nonnull
    private static GrpcLevelInfo buildLevelInfo(@Nonnull Hierarchy.LevelInfo levelInfo) {
        LinkedList<GrpcLevelInfo> children = new LinkedList<GrpcLevelInfo>();
        if (!levelInfo.children().isEmpty()) {
            for (Hierarchy.LevelInfo child : levelInfo.children()) {
                children.add(GrpcHierarchyStatisticsBuilder.buildLevelInfo(child));
            }
        }
        GrpcLevelInfo.Builder grpcLevelInfoBuilder = GrpcLevelInfo.newBuilder();
        Optional.ofNullable(levelInfo.queriedEntityCount()).ifPresent(it -> grpcLevelInfoBuilder.setQueriedEntityCount(Int32Value.of((int)it)));
        Optional.ofNullable(levelInfo.childrenCount()).ifPresent(it -> grpcLevelInfoBuilder.setChildrenCount(Int32Value.of((int)it)));
        grpcLevelInfoBuilder.setRequested(levelInfo.requested());
        grpcLevelInfoBuilder.addAllItems(children);
        EntityClassifier entityClassifier = levelInfo.entity();
        if (entityClassifier instanceof SealedEntity) {
            SealedEntity entity = (SealedEntity)entityClassifier;
            grpcLevelInfoBuilder.setEntity(EntityConverter.toGrpcSealedEntity((SealedEntity)entity));
        } else {
            entityClassifier = levelInfo.entity();
            if (entityClassifier instanceof EntityReference) {
                EntityReference entityReference = (EntityReference)entityClassifier;
                grpcLevelInfoBuilder.setEntityReference(GrpcEntityReference.newBuilder().setPrimaryKey(entityReference.getPrimaryKey().intValue()).setEntityType(entityReference.getType()).build());
            }
        }
        return grpcLevelInfoBuilder.build();
    }

    private GrpcHierarchyStatisticsBuilder() {
    }
}

