/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.grpc.builders.query.extraResults;

import io.evitadb.api.requestResponse.extraResult.AttributeHistogram;
import io.evitadb.api.requestResponse.extraResult.HistogramContract;
import io.evitadb.api.requestResponse.extraResult.PriceHistogram;
import io.evitadb.externalApi.grpc.dataType.EvitaDataTypesConverter;
import io.evitadb.externalApi.grpc.generated.GrpcHistogram;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class GrpcHistogramBuilder {
    @Nonnull
    public static Map<String, GrpcHistogram> buildAttributeHistogram(@Nonnull AttributeHistogram histograms) {
        HashMap<String, GrpcHistogram> computedHistograms = new HashMap<String, GrpcHistogram>();
        for (Map.Entry histogram : histograms.getHistograms().entrySet()) {
            computedHistograms.put((String)histogram.getKey(), GrpcHistogramBuilder.buildHistogram((HistogramContract)histogram.getValue()));
        }
        return computedHistograms;
    }

    @Nonnull
    public static GrpcHistogram buildPriceHistogram(PriceHistogram histogram) {
        return GrpcHistogramBuilder.buildHistogram((HistogramContract)histogram);
    }

    @Nonnull
    private static GrpcHistogram buildHistogram(HistogramContract histogram) {
        HistogramContract.Bucket[] originalBuckets = histogram.getBuckets();
        ArrayList buckets = new ArrayList(originalBuckets.length);
        Arrays.stream(originalBuckets).forEach(bucket -> buckets.add(GrpcHistogram.GrpcBucket.newBuilder().setThreshold(EvitaDataTypesConverter.toGrpcBigDecimal((BigDecimal)bucket.threshold())).setOccurrences(bucket.occurrences()).setRequested(bucket.requested()).build()));
        return GrpcHistogram.newBuilder().setMin(EvitaDataTypesConverter.toGrpcBigDecimal((BigDecimal)histogram.getMin())).setMax(EvitaDataTypesConverter.toGrpcBigDecimal((BigDecimal)histogram.getMax())).setOverallCount(histogram.getOverallCount()).addAllBuckets(buckets).build();
    }

    private GrpcHistogramBuilder() {
    }
}

