/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.grpc.builders.query.extraResults;

import io.evitadb.api.requestResponse.extraResult.QueryTelemetry;
import io.evitadb.externalApi.grpc.generated.GrpcQueryTelemetry;
import io.evitadb.externalApi.grpc.requestResponse.EvitaEnumConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class GrpcQueryTelemetryBuilder {
    @Nonnull
    public static GrpcQueryTelemetry buildQueryTelemetry(@Nonnull QueryTelemetry queryTelemetry) {
        ArrayList<GrpcQueryTelemetry> queryTelemetrySteps = new ArrayList<GrpcQueryTelemetry>();
        for (QueryTelemetry step : queryTelemetry.getSteps()) {
            queryTelemetrySteps.addAll(GrpcQueryTelemetryBuilder.buildQueryTelemetrySteps(step));
        }
        return GrpcQueryTelemetryBuilder.buildSingleGrpcQueryTelemetry(queryTelemetry, queryTelemetrySteps);
    }

    @Nonnull
    private static List<GrpcQueryTelemetry> buildQueryTelemetrySteps(@Nonnull QueryTelemetry queryTelemetry) {
        LinkedList<GrpcQueryTelemetry> children = new LinkedList<GrpcQueryTelemetry>();
        LinkedList<GrpcQueryTelemetry> steps = new LinkedList<GrpcQueryTelemetry>();
        if (!queryTelemetry.getSteps().isEmpty()) {
            for (QueryTelemetry step : queryTelemetry.getSteps()) {
                children.addAll(GrpcQueryTelemetryBuilder.buildQueryTelemetrySteps(step));
            }
        }
        steps.add(GrpcQueryTelemetryBuilder.buildSingleGrpcQueryTelemetry(queryTelemetry, children));
        return steps;
    }

    @Nonnull
    private static GrpcQueryTelemetry buildSingleGrpcQueryTelemetry(@Nonnull QueryTelemetry queryTelemetry, @Nonnull List<GrpcQueryTelemetry> steps) {
        return GrpcQueryTelemetry.newBuilder().setOperation(EvitaEnumConverter.toGrpcQueryPhase((QueryTelemetry.QueryPhase)queryTelemetry.getOperation())).setStart(queryTelemetry.getStart()).addAllSteps(steps).addAllArguments(Arrays.stream(queryTelemetry.getArguments()).map(Objects::toString).toList()).setSpentTime(queryTelemetry.getSpentTime()).build();
    }

    private GrpcQueryTelemetryBuilder() {
    }
}

