/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.grpc.metric.event;

import io.evitadb.api.observability.annotation.ExportDurationMetric;
import io.evitadb.api.observability.annotation.ExportInvocationMetric;
import io.evitadb.api.observability.annotation.ExportMetricLabel;
import io.evitadb.externalApi.grpc.metric.event.AbstractGrpcApiEvent;
import io.grpc.MethodDescriptor;
import javax.annotation.Nonnull;
import jdk.jfr.Description;
import jdk.jfr.Label;
import jdk.jfr.Name;

@Name(value="io.evitadb.api.grpc.GrpcProcedureCalled")
@Description(value="Event that is fired when a gRPC procedure is called.")
@ExportInvocationMetric(label="gRPC procedure called total")
@ExportDurationMetric(label="gRPC procedure called duration")
@Label(value="gRPC procedure called")
public class ProcedureCalledEvent
extends AbstractGrpcApiEvent {
    @Label(value="Name of the service that was called")
    @ExportMetricLabel
    private final String serviceName;
    @Label(value="Name of the procedure that was called")
    @ExportMetricLabel
    private final String procedureName;
    @Label(value="Initiator of the call (client or server)")
    @ExportMetricLabel
    private String initiator;
    @Label(value="State of the response (OK, ERROR, CANCELED)")
    @ExportMetricLabel
    private String responseState;
    private final MethodDescriptor.MethodType methodType;

    public ProcedureCalledEvent(@Nonnull String catalogName, @Nonnull String serviceName, @Nonnull String procedureName, @Nonnull MethodDescriptor.MethodType methodType) {
        super(catalogName);
        this.serviceName = serviceName;
        this.procedureName = procedureName;
        this.methodType = methodType;
        this.responseState = ResponseState.OK.name();
        this.begin();
    }

    public boolean unaryCall() {
        return this.methodType == MethodDescriptor.MethodType.UNARY;
    }

    public boolean streamsRequests() {
        return this.methodType == MethodDescriptor.MethodType.CLIENT_STREAMING || this.methodType == MethodDescriptor.MethodType.BIDI_STREAMING;
    }

    public boolean streamsResponses() {
        return this.methodType == MethodDescriptor.MethodType.SERVER_STREAMING || this.methodType == MethodDescriptor.MethodType.BIDI_STREAMING;
    }

    public void setInitiator(@Nonnull InitiatorType initiator) {
        this.initiator = initiator.name();
    }

    public void setResponseState(@Nonnull ResponseState responseState) {
        this.responseState = responseState.name();
    }

    @Nonnull
    public ProcedureCalledEvent finish() {
        this.end();
        return this;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public String getResponseState() {
        return this.responseState;
    }

    public MethodDescriptor.MethodType getMethodType() {
        return this.methodType;
    }

    public static enum ResponseState {
        OK,
        ERROR,
        CANCELED;

    }

    public static enum InitiatorType {
        CLIENT,
        SERVER;

    }
}

