/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.grpc.services;

import com.google.protobuf.Empty;
import io.evitadb.api.CatalogState;
import io.evitadb.api.EvitaSessionContract;
import io.evitadb.api.SessionTraits;
import io.evitadb.api.requestResponse.schema.mutation.TopLevelCatalogSchemaMutation;
import io.evitadb.api.requestResponse.system.SystemStatus;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.grpc.constants.GrpcHeaders;
import io.evitadb.externalApi.grpc.dataType.EvitaDataTypesConverter;
import io.evitadb.externalApi.grpc.generated.EvitaServiceGrpc;
import io.evitadb.externalApi.grpc.generated.GrpcCatalogNamesResponse;
import io.evitadb.externalApi.grpc.generated.GrpcDefineCatalogRequest;
import io.evitadb.externalApi.grpc.generated.GrpcDefineCatalogResponse;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteCatalogIfExistsRequest;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteCatalogIfExistsResponse;
import io.evitadb.externalApi.grpc.generated.GrpcEvitaServerStatusResponse;
import io.evitadb.externalApi.grpc.generated.GrpcEvitaSessionRequest;
import io.evitadb.externalApi.grpc.generated.GrpcEvitaSessionResponse;
import io.evitadb.externalApi.grpc.generated.GrpcEvitaSessionTerminationRequest;
import io.evitadb.externalApi.grpc.generated.GrpcEvitaSessionTerminationResponse;
import io.evitadb.externalApi.grpc.generated.GrpcRenameCatalogRequest;
import io.evitadb.externalApi.grpc.generated.GrpcRenameCatalogResponse;
import io.evitadb.externalApi.grpc.generated.GrpcReplaceCatalogRequest;
import io.evitadb.externalApi.grpc.generated.GrpcReplaceCatalogResponse;
import io.evitadb.externalApi.grpc.generated.GrpcSessionType;
import io.evitadb.externalApi.grpc.generated.GrpcTopLevelCatalogSchemaMutation;
import io.evitadb.externalApi.grpc.generated.GrpcUpdateEvitaRequest;
import io.evitadb.externalApi.grpc.requestResponse.EvitaEnumConverter;
import io.evitadb.externalApi.grpc.requestResponse.schema.mutation.DelegatingTopLevelCatalogSchemaMutationConverter;
import io.evitadb.externalApi.grpc.requestResponse.schema.mutation.SchemaMutationConverter;
import io.evitadb.externalApi.grpc.services.interceptors.ServerSessionInterceptor;
import io.evitadb.externalApi.trace.ExternalApiTracingContextProvider;
import io.evitadb.utils.UUIDUtil;
import io.grpc.Metadata;
import io.grpc.stub.StreamObserver;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EvitaService
extends EvitaServiceGrpc.EvitaServiceImplBase {
    private static final SchemaMutationConverter<TopLevelCatalogSchemaMutation, GrpcTopLevelCatalogSchemaMutation> CATALOG_SCHEMA_MUTATION_CONVERTER = new DelegatingTopLevelCatalogSchemaMutationConverter();
    @Nonnull
    private final Evita evita;

    @Nullable
    private static SessionTraits.SessionFlags[] getSessionFlags(GrpcSessionType sessionType, boolean rollbackTransactions) {
        ArrayList<SessionTraits.SessionFlags> flags = new ArrayList<SessionTraits.SessionFlags>(3);
        if (rollbackTransactions) {
            flags.add(SessionTraits.SessionFlags.DRY_RUN);
        }
        if (sessionType == GrpcSessionType.READ_WRITE || sessionType == GrpcSessionType.BINARY_READ_WRITE) {
            flags.add(SessionTraits.SessionFlags.READ_WRITE);
        }
        if (sessionType == GrpcSessionType.BINARY_READ_ONLY || sessionType == GrpcSessionType.BINARY_READ_WRITE) {
            flags.add(SessionTraits.SessionFlags.BINARY);
        }
        return flags.isEmpty() ? null : flags.toArray(new SessionTraits.SessionFlags[0]);
    }

    public EvitaService(@Nonnull Evita evita) {
        this.evita = evita;
    }

    public void createReadOnlySession(GrpcEvitaSessionRequest request, StreamObserver<GrpcEvitaSessionResponse> responseObserver) {
        this.createSessionAndBuildResponse(responseObserver, request.getCatalogName(), GrpcSessionType.READ_ONLY, request.getDryRun());
    }

    public void createReadWriteSession(GrpcEvitaSessionRequest request, StreamObserver<GrpcEvitaSessionResponse> responseObserver) {
        this.createSessionAndBuildResponse(responseObserver, request.getCatalogName(), GrpcSessionType.READ_WRITE, request.getDryRun());
    }

    public void createBinaryReadOnlySession(GrpcEvitaSessionRequest request, StreamObserver<GrpcEvitaSessionResponse> responseObserver) {
        this.createSessionAndBuildResponse(responseObserver, request.getCatalogName(), GrpcSessionType.BINARY_READ_ONLY, request.getDryRun());
    }

    public void createBinaryReadWriteSession(GrpcEvitaSessionRequest request, StreamObserver<GrpcEvitaSessionResponse> responseObserver) {
        this.createSessionAndBuildResponse(responseObserver, request.getCatalogName(), GrpcSessionType.BINARY_READ_WRITE, request.getDryRun());
    }

    public void terminateSession(GrpcEvitaSessionTerminationRequest request, StreamObserver<GrpcEvitaSessionTerminationResponse> responseObserver) {
        EvitaService.executeWithClientContext(() -> {
            boolean terminated = this.evita.getSessionById(request.getCatalogName(), UUIDUtil.uuid((String)request.getSessionId())).map(session -> {
                this.evita.terminateSession(session);
                return true;
            }).orElse(false);
            responseObserver.onNext((Object)GrpcEvitaSessionTerminationResponse.newBuilder().setTerminated(terminated).build());
            responseObserver.onCompleted();
        });
    }

    public void getCatalogNames(Empty request, StreamObserver<GrpcCatalogNamesResponse> responseObserver) {
        EvitaService.executeWithClientContext(() -> {
            responseObserver.onNext((Object)GrpcCatalogNamesResponse.newBuilder().addAllCatalogNames((Iterable)this.evita.getCatalogNames()).build());
            responseObserver.onCompleted();
        });
    }

    public void defineCatalog(GrpcDefineCatalogRequest request, StreamObserver<GrpcDefineCatalogResponse> responseObserver) {
        EvitaService.executeWithClientContext(() -> {
            this.evita.defineCatalog(request.getCatalogName());
            responseObserver.onNext((Object)GrpcDefineCatalogResponse.newBuilder().setSuccess(true).build());
            responseObserver.onCompleted();
        });
    }

    public void renameCatalog(GrpcRenameCatalogRequest request, StreamObserver<GrpcRenameCatalogResponse> responseObserver) {
        EvitaService.executeWithClientContext(() -> {
            this.evita.renameCatalog(request.getCatalogName(), request.getNewCatalogName());
            responseObserver.onNext((Object)GrpcRenameCatalogResponse.newBuilder().setSuccess(true).build());
            responseObserver.onCompleted();
        });
    }

    public void replaceCatalog(GrpcReplaceCatalogRequest request, StreamObserver<GrpcReplaceCatalogResponse> responseObserver) {
        EvitaService.executeWithClientContext(() -> {
            this.evita.replaceCatalog(request.getCatalogNameToBeReplacedWith(), request.getCatalogNameToBeReplaced());
            responseObserver.onNext((Object)GrpcReplaceCatalogResponse.newBuilder().setSuccess(true).build());
            responseObserver.onCompleted();
        });
    }

    public void deleteCatalogIfExists(GrpcDeleteCatalogIfExistsRequest request, StreamObserver<GrpcDeleteCatalogIfExistsResponse> responseObserver) {
        EvitaService.executeWithClientContext(() -> {
            boolean success = this.evita.deleteCatalogIfExists(request.getCatalogName());
            responseObserver.onNext((Object)GrpcDeleteCatalogIfExistsResponse.newBuilder().setSuccess(success).build());
            responseObserver.onCompleted();
        });
    }

    public void update(GrpcUpdateEvitaRequest request, StreamObserver<Empty> responseObserver) {
        EvitaService.executeWithClientContext(() -> {
            TopLevelCatalogSchemaMutation[] schemaMutations = (TopLevelCatalogSchemaMutation[])request.getSchemaMutationsList().stream().map(arg_0 -> CATALOG_SCHEMA_MUTATION_CONVERTER.convert(arg_0)).toArray(TopLevelCatalogSchemaMutation[]::new);
            this.evita.update(schemaMutations);
            responseObserver.onNext((Object)Empty.getDefaultInstance());
            responseObserver.onCompleted();
        });
    }

    public void serverStatus(Empty request, StreamObserver<GrpcEvitaServerStatusResponse> responseObserver) {
        EvitaService.executeWithClientContext(() -> {
            SystemStatus systemStatus = this.evita.getSystemStatus();
            responseObserver.onNext((Object)GrpcEvitaServerStatusResponse.newBuilder().setVersion(systemStatus.version()).setStartedAt(EvitaDataTypesConverter.toGrpcOffsetDateTime((OffsetDateTime)systemStatus.startedAt())).setUptime(systemStatus.uptime().toSeconds()).setInstanceId(systemStatus.instanceId()).setCatalogsCorrupted(systemStatus.catalogsCorrupted()).setCatalogsOk(systemStatus.catalogsOk()).build());
            responseObserver.onCompleted();
        });
    }

    private void createSessionAndBuildResponse(@Nonnull StreamObserver<GrpcEvitaSessionResponse> responseObserver, @Nonnull String catalogName, @Nonnull GrpcSessionType sessionType, boolean rollbackTransactions) {
        EvitaService.executeWithClientContext(() -> {
            SessionTraits.SessionFlags[] flags = EvitaService.getSessionFlags(sessionType, rollbackTransactions);
            EvitaSessionContract session = this.evita.createSession(new SessionTraits(catalogName, flags));
            responseObserver.onNext((Object)GrpcEvitaSessionResponse.newBuilder().setSessionId(session.getId().toString()).setCatalogState(EvitaEnumConverter.toGrpcCatalogState((CatalogState)session.getCatalogState())).setSessionType(sessionType).build());
            responseObserver.onCompleted();
        });
    }

    private static void executeWithClientContext(@Nonnull Runnable lambda) {
        Metadata metadata = (Metadata)ServerSessionInterceptor.METADATA.get();
        ExternalApiTracingContextProvider.getContext().executeWithinBlock(GrpcHeaders.getGrpcTraceTaskNameWithMethodName((Metadata)metadata), (Object)metadata, lambda);
    }
}

