/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.grpc.services;

import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.evitadb.api.CatalogContract;
import io.evitadb.api.CatalogState;
import io.evitadb.api.exception.CatalogNotFoundException;
import io.evitadb.api.query.Constraint;
import io.evitadb.api.query.Query;
import io.evitadb.api.query.require.EntityContentRequire;
import io.evitadb.api.query.require.EntityFetch;
import io.evitadb.api.query.visitor.FinderVisitor;
import io.evitadb.api.requestResponse.EvitaRequest;
import io.evitadb.api.requestResponse.EvitaResponse;
import io.evitadb.api.requestResponse.data.DeletedHierarchy;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.api.requestResponse.data.SealedEntity;
import io.evitadb.api.requestResponse.data.mutation.EntityMutation;
import io.evitadb.api.requestResponse.data.structure.BinaryEntity;
import io.evitadb.api.requestResponse.data.structure.EntityReference;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaEditor;
import io.evitadb.api.requestResponse.schema.SealedCatalogSchema;
import io.evitadb.api.requestResponse.schema.SealedEntitySchema;
import io.evitadb.api.requestResponse.schema.mutation.LocalCatalogSchemaMutation;
import io.evitadb.api.requestResponse.schema.mutation.catalog.ModifyEntitySchemaMutation;
import io.evitadb.core.Evita;
import io.evitadb.core.EvitaInternalSessionContract;
import io.evitadb.dataType.DataChunk;
import io.evitadb.dataType.PaginatedList;
import io.evitadb.dataType.StripList;
import io.evitadb.exception.GenericEvitaInternalError;
import io.evitadb.externalApi.grpc.builders.query.extraResults.GrpcExtraResultsBuilder;
import io.evitadb.externalApi.grpc.constants.GrpcHeaders;
import io.evitadb.externalApi.grpc.dataType.EvitaDataTypesConverter;
import io.evitadb.externalApi.grpc.generated.EvitaSessionServiceGrpc;
import io.evitadb.externalApi.grpc.generated.GrpcCatalogSchemaResponse;
import io.evitadb.externalApi.grpc.generated.GrpcCatalogStateResponse;
import io.evitadb.externalApi.grpc.generated.GrpcCloseRequest;
import io.evitadb.externalApi.grpc.generated.GrpcCloseResponse;
import io.evitadb.externalApi.grpc.generated.GrpcCommitBehavior;
import io.evitadb.externalApi.grpc.generated.GrpcDataChunk;
import io.evitadb.externalApi.grpc.generated.GrpcDefineEntitySchemaRequest;
import io.evitadb.externalApi.grpc.generated.GrpcDefineEntitySchemaResponse;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteCollectionRequest;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteCollectionResponse;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteEntitiesRequest;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteEntitiesResponse;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteEntityAndItsHierarchyResponse;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteEntityRequest;
import io.evitadb.externalApi.grpc.generated.GrpcDeleteEntityResponse;
import io.evitadb.externalApi.grpc.generated.GrpcEntityCollectionSizeRequest;
import io.evitadb.externalApi.grpc.generated.GrpcEntityCollectionSizeResponse;
import io.evitadb.externalApi.grpc.generated.GrpcEntityMutation;
import io.evitadb.externalApi.grpc.generated.GrpcEntityReference;
import io.evitadb.externalApi.grpc.generated.GrpcEntityRequest;
import io.evitadb.externalApi.grpc.generated.GrpcEntityResponse;
import io.evitadb.externalApi.grpc.generated.GrpcEntitySchemaRequest;
import io.evitadb.externalApi.grpc.generated.GrpcEntitySchemaResponse;
import io.evitadb.externalApi.grpc.generated.GrpcEntityTypesResponse;
import io.evitadb.externalApi.grpc.generated.GrpcGoLiveAndCloseResponse;
import io.evitadb.externalApi.grpc.generated.GrpcLocalCatalogSchemaMutation;
import io.evitadb.externalApi.grpc.generated.GrpcModifyEntitySchemaMutation;
import io.evitadb.externalApi.grpc.generated.GrpcQueryListResponse;
import io.evitadb.externalApi.grpc.generated.GrpcQueryOneResponse;
import io.evitadb.externalApi.grpc.generated.GrpcQueryRequest;
import io.evitadb.externalApi.grpc.generated.GrpcQueryResponse;
import io.evitadb.externalApi.grpc.generated.GrpcRenameCollectionRequest;
import io.evitadb.externalApi.grpc.generated.GrpcRenameCollectionResponse;
import io.evitadb.externalApi.grpc.generated.GrpcReplaceCollectionRequest;
import io.evitadb.externalApi.grpc.generated.GrpcReplaceCollectionResponse;
import io.evitadb.externalApi.grpc.generated.GrpcTransactionResponse;
import io.evitadb.externalApi.grpc.generated.GrpcUpdateAndFetchCatalogSchemaResponse;
import io.evitadb.externalApi.grpc.generated.GrpcUpdateAndFetchEntitySchemaResponse;
import io.evitadb.externalApi.grpc.generated.GrpcUpdateCatalogSchemaRequest;
import io.evitadb.externalApi.grpc.generated.GrpcUpdateCatalogSchemaResponse;
import io.evitadb.externalApi.grpc.generated.GrpcUpdateEntitySchemaRequest;
import io.evitadb.externalApi.grpc.generated.GrpcUpdateEntitySchemaResponse;
import io.evitadb.externalApi.grpc.generated.GrpcUpsertEntityRequest;
import io.evitadb.externalApi.grpc.generated.GrpcUpsertEntityResponse;
import io.evitadb.externalApi.grpc.requestResponse.EvitaEnumConverter;
import io.evitadb.externalApi.grpc.requestResponse.data.EntityConverter;
import io.evitadb.externalApi.grpc.requestResponse.data.mutation.DelegatingEntityMutationConverter;
import io.evitadb.externalApi.grpc.requestResponse.data.mutation.EntityMutationConverter;
import io.evitadb.externalApi.grpc.requestResponse.schema.CatalogSchemaConverter;
import io.evitadb.externalApi.grpc.requestResponse.schema.EntitySchemaConverter;
import io.evitadb.externalApi.grpc.requestResponse.schema.mutation.DelegatingLocalCatalogSchemaMutationConverter;
import io.evitadb.externalApi.grpc.requestResponse.schema.mutation.SchemaMutationConverter;
import io.evitadb.externalApi.grpc.requestResponse.schema.mutation.catalog.ModifyEntitySchemaMutationConverter;
import io.evitadb.externalApi.grpc.services.interceptors.ServerSessionInterceptor;
import io.evitadb.externalApi.grpc.utils.QueryUtil;
import io.evitadb.externalApi.trace.ExternalApiTracingContextProvider;
import io.evitadb.utils.ArrayUtils;
import io.grpc.Metadata;
import io.grpc.stub.StreamObserver;
import java.lang.invoke.LambdaMetafactory;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvitaSessionService
extends EvitaSessionServiceGrpc.EvitaSessionServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(EvitaSessionService.class);
    private static final SchemaMutationConverter<LocalCatalogSchemaMutation, GrpcLocalCatalogSchemaMutation> CATALOG_SCHEMA_MUTATION_CONVERTER = new DelegatingLocalCatalogSchemaMutationConverter();
    private static final SchemaMutationConverter<ModifyEntitySchemaMutation, GrpcModifyEntitySchemaMutation> ENTITY_SCHEMA_MUTATION_CONVERTER = new ModifyEntitySchemaMutationConverter();
    private static final EntityMutationConverter<EntityMutation, GrpcEntityMutation> ENTITY_MUTATION_CONVERTER = new DelegatingEntityMutationConverter();
    @Nonnull
    private final Evita evita;

    public void getCatalogSchema(Empty request, StreamObserver<GrpcCatalogSchemaResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            SealedCatalogSchema catalogSchema = session.getCatalogSchema();
            responseObserver.onNext((Object)GrpcCatalogSchemaResponse.newBuilder().setCatalogSchema(CatalogSchemaConverter.convert((CatalogSchemaContract)catalogSchema)).build());
            responseObserver.onCompleted();
        });
    }

    public void getCatalogState(Empty request, StreamObserver<GrpcCatalogStateResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            CatalogState catalogState = session.getCatalogState();
            responseObserver.onNext((Object)GrpcCatalogStateResponse.newBuilder().setState(EvitaEnumConverter.toGrpcCatalogState((CatalogState)catalogState)).build());
            responseObserver.onCompleted();
        });
    }

    public void getEntitySchema(GrpcEntitySchemaRequest request, StreamObserver<GrpcEntitySchemaResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            GrpcEntitySchemaResponse.Builder responseBuilder = GrpcEntitySchemaResponse.newBuilder();
            session.getEntitySchema(request.getEntityType()).ifPresent(it -> responseBuilder.setEntitySchema(EntitySchemaConverter.convert((EntitySchemaContract)it)));
            responseObserver.onNext((Object)responseBuilder.build());
            responseObserver.onCompleted();
        });
    }

    public void getAllEntityTypes(Empty request, StreamObserver<GrpcEntityTypesResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            responseObserver.onNext((Object)GrpcEntityTypesResponse.newBuilder().addAllEntityTypes((Iterable)session.getAllEntityTypes()).build());
            responseObserver.onCompleted();
        });
    }

    public void getEntityCollectionSize(GrpcEntityCollectionSizeRequest request, StreamObserver<GrpcEntityCollectionSizeResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            responseObserver.onNext((Object)GrpcEntityCollectionSizeResponse.newBuilder().setSize(session.getEntityCollectionSize(request.getEntityType())).build());
            responseObserver.onCompleted();
        });
    }

    public void deleteCollection(GrpcDeleteCollectionRequest request, StreamObserver<GrpcDeleteCollectionResponse> responseObserver) {
        EvitaInternalSessionContract session = (EvitaInternalSessionContract)ServerSessionInterceptor.SESSION.get();
        responseObserver.onNext((Object)GrpcDeleteCollectionResponse.newBuilder().setDeleted(session.deleteCollection(request.getEntityType())).build());
        responseObserver.onCompleted();
    }

    public void goLiveAndClose(Empty request, StreamObserver<GrpcGoLiveAndCloseResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            boolean success = session == null ? false : session.goLiveAndClose();
            GrpcGoLiveAndCloseResponse response = GrpcGoLiveAndCloseResponse.newBuilder().setSuccess(success).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        });
    }

    public void getEntity(GrpcEntityRequest request, StreamObserver<GrpcEntityResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            String require = request.getRequire();
            EntityContentRequire[] entityContentRequires = require.isEmpty() ? new EntityContentRequire[]{} : QueryUtil.parseEntityRequiredContents(request.getRequire(), request.getPositionalQueryParamsList(), request.getNamedQueryParamsMap(), responseObserver);
            Optional entity = session.getEntity(request.getEntityType(), request.getPrimaryKey(), entityContentRequires);
            GrpcEntityResponse.Builder evitaEntityResponseBuilder = GrpcEntityResponse.newBuilder();
            entity.ifPresent(it -> evitaEntityResponseBuilder.setEntity(EntityConverter.toGrpcSealedEntity((SealedEntity)it)));
            responseObserver.onNext((Object)evitaEntityResponseBuilder.build());
            responseObserver.onCompleted();
        });
    }

    public void updateCatalogSchema(GrpcUpdateCatalogSchemaRequest request, StreamObserver<GrpcUpdateCatalogSchemaResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            LocalCatalogSchemaMutation[] schemaMutations = (LocalCatalogSchemaMutation[])request.getSchemaMutationsList().stream().map(arg_0 -> CATALOG_SCHEMA_MUTATION_CONVERTER.convert(arg_0)).toArray(LocalCatalogSchemaMutation[]::new);
            int newSchemaVersion = session.updateCatalogSchema(schemaMutations);
            GrpcUpdateCatalogSchemaResponse response = GrpcUpdateCatalogSchemaResponse.newBuilder().setVersion(newSchemaVersion).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        });
    }

    public void updateAndFetchCatalogSchema(GrpcUpdateCatalogSchemaRequest request, StreamObserver<GrpcUpdateAndFetchCatalogSchemaResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            LocalCatalogSchemaMutation[] schemaMutations = (LocalCatalogSchemaMutation[])request.getSchemaMutationsList().stream().map(arg_0 -> CATALOG_SCHEMA_MUTATION_CONVERTER.convert(arg_0)).toArray(LocalCatalogSchemaMutation[]::new);
            SealedCatalogSchema newCatalogSchema = session.updateAndFetchCatalogSchema(schemaMutations);
            GrpcUpdateAndFetchCatalogSchemaResponse response = GrpcUpdateAndFetchCatalogSchemaResponse.newBuilder().setCatalogSchema(CatalogSchemaConverter.convert((CatalogSchemaContract)newCatalogSchema)).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        });
    }

    public void defineEntitySchema(GrpcDefineEntitySchemaRequest request, StreamObserver<GrpcDefineEntitySchemaResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            EntitySchemaEditor.EntitySchemaBuilder entitySchemaBuilder = session.defineEntitySchema(request.getEntityType());
            GrpcDefineEntitySchemaResponse response = GrpcDefineEntitySchemaResponse.newBuilder().setEntitySchema(EntitySchemaConverter.convert((EntitySchemaContract)entitySchemaBuilder.toInstance())).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        });
    }

    public void updateEntitySchema(GrpcUpdateEntitySchemaRequest request, StreamObserver<GrpcUpdateEntitySchemaResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            ModifyEntitySchemaMutation schemaMutation = (ModifyEntitySchemaMutation)ENTITY_SCHEMA_MUTATION_CONVERTER.convert((Message)request.getSchemaMutation());
            int newSchemaVersion = session.updateEntitySchema(schemaMutation);
            GrpcUpdateEntitySchemaResponse response = GrpcUpdateEntitySchemaResponse.newBuilder().setVersion(newSchemaVersion).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        });
    }

    public void updateAndFetchEntitySchema(GrpcUpdateEntitySchemaRequest request, StreamObserver<GrpcUpdateAndFetchEntitySchemaResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            ModifyEntitySchemaMutation schemaMutation = (ModifyEntitySchemaMutation)ENTITY_SCHEMA_MUTATION_CONVERTER.convert((Message)request.getSchemaMutation());
            SealedEntitySchema newEntitySchema = session.updateAndFetchEntitySchema(schemaMutation);
            GrpcUpdateAndFetchEntitySchemaResponse response = GrpcUpdateAndFetchEntitySchemaResponse.newBuilder().setEntitySchema(EntitySchemaConverter.convert((EntitySchemaContract)newEntitySchema)).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        });
    }

    public void upsertEntity(GrpcUpsertEntityRequest request, StreamObserver<GrpcUpsertEntityResponse> responseObserver) {
        Object[] entityContentRequires;
        EvitaInternalSessionContract session = (EvitaInternalSessionContract)ServerSessionInterceptor.SESSION.get();
        GrpcUpsertEntityResponse.Builder builder = GrpcUpsertEntityResponse.newBuilder();
        EntityMutation entityMutation = (EntityMutation)ENTITY_MUTATION_CONVERTER.convert((Message)request.getEntityMutation());
        String require = request.getRequire();
        Object[] objectArray = entityContentRequires = require.isEmpty() ? new EntityContentRequire[]{} : QueryUtil.parseEntityRequiredContents(request.getRequire(), request.getPositionalQueryParamsList(), request.getNamedQueryParamsMap(), responseObserver);
        if (ArrayUtils.isEmpty((Object[])entityContentRequires)) {
            EntityReference entityReference = session.upsertEntity(entityMutation);
            builder.setEntityReference(GrpcEntityReference.newBuilder().setEntityType(entityReference.getType()).setPrimaryKey(entityReference.getPrimaryKey().intValue()).build());
        } else {
            SealedEntity updatedEntity = session.upsertAndFetchEntity(entityMutation, (EntityContentRequire[])entityContentRequires);
            builder.setEntity(EntityConverter.toGrpcSealedEntity((SealedEntity)updatedEntity));
        }
        responseObserver.onNext((Object)builder.build());
        responseObserver.onCompleted();
    }

    public void deleteEntity(GrpcDeleteEntityRequest request, StreamObserver<GrpcDeleteEntityResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            boolean deleted;
            Optional entity;
            Object[] entityContentRequires;
            String entityType = request.getEntityType();
            int primaryKey = request.getPrimaryKey().getValue();
            String require = request.getRequire();
            Object[] objectArray = entityContentRequires = require.isEmpty() ? new EntityContentRequire[]{} : QueryUtil.parseEntityRequiredContents(request.getRequire(), request.getPositionalQueryParamsList(), request.getNamedQueryParamsMap(), responseObserver);
            if (ArrayUtils.isEmpty((Object[])entityContentRequires)) {
                entity = Optional.empty();
                deleted = session.deleteEntity(entityType, primaryKey);
            } else {
                entity = session.deleteEntity(entityType, primaryKey, (EntityContentRequire[])entityContentRequires);
                deleted = entity.isPresent();
            }
            GrpcDeleteEntityResponse.Builder response = GrpcDeleteEntityResponse.newBuilder();
            if (deleted) {
                response.setEntityReference(GrpcEntityReference.newBuilder().setEntityType(entityType).setPrimaryKey(primaryKey).build());
            }
            entity.ifPresent(it -> response.setEntity(EntityConverter.toGrpcSealedEntity((SealedEntity)it)));
            responseObserver.onNext((Object)response.build());
            responseObserver.onCompleted();
        });
    }

    public void renameCollection(GrpcRenameCollectionRequest request, StreamObserver<GrpcRenameCollectionResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            boolean renamed = session.renameCollection(request.getEntityType(), request.getNewName());
            GrpcRenameCollectionResponse response = GrpcRenameCollectionResponse.newBuilder().setRenamed(renamed).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        });
    }

    public void replaceCollection(GrpcReplaceCollectionRequest request, StreamObserver<GrpcReplaceCollectionResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            boolean replaced = session.replaceCollection(request.getEntityTypeToBeReplaced(), request.getEntityTypeToBeReplacedWith());
            GrpcReplaceCollectionResponse response = GrpcReplaceCollectionResponse.newBuilder().setReplaced(replaced).build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        });
    }

    public void deleteEntityAndItsHierarchy(GrpcDeleteEntityRequest request, StreamObserver<GrpcDeleteEntityAndItsHierarchyResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            String entityType = request.getEntityType();
            int primaryKey = request.getPrimaryKey().getValue();
            String require = request.getRequire();
            Object[] entityContentRequires = require.isEmpty() ? new EntityContentRequire[]{} : QueryUtil.parseEntityRequiredContents(request.getRequire(), request.getPositionalQueryParamsList(), request.getNamedQueryParamsMap(), responseObserver);
            DeletedHierarchy deletedHierarchy = ArrayUtils.isEmpty((Object[])entityContentRequires) ? new DeletedHierarchy(session.deleteEntityAndItsHierarchy(entityType, primaryKey), null) : session.deleteEntityAndItsHierarchy(entityType, primaryKey, (EntityContentRequire[])entityContentRequires);
            GrpcDeleteEntityAndItsHierarchyResponse.Builder response = GrpcDeleteEntityAndItsHierarchyResponse.newBuilder().setDeletedEntities(deletedHierarchy.deletedEntities());
            Optional.ofNullable((SealedEntity)deletedHierarchy.deletedRootEntity()).ifPresent(it -> response.setDeletedRootEntity(EntityConverter.toGrpcSealedEntity((SealedEntity)it)));
            responseObserver.onNext((Object)response.build());
            responseObserver.onCompleted();
        });
    }

    public void deleteEntities(GrpcDeleteEntitiesRequest request, StreamObserver<GrpcDeleteEntitiesResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(arg_0 -> EvitaSessionService.lambda$deleteEntities$23(request, responseObserver, arg_0));
    }

    public void query(GrpcQueryRequest request, StreamObserver<GrpcQueryResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            Query query = QueryUtil.parseQuery(request.getQuery(), request.getPositionalQueryParamsList(), request.getNamedQueryParamsMap(), responseObserver);
            if (query != null) {
                EvitaRequest evitaRequest = new EvitaRequest(query.normalizeQuery(), OffsetDateTime.now(), EntityClassifier.class, null, EvitaRequest.CONVERSION_NOT_SUPPORTED);
                EvitaResponse evitaResponse = session.query(evitaRequest);
                GrpcQueryResponse.Builder entityBuilder = GrpcQueryResponse.newBuilder();
                DataChunk recordPage = evitaResponse.getRecordPage();
                GrpcDataChunk.Builder dataChunkBuilder = GrpcDataChunk.newBuilder().setTotalRecordCount(evitaResponse.getTotalRecordCount()).setIsFirst(recordPage.isFirst()).setIsLast(recordPage.isLast()).setHasPrevious(recordPage.hasPrevious()).setHasNext(recordPage.hasNext()).setIsSinglePage(recordPage.isSinglePage()).setIsEmpty(recordPage.isEmpty());
                if (recordPage instanceof PaginatedList) {
                    PaginatedList paginatedList = (PaginatedList)recordPage;
                    dataChunkBuilder.getPaginatedListBuilder().setPageNumber(paginatedList.getPageNumber()).setPageSize(paginatedList.getPageSize());
                } else if (recordPage instanceof StripList) {
                    StripList stripList = (StripList)recordPage;
                    dataChunkBuilder.getStripListBuilder().setOffset(stripList.getOffset()).setLimit(stripList.getLimit());
                }
                entityBuilder.setExtraResults(GrpcExtraResultsBuilder.buildExtraResults(evitaResponse));
                EntityFetch entityRequirement = evitaRequest.getEntityRequirement();
                if (entityRequirement != null) {
                    if (session.isBinaryFormat()) {
                        ArrayList binaryEntities = new ArrayList(recordPage.getData().size());
                        recordPage.stream().forEach(e -> binaryEntities.add(EntityConverter.toGrpcBinaryEntity((BinaryEntity)((BinaryEntity)e))));
                        entityBuilder.setRecordPage(dataChunkBuilder.addAllBinaryEntities(binaryEntities).build());
                    } else {
                        ArrayList sealedEntities = new ArrayList(recordPage.getData().size());
                        recordPage.stream().forEach(e -> sealedEntities.add(EntityConverter.toGrpcSealedEntity((SealedEntity)((SealedEntity)e))));
                        entityBuilder.setRecordPage(dataChunkBuilder.addAllSealedEntities(sealedEntities).build());
                    }
                } else {
                    ArrayList entityReferences = new ArrayList(recordPage.getData().size());
                    recordPage.stream().forEach(e -> entityReferences.add(GrpcEntityReference.newBuilder().setEntityType(e.getType()).setPrimaryKey(((EntityReference)e).getPrimaryKey().intValue()).build()));
                    entityBuilder.setRecordPage(dataChunkBuilder.addAllEntityReferences(entityReferences).build()).build();
                }
                responseObserver.onNext((Object)entityBuilder.build());
            }
            responseObserver.onCompleted();
        });
    }

    public void queryOne(GrpcQueryRequest request, StreamObserver<GrpcQueryOneResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            Query query = QueryUtil.parseQuery(request.getQuery(), request.getPositionalQueryParamsList(), request.getNamedQueryParamsMap(), responseObserver);
            if (query != null) {
                EvitaRequest evitaRequest = new EvitaRequest(query, OffsetDateTime.now(), EntityClassifier.class, null, EvitaRequest.CONVERSION_NOT_SUPPORTED);
                GrpcQueryOneResponse.Builder responseBuilder = GrpcQueryOneResponse.newBuilder();
                session.queryOne(evitaRequest).ifPresent(responseEntity -> {
                    if (responseEntity instanceof EntityReference) {
                        EntityReference entityReference = (EntityReference)responseEntity;
                        responseBuilder.setEntityReference(GrpcEntityReference.newBuilder().setEntityType(entityReference.getType()).setPrimaryKey(entityReference.getPrimaryKey().intValue()).build());
                    } else if (responseEntity instanceof SealedEntity) {
                        SealedEntity sealedEntity = (SealedEntity)responseEntity;
                        responseBuilder.setSealedEntity(EntityConverter.toGrpcSealedEntity((SealedEntity)sealedEntity));
                    } else if (responseEntity instanceof BinaryEntity) {
                        BinaryEntity binaryEntity = (BinaryEntity)responseEntity;
                        responseBuilder.setBinaryEntity(EntityConverter.toGrpcBinaryEntity((BinaryEntity)binaryEntity));
                    } else {
                        throw new GenericEvitaInternalError("Unsupported entity class `" + responseEntity.getClass().getName() + "`.");
                    }
                });
                responseObserver.onNext((Object)responseBuilder.build());
            }
            responseObserver.onCompleted();
        });
    }

    public void queryList(GrpcQueryRequest request, StreamObserver<GrpcQueryListResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            Query query = QueryUtil.parseQuery(request.getQuery(), request.getPositionalQueryParamsList(), request.getNamedQueryParamsMap(), responseObserver);
            if (query != null) {
                EvitaRequest evitaRequest = new EvitaRequest(query, OffsetDateTime.now(), EntityClassifier.class, null, EvitaRequest.CONVERSION_NOT_SUPPORTED);
                List responseEntities = session.queryList(evitaRequest);
                GrpcQueryListResponse.Builder responseBuilder = GrpcQueryListResponse.newBuilder();
                EntityFetch entityFetchRequirement = evitaRequest.getEntityRequirement();
                if (entityFetchRequirement != null) {
                    if (session.isBinaryFormat()) {
                        responseEntities.forEach(e -> responseBuilder.addBinaryEntities(EntityConverter.toGrpcBinaryEntity((BinaryEntity)((BinaryEntity)e))));
                    } else {
                        responseEntities.forEach(entity -> responseBuilder.addSealedEntities(EntityConverter.toGrpcSealedEntity((SealedEntity)((SealedEntity)entity))));
                    }
                } else {
                    responseEntities.forEach(e -> responseBuilder.addEntityReferences(GrpcEntityReference.newBuilder().setEntityType(e.getType()).setPrimaryKey(((EntityReference)e).getPrimaryKey().intValue()).build()));
                }
                responseObserver.onNext((Object)responseBuilder.build());
            }
            responseObserver.onCompleted();
        });
    }

    public void close(GrpcCloseRequest request, StreamObserver<GrpcCloseResponse> responseObserver) {
        EvitaSessionService.executeWithClientContext(session -> {
            if (session != null) {
                CompletableFuture future = session.closeNow(EvitaEnumConverter.toCommitBehavior((GrpcCommitBehavior)request.getCommitBehaviour()));
                future.whenComplete((version, throwable) -> {
                    if (throwable != null) {
                        responseObserver.onError(throwable);
                    } else {
                        responseObserver.onNext((Object)GrpcCloseResponse.newBuilder().setCatalogVersion(version.longValue()).build());
                    }
                    responseObserver.onCompleted();
                });
            } else {
                Optional catalogInstance;
                String catalogName = (String)ServerSessionInterceptor.CATALOG_NAME.get();
                Optional optional = catalogInstance = catalogName == null ? Optional.empty() : this.evita.getCatalogInstance(catalogName);
                if (catalogInstance.isPresent()) {
                    responseObserver.onNext((Object)GrpcCloseResponse.newBuilder().setCatalogVersion(((CatalogContract)catalogInstance.get()).getVersion()).build());
                    responseObserver.onCompleted();
                } else {
                    responseObserver.onError((Throwable)new CatalogNotFoundException(catalogName));
                }
            }
        });
    }

    public void getTransactionId(Empty request, StreamObserver<GrpcTransactionResponse> responseObserver) {
        GrpcTransactionResponse.Builder builder = GrpcTransactionResponse.newBuilder();
        EvitaInternalSessionContract session = (EvitaInternalSessionContract)ServerSessionInterceptor.SESSION.get();
        session.getOpenedTransactionId().ifPresent(txId -> builder.setTransactionId(EvitaDataTypesConverter.toGrpcUuid((UUID)txId)));
        responseObserver.onNext((Object)builder.setCatalogVersion(session.getCatalogVersion()).build());
        responseObserver.onCompleted();
    }

    private static void executeWithClientContext(@Nonnull Consumer<EvitaInternalSessionContract> lambda) {
        Metadata metadata = (Metadata)ServerSessionInterceptor.METADATA.get();
        ExternalApiTracingContextProvider.getContext().executeWithinBlock(GrpcHeaders.getGrpcTraceTaskNameWithMethodName((Metadata)metadata), (Object)metadata, () -> {
            EvitaInternalSessionContract session = (EvitaInternalSessionContract)ServerSessionInterceptor.SESSION.get();
            lambda.accept(session);
        });
    }

    public EvitaSessionService(@Nonnull Evita evita) {
        if (evita == null) {
            throw new NullPointerException("evita is marked non-null but is null");
        }
        this.evita = evita;
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$deleteEntities$23(GrpcDeleteEntitiesRequest request, StreamObserver responseObserver, EvitaInternalSessionContract session) {
        block2: {
            query = QueryUtil.parseQuery(request.getQuery(), request.getPositionalQueryParamsList(), request.getNamedQueryParamsMap(), responseObserver);
            if (query == null) break block2;
            if (query.getRequire() == null) ** GOTO lbl-1000
            if (FinderVisitor.findConstraints((Constraint)query.getRequire(), (Predicate<Constraint>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isInstance(java.lang.Object ), (Lio/evitadb/api/query/Constraint;)Z)(EntityFetch.class)).isEmpty()) lbl-1000:
            // 2 sources

            {
                deletedEntities = session.deleteEntities(query);
                deletedEntityBodies = null;
            } else {
                deletedEntityBodies = session.deleteSealedEntitiesAndReturnBodies(query);
                deletedEntities = deletedEntityBodies.length;
            }
            response = GrpcDeleteEntitiesResponse.newBuilder().setDeletedEntities(deletedEntities);
            Optional.ofNullable(deletedEntityBodies).ifPresent((Consumer<SealedEntity[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$deleteEntities$22(io.evitadb.externalApi.grpc.generated.GrpcDeleteEntitiesResponse$Builder io.evitadb.api.requestResponse.data.SealedEntity[] ), ([Lio/evitadb/api/requestResponse/data/SealedEntity;)V)((GrpcDeleteEntitiesResponse.Builder)response));
            responseObserver.onNext((Object)response.build());
        }
        responseObserver.onCompleted();
    }

    private static /* synthetic */ void lambda$deleteEntities$22(GrpcDeleteEntitiesResponse.Builder response, SealedEntity[] it) {
        Arrays.stream(it).map(EntityConverter::toGrpcSealedEntity).forEach(arg_0 -> ((GrpcDeleteEntitiesResponse.Builder)response).addDeletedEntityBodies(arg_0));
    }
}

