/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.grpc.services.interceptors;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.rpc.ErrorInfo;
import com.google.rpc.Status;
import io.evitadb.exception.EvitaInternalError;
import io.evitadb.exception.EvitaInvalidUsageException;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.StatusProto;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalExceptionHandlerInterceptor
implements ServerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandlerInterceptor.class);

    public <T, R> ServerCall.Listener<T> interceptCall(ServerCall<T, R> serverCall, Metadata headers, ServerCallHandler<T, R> serverCallHandler) {
        ServerCall.Listener delegate = serverCallHandler.startCall(serverCall, headers);
        return new ExceptionHandler<T, R>(delegate, serverCall);
    }

    private static class ExceptionHandler<T, R>
    extends ForwardingServerCallListener.SimpleForwardingServerCallListener<T> {
        private final ServerCall<T, R> delegate;

        ExceptionHandler(@Nonnull ServerCall.Listener<T> listener, @Nonnull ServerCall<T, R> serverCall) {
            super(listener);
            this.delegate = serverCall;
        }

        public void onHalfClose() {
            try {
                super.onHalfClose();
            }
            catch (RuntimeException ex) {
                log.error("Exception occurred during processing of gRPC call", (Throwable)ex);
                this.handleException(ex, this.delegate);
                throw ex;
            }
        }

        private void handleException(@Nonnull RuntimeException exception, @Nonnull ServerCall<T, R> serverCall) {
            if (serverCall.isReady()) {
                Status rpcStatus;
                if (exception instanceof EvitaInvalidUsageException) {
                    EvitaInvalidUsageException invalidUsageException = (EvitaInvalidUsageException)exception;
                    errorInfo = ErrorInfo.newBuilder().setReason(invalidUsageException.getErrorCode() + ": " + invalidUsageException.getPublicMessage()).setDomain(invalidUsageException.getClass().getSimpleName()).build();
                    rpcStatus = Status.newBuilder().setCode(Status.Code.INVALID_ARGUMENT.value()).setMessage(invalidUsageException.getErrorCode() + ": " + invalidUsageException.getPublicMessage()).addDetails(Any.pack((Message)errorInfo)).build();
                } else if (exception instanceof EvitaInternalError) {
                    EvitaInternalError internalError = (EvitaInternalError)exception;
                    errorInfo = ErrorInfo.newBuilder().setReason(internalError.getErrorCode() + ": " + internalError.getPublicMessage()).setDomain(internalError.getClass().getSimpleName()).build();
                    rpcStatus = Status.newBuilder().setCode(Status.Code.INTERNAL.value()).setMessage(internalError.getErrorCode() + ": " + internalError.getPublicMessage()).addDetails(Any.pack((Message)errorInfo)).build();
                } else {
                    rpcStatus = Status.newBuilder().setCode(Status.Code.INTERNAL.value()).build();
                }
                StatusRuntimeException statusRuntimeException = StatusProto.toStatusRuntimeException((Status)rpcStatus);
                io.grpc.Status newStatus = io.grpc.Status.fromThrowable((Throwable)statusRuntimeException);
                Metadata newHeaders = statusRuntimeException.getTrailers();
                serverCall.close(newStatus, newHeaders);
            }
        }
    }
}

