/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.grpc.services.interceptors;

import io.evitadb.externalApi.grpc.metric.event.ProcedureCalledEvent;
import io.evitadb.externalApi.grpc.services.interceptors.ServerSessionInterceptor;
import io.evitadb.externalApi.log.AccessLogMarker;
import io.grpc.Attributes;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.net.InetSocketAddress;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ObservabilityInterceptor
implements ServerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ObservabilityInterceptor.class);
    private static final DateTimeFormatter ACCESS_LOG_DATE_FORMAT = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss Z");
    private static final Marker GRPC_ACCESS_LOG_MARKER = MarkerFactory.getMarker((String)"GRPC_ACCESS_LOG");
    private static final Attributes.Key<String> USER_AGENT = Attributes.Key.create((String)"user-agent");
    private final boolean accessLog;

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        MethodDescriptor methodDescriptor = call.getMethodDescriptor();
        String catalogName = (String)ServerSessionInterceptor.CATALOG_NAME.get();
        ProcedureCalledEvent event = new ProcedureCalledEvent(catalogName, methodDescriptor.getServiceName(), methodDescriptor.getBareMethodName(), methodDescriptor.getType());
        ObservabilityServerCall<ReqT, RespT> loggingServerCall = new ObservabilityServerCall<ReqT, RespT>(call, event, this.accessLog);
        return new ObservabilityListener(next.startCall(loggingServerCall, headers), event);
    }

    public ObservabilityInterceptor(boolean accessLog) {
        this.accessLog = accessLog;
    }

    private static class ObservabilityServerCall<M, R>
    extends ServerCall<M, R> {
        private final ServerCall<M, R> serverCall;
        private final ProcedureCalledEvent event;
        private final boolean accessLog;

        protected ObservabilityServerCall(@Nonnull ServerCall<M, R> serverCall, @Nonnull ProcedureCalledEvent event, boolean accessLog) {
            this.serverCall = serverCall;
            this.event = event;
            this.accessLog = accessLog;
        }

        public void close(Status status, Metadata trailers) {
            if (this.accessLog) {
                log.atInfo().addMarker(AccessLogMarker.getInstance()).addMarker(GRPC_ACCESS_LOG_MARKER).log(ObservabilityServerCall.constructLogMessage(this.serverCall, status));
            }
            this.event.finish().commit();
            this.serverCall.close(status, trailers);
        }

        public void request(int numMessages) {
            this.serverCall.request(numMessages);
        }

        public void sendHeaders(Metadata headers) {
            this.serverCall.sendHeaders(headers);
        }

        public void sendMessage(R message) {
            if (this.event.streamsResponses()) {
                this.event.setInitiator(ProcedureCalledEvent.InitiatorType.SERVER);
            }
            this.serverCall.sendMessage(message);
        }

        public boolean isCancelled() {
            return this.serverCall.isCancelled();
        }

        public MethodDescriptor<M, R> getMethodDescriptor() {
            return this.serverCall.getMethodDescriptor();
        }

        @Nonnull
        private static <ReqT, RespT> String constructLogMessage(@Nonnull ServerCall<ReqT, RespT> call, @Nonnull Status status) {
            String clientIP = ((InetSocketAddress)call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR)).getAddress().getHostName();
            MethodDescriptor.MethodType requestMethodType = call.getMethodDescriptor().getType();
            String requestMethod = call.getMethodDescriptor().getFullMethodName();
            String protocol = "HTTP/2";
            int statusCode = status.getCode().value();
            String userAgent = (String)call.getAttributes().get(USER_AGENT);
            return String.format("%s - - [%s] \"%s %s %s\" %d - \"-\" \"%s\"", clientIP, OffsetDateTime.now().format(ACCESS_LOG_DATE_FORMAT), requestMethodType, requestMethod, "HTTP/2", statusCode, userAgent == null || userAgent.isEmpty() ? "-" : userAgent);
        }
    }

    private static class ObservabilityListener<R>
    extends ForwardingServerCallListener<R> {
        private final ServerCall.Listener<R> delegate;
        private final ProcedureCalledEvent event;

        ObservabilityListener(@Nonnull ServerCall.Listener<R> delegate, @Nonnull ProcedureCalledEvent event) {
            this.delegate = delegate;
            this.event = event;
        }

        protected ServerCall.Listener<R> delegate() {
            return this.delegate;
        }

        public void onHalfClose() {
            try {
                super.onHalfClose();
            }
            catch (RuntimeException ex) {
                this.event.setResponseState(ProcedureCalledEvent.ResponseState.ERROR);
                throw ex;
            }
        }

        public void onCancel() {
            this.event.setResponseState(ProcedureCalledEvent.ResponseState.CANCELED);
            super.onCancel();
        }

        public void onMessage(R request) {
            if (this.event.streamsRequests() || this.event.unaryCall()) {
                this.event.setInitiator(ProcedureCalledEvent.InitiatorType.CLIENT);
            }
            super.onMessage(request);
        }
    }
}

