/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.grpc.services.interceptors;

import io.evitadb.core.Evita;
import io.evitadb.core.EvitaInternalSessionContract;
import io.evitadb.exception.EvitaInvalidUsageException;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import io.evitadb.utils.UUIDUtil;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ServerSessionInterceptor
implements ServerInterceptor {
    private static final Set<String> ENDPOINTS_NOT_REQUIRING_SESSION = CollectionUtils.createHashSet((int)32);
    public static final Context.Key<EvitaInternalSessionContract> SESSION;
    public static final Context.Key<String> CATALOG_NAME;
    public static final Context.Key<Metadata> METADATA;
    private final Evita evita;

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> serverCall, Metadata metadata, ServerCallHandler<ReqT, RespT> serverCallHandler) {
        String sessionId;
        Metadata.Key catalogNameMetadata = Metadata.Key.of((String)"catalogName", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        Metadata.Key sessionMetadata = Metadata.Key.of((String)"sessionId", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
        String catalogName = (String)metadata.get(catalogNameMetadata);
        Optional<EvitaInternalSessionContract> activeSession = this.resolveActiveSession(catalogName, sessionId = (String)metadata.get(sessionMetadata));
        if (activeSession.isEmpty() && ServerSessionInterceptor.isEndpointRequiresSession(serverCall)) {
            Status status = Status.UNAUTHENTICATED.withCause((Throwable)new EvitaInvalidUsageException("Your session is either not set or is not active.")).withDescription("Your session (catalog: " + catalogName + ", session id: " + sessionId + ") is either not set or is not active.");
            serverCall.close(status, metadata);
            return new ServerCall.Listener<ReqT>(){};
        }
        metadata.put(Metadata.Key.of((String)"methodName", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), (Object)serverCall.getMethodDescriptor().getBareMethodName());
        Context context = Context.current();
        if (activeSession.isPresent()) {
            context = context.withValue(SESSION, (Object)activeSession.get());
        }
        context = context.withValue(METADATA, (Object)metadata).withValue(CATALOG_NAME, (Object)catalogName);
        return Contexts.interceptCall((Context)context, serverCall, (Metadata)metadata, serverCallHandler);
    }

    @Nonnull
    private Optional<EvitaInternalSessionContract> resolveActiveSession(@Nullable String catalogName, @Nullable String sessionId) {
        if (catalogName == null && sessionId == null) {
            return Optional.empty();
        }
        Assert.notNull((Object)catalogName, (String)"Both `catalogName` and `sessionId` must be specified to identify session.");
        Assert.notNull((Object)sessionId, (String)"Both `catalogName` and `sessionId` must be specified to identify session.");
        return this.evita.getSessionById(catalogName, UUIDUtil.uuid((String)sessionId)).map(session -> {
            if (!session.isActive()) {
                return null;
            }
            if (!(session instanceof EvitaInternalSessionContract)) {
                return null;
            }
            return (EvitaInternalSessionContract)session;
        });
    }

    private static <ReqT, RespT> boolean isEndpointRequiresSession(@Nonnull ServerCall<ReqT, RespT> serverCall) {
        return !ENDPOINTS_NOT_REQUIRING_SESSION.contains(serverCall.getMethodDescriptor().getFullMethodName());
    }

    public ServerSessionInterceptor(Evita evita) {
        this.evita = evita;
    }

    static {
        ENDPOINTS_NOT_REQUIRING_SESSION.add("io.evitadb.externalApi.grpc.generated.EvitaService/ServerStatus");
        ENDPOINTS_NOT_REQUIRING_SESSION.add("io.evitadb.externalApi.grpc.generated.EvitaService/CreateReadOnlySession");
        ENDPOINTS_NOT_REQUIRING_SESSION.add("io.evitadb.externalApi.grpc.generated.EvitaService/CreateReadWriteSession");
        ENDPOINTS_NOT_REQUIRING_SESSION.add("io.evitadb.externalApi.grpc.generated.EvitaService/CreateBinaryReadOnlySession");
        ENDPOINTS_NOT_REQUIRING_SESSION.add("io.evitadb.externalApi.grpc.generated.EvitaService/CreateBinaryReadWriteSession");
        ENDPOINTS_NOT_REQUIRING_SESSION.add("io.evitadb.externalApi.grpc.generated.EvitaService/TerminateSession");
        ENDPOINTS_NOT_REQUIRING_SESSION.add("io.evitadb.externalApi.grpc.generated.EvitaService/GetCatalogNames");
        ENDPOINTS_NOT_REQUIRING_SESSION.add("io.evitadb.externalApi.grpc.generated.EvitaService/DefineCatalog");
        ENDPOINTS_NOT_REQUIRING_SESSION.add("io.evitadb.externalApi.grpc.generated.EvitaService/RenameCatalog");
        ENDPOINTS_NOT_REQUIRING_SESSION.add("io.evitadb.externalApi.grpc.generated.EvitaService/ReplaceCatalog");
        ENDPOINTS_NOT_REQUIRING_SESSION.add("io.evitadb.externalApi.grpc.generated.EvitaService/DeleteCatalogIfExists");
        ENDPOINTS_NOT_REQUIRING_SESSION.add("io.evitadb.externalApi.grpc.generated.EvitaService/Update");
        ENDPOINTS_NOT_REQUIRING_SESSION.add("io.evitadb.externalApi.grpc.generated.EvitaSessionService/Close");
        ENDPOINTS_NOT_REQUIRING_SESSION.add("io.evitadb.externalApi.grpc.generated.EvitaSessionService/GoLiveAndClose");
        SESSION = Context.key((String)"sessionId");
        CATALOG_NAME = Context.key((String)"catalogName");
        METADATA = Context.key((String)"metadata");
    }
}

