/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.grpc.utils;

import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.rpc.Code;
import com.google.rpc.ErrorInfo;
import com.google.rpc.Status;
import io.evitadb.exception.EvitaError;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.StatusProto;
import java.util.Map;
import javax.annotation.Nonnull;

public class ExceptionStatusProvider {
    private static final String ERROR_DOMAIN = "io.evitadb.externalApi.grpc.services";

    public static StatusRuntimeException getStatus(@Nonnull Throwable exception, @Nonnull Code errorCode, @Nonnull String reason) {
        String string;
        if (exception instanceof EvitaError) {
            EvitaError evitaError = (EvitaError)exception;
            string = evitaError.getPublicMessage();
        } else {
            string = exception.toString();
        }
        String errorMessage = string;
        return StatusProto.toStatusRuntimeException((Status)Status.newBuilder().setCode(errorCode.getNumber()).setMessage(errorMessage).addDetails(Any.pack((Message)ErrorInfo.newBuilder().setReason(reason).setDomain(ERROR_DOMAIN).build())).build());
    }

    public static StatusRuntimeException getStatus(@Nonnull String errorMessage, @Nonnull Code errorCode, @Nonnull String reason, @Nonnull Map<String, String> metadata) {
        return StatusProto.toStatusRuntimeException((Status)Status.newBuilder().setCode(errorCode.getNumber()).setMessage(errorMessage).addDetails(Any.pack((Message)ErrorInfo.newBuilder().setReason(reason).setDomain(ERROR_DOMAIN).putAllMetadata(metadata).build())).build());
    }

    public static StatusRuntimeException getStatus(@Nonnull String errorMessage, @Nonnull Code errorCode, @Nonnull String reason) {
        return StatusProto.toStatusRuntimeException((Status)Status.newBuilder().setCode(errorCode.getNumber()).setMessage(errorMessage).addDetails(Any.pack((Message)ErrorInfo.newBuilder().setReason(reason).setDomain(ERROR_DOMAIN).build())).build());
    }

    private ExceptionStatusProvider() {
    }
}

