/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.grpc.utils;

import io.evitadb.core.Evita;
import io.evitadb.exception.GenericEvitaInternalError;
import io.evitadb.externalApi.certificate.ServerCertificateManager;
import io.evitadb.externalApi.configuration.ApiOptions;
import io.evitadb.externalApi.configuration.CertificatePath;
import io.evitadb.externalApi.configuration.CertificateSettings;
import io.evitadb.externalApi.configuration.HostDefinition;
import io.evitadb.externalApi.configuration.MtlsConfiguration;
import io.evitadb.externalApi.grpc.configuration.GrpcConfig;
import io.evitadb.externalApi.grpc.services.EvitaService;
import io.evitadb.externalApi.grpc.services.EvitaSessionService;
import io.evitadb.externalApi.grpc.services.interceptors.GlobalExceptionHandlerInterceptor;
import io.evitadb.externalApi.grpc.services.interceptors.ObservabilityInterceptor;
import io.evitadb.externalApi.grpc.services.interceptors.ServerSessionInterceptor;
import io.evitadb.utils.CertificateUtils;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerCredentials;
import io.grpc.ServerInterceptor;
import io.grpc.TlsServerCredentials;
import io.grpc.netty.NettyServerBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcServer {
    private static final Logger log = LoggerFactory.getLogger(GrpcServer.class);
    private Server server;

    public GrpcServer(@Nonnull Evita evita, @Nonnull ApiOptions apiOptions, @Nonnull GrpcConfig config) {
        this.setUpServer(evita, apiOptions, config);
    }

    private void setUpServer(@Nonnull Evita evita, @Nonnull ApiOptions apiOptions, @Nonnull GrpcConfig config) {
        ServerCredentials tlsServerCredentials;
        HostDefinition[] hosts = config.getHost();
        CertificatePath certificatePath = ServerCertificateManager.getCertificatePath((CertificateSettings)apiOptions.certificate());
        if (certificatePath.certificate() == null || certificatePath.privateKey() == null) {
            throw new GenericEvitaInternalError("Certificate path is not set.");
        }
        try {
            TlsServerCredentials.Builder tlsServerCredentialsBuilder = TlsServerCredentials.newBuilder();
            tlsServerCredentialsBuilder.keyManager(new File(certificatePath.certificate()), new File(certificatePath.privateKey()), certificatePath.privateKeyPassword());
            MtlsConfiguration mtlsConfiguration = config.getMtlsConfiguration();
            if (mtlsConfiguration != null && Boolean.TRUE.equals(mtlsConfiguration.enabled())) {
                if (apiOptions.certificate().generateAndUseSelfSigned()) {
                    tlsServerCredentialsBuilder.trustManager(apiOptions.certificate().getFolderPath().resolve(CertificateUtils.getGeneratedRootCaCertificateFileName()).toFile());
                }
                tlsServerCredentialsBuilder.clientAuth(TlsServerCredentials.ClientAuth.REQUIRE);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                for (String clientCert : mtlsConfiguration.allowedClientCertificatePaths()) {
                    tlsServerCredentialsBuilder.trustManager((InputStream)new FileInputStream(clientCert));
                    try (FileInputStream in = new FileInputStream(clientCert);){
                        log.info("Whitelisted client's certificate fingerprint: {}", (Object)CertificateUtils.getCertificateFingerprint((Certificate)cf.generateCertificate(in)));
                    }
                }
            } else {
                tlsServerCredentialsBuilder.clientAuth(TlsServerCredentials.ClientAuth.OPTIONAL);
            }
            tlsServerCredentials = tlsServerCredentialsBuilder.build();
        }
        catch (Exception e) {
            throw new GenericEvitaInternalError("Failed to create gRPC server credentials with provided certificate and private key: " + e.getMessage(), "Failed to create gRPC server credentials with provided certificate and private key.", (Throwable)e);
        }
        NettyServerBuilder serverBuilder = (NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(hosts[0].host(), hosts[0].port()), (ServerCredentials)tlsServerCredentials).executor((Executor)evita.getExecutor())).addService((BindableService)new EvitaService(evita))).addService((BindableService)new EvitaSessionService(evita))).intercept((ServerInterceptor)new ObservabilityInterceptor(apiOptions.accessLog()))).intercept((ServerInterceptor)new ServerSessionInterceptor(evita))).intercept((ServerInterceptor)new GlobalExceptionHandlerInterceptor());
        this.server = serverBuilder.build();
    }

    public Server getServer() {
        return this.server;
    }
}

