/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.grpc.utils;

import com.google.protobuf.GeneratedMessageV3;
import com.google.rpc.Code;
import io.evitadb.api.query.Constraint;
import io.evitadb.api.query.Query;
import io.evitadb.api.query.QueryParser;
import io.evitadb.api.query.QueryUtils;
import io.evitadb.api.query.filter.EntityLocaleEquals;
import io.evitadb.api.query.filter.PriceInCurrency;
import io.evitadb.api.query.filter.PriceInPriceLists;
import io.evitadb.api.query.filter.PriceValidIn;
import io.evitadb.api.query.parser.DefaultQueryParser;
import io.evitadb.api.query.require.DataInLocales;
import io.evitadb.api.query.require.EntityContentRequire;
import io.evitadb.api.query.require.EntityFetch;
import io.evitadb.api.query.require.SeparateEntityContentRequireContainer;
import io.evitadb.api.query.visitor.FinderVisitor;
import io.evitadb.exception.EvitaInvalidUsageException;
import io.evitadb.externalApi.grpc.generated.GrpcQueryParam;
import io.evitadb.externalApi.grpc.query.QueryConverter;
import io.evitadb.externalApi.grpc.utils.ExceptionStatusProvider;
import io.grpc.stub.StreamObserver;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Currency;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class QueryUtil {
    private static final QueryParser parser = DefaultQueryParser.getInstance();

    @Nonnull
    public static Set<Locale> getRequiredLocales(@Nonnull Query query) {
        DataInLocales dataRequirement = (DataInLocales)QueryUtils.findRequire((Query)query, DataInLocales.class);
        if (dataRequirement != null) {
            return Arrays.stream(dataRequirement.getLocales()).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        Locale theLocale = Optional.ofNullable((EntityLocaleEquals)QueryUtils.findFilter((Query)query, EntityLocaleEquals.class)).map(EntityLocaleEquals::getLocale).orElse(null);
        if (theLocale != null) {
            return Set.of(theLocale);
        }
        return new HashSet<Locale>(0);
    }

    @Nullable
    public static EntityFetch getEntityFetchRequirement(@Nonnull Query query) {
        if (query.getRequire() == null) {
            return null;
        }
        return (EntityFetch)FinderVisitor.findConstraint((Constraint)query.getRequire(), EntityFetch.class::isInstance, SeparateEntityContentRequireContainer.class::isInstance);
    }

    @Nonnull
    public static <T extends GeneratedMessageV3> EntityContentRequire[] parseEntityRequiredContents(@Nonnull String requireConstraints, @Nonnull List<GrpcQueryParam> queryParams, @Nonnull Map<String, GrpcQueryParam> namedQueryParams, @Nullable StreamObserver<T> responseObserver) {
        try {
            return (EntityContentRequire[])parser.parseRequireConstraintList(requireConstraints, QueryConverter.convertQueryParamsMap(namedQueryParams), QueryConverter.convertQueryParamsList(queryParams)).stream().map(c -> {
                if (!(c instanceof EntityContentRequire)) {
                    throw new EvitaInvalidUsageException("Only content require constraints are supported.");
                }
                return (EntityContentRequire)c;
            }).toArray(EntityContentRequire[]::new);
        }
        catch (EvitaInvalidUsageException ex) {
            if (responseObserver != null) {
                responseObserver.onError((Throwable)ExceptionStatusProvider.getStatus(ex, Code.INVALID_ARGUMENT, "Query parsing error"));
            }
            throw ex;
        }
    }

    @Nullable
    public static <T extends GeneratedMessageV3> Query parseQuery(@Nonnull String queryString, @Nonnull List<GrpcQueryParam> queryParams, @Nullable StreamObserver<T> responseObserver) {
        try {
            return parser.parseQuery(queryString, QueryConverter.convertQueryParamsList(queryParams));
        }
        catch (Exception ex) {
            if (responseObserver != null) {
                responseObserver.onError((Throwable)ExceptionStatusProvider.getStatus(ex, Code.INVALID_ARGUMENT, "Query parsing error"));
            }
            return null;
        }
    }

    @Nullable
    public static <T extends GeneratedMessageV3> Query parseQuery(@Nonnull String queryString, @Nonnull Map<String, GrpcQueryParam> queryParams, @Nullable StreamObserver<T> responseObserver) {
        try {
            return parser.parseQuery(queryString, QueryConverter.convertQueryParamsMap(queryParams));
        }
        catch (Exception ex) {
            if (responseObserver != null) {
                responseObserver.onError((Throwable)ExceptionStatusProvider.getStatus(ex, Code.INVALID_ARGUMENT, "Query parsing error"));
            }
            return null;
        }
    }

    @Nullable
    public static <T extends GeneratedMessageV3> Query parseQuery(@Nonnull String queryString, @Nonnull List<GrpcQueryParam> queryParamsList, @Nonnull Map<String, GrpcQueryParam> queryParamsMap, @Nullable StreamObserver<T> responseObserver) {
        try {
            if (queryParamsList.isEmpty() && queryParamsMap.isEmpty()) {
                return parser.parseQuery(queryString, new Object[0]);
            }
            if (queryParamsList.isEmpty()) {
                return QueryUtil.parseQuery(queryString, queryParamsMap, responseObserver);
            }
            if (queryParamsMap.isEmpty()) {
                return QueryUtil.parseQuery(queryString, queryParamsList, responseObserver);
            }
            return parser.parseQuery(queryString, QueryConverter.convertQueryParamsMap(queryParamsMap), QueryConverter.convertQueryParamsList(queryParamsList));
        }
        catch (Exception ex) {
            if (responseObserver != null) {
                responseObserver.onError((Throwable)ExceptionStatusProvider.getStatus(ex, Code.INVALID_ARGUMENT, "Query parsing error"));
            }
            return null;
        }
    }

    @Nonnull
    public static String[] getPriceLists(@Nonnull Query query) {
        PriceInPriceLists pricesInPriceList = (PriceInPriceLists)QueryUtils.findFilter((Query)query, PriceInPriceLists.class);
        return Optional.ofNullable(pricesInPriceList).map(PriceInPriceLists::getPriceLists).orElse(new String[0]);
    }

    @Nullable
    public static Currency getCurrency(@Nonnull Query query) {
        return Optional.ofNullable((PriceInCurrency)QueryUtils.findFilter((Query)query, PriceInCurrency.class)).map(PriceInCurrency::getCurrency).orElse(null);
    }

    @Nullable
    public static OffsetDateTime getPriceValidIn(@Nonnull Query query, @Nonnull Supplier<OffsetDateTime> currentDateAndTime) {
        return Optional.ofNullable((PriceValidIn)QueryUtils.findFilter((Query)query, PriceValidIn.class)).map(it -> it.getTheMoment(currentDateAndTime)).orElse(null);
    }

    private QueryUtil() {
    }
}

