/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.evitadb.api.CatalogContract;
import io.evitadb.core.CorruptedCatalog;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.http.CorsFilter;
import io.evitadb.externalApi.http.PathNormalizingHandler;
import io.evitadb.externalApi.rest.api.Rest;
import io.evitadb.externalApi.rest.api.catalog.CatalogRestBuilder;
import io.evitadb.externalApi.rest.api.system.SystemRestBuilder;
import io.evitadb.externalApi.rest.configuration.RestConfig;
import io.evitadb.externalApi.rest.exception.OpenApiInternalError;
import io.evitadb.externalApi.rest.io.CorsEndpoint;
import io.evitadb.externalApi.rest.io.RestEndpointHandler;
import io.evitadb.externalApi.rest.io.RestExceptionHandler;
import io.evitadb.externalApi.utils.UriPath;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import io.evitadb.utils.StringUtils;
import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.RoutingHandler;
import io.undertow.server.handlers.BlockingHandler;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestManager {
    private static final Logger log = LoggerFactory.getLogger(RestManager.class);
    @Nonnull
    private final ObjectMapper objectMapper = new ObjectMapper();
    @Nonnull
    private final Evita evita;
    @Nullable
    private final String exposedOn;
    @Nonnull
    private final RestConfig restConfig;
    @Nonnull
    private final Map<String, Set<Rest.Endpoint>> registeredCatalogEndpoints = CollectionUtils.createConcurrentHashMap((int)20);
    private final RoutingHandler restRouter = Handlers.routing();
    @Nonnull
    private final Map<UriPath, CorsEndpoint> corsEndpoints = CollectionUtils.createConcurrentHashMap((int)20);

    public RestManager(@Nonnull Evita evita, @Nullable String exposedOn, @Nonnull RestConfig restConfig) {
        this.evita = evita;
        this.exposedOn = exposedOn;
        this.restConfig = restConfig;
        long buildingStartTime = System.currentTimeMillis();
        this.registerSystemApi();
        this.evita.getCatalogs().forEach(catalog -> this.registerCatalog(catalog.getName()));
        this.corsEndpoints.forEach((path, endpoint) -> this.restRouter.add(Methods.OPTIONS, path.toString(), endpoint.toHandler()));
        log.info("Built REST API in " + StringUtils.formatPreciseNano((long)(System.currentTimeMillis() - buildingStartTime)));
    }

    @Nonnull
    public HttpHandler getRestRouter() {
        return new PathNormalizingHandler((HttpHandler)this.restRouter);
    }

    public void registerCatalog(@Nonnull String catalogName) {
        CatalogContract catalog = this.evita.getCatalogInstanceOrThrowException(catalogName);
        if (catalog instanceof CorruptedCatalog) {
            log.warn("Catalog `" + catalogName + "` is corrupted. Skipping...");
            return;
        }
        Assert.isPremiseValid((!this.registeredCatalogEndpoints.containsKey(catalogName) ? 1 : 0) != 0, () -> new OpenApiInternalError("Catalog `" + catalogName + "` has been already registered."));
        CatalogRestBuilder catalogRestBuilder = new CatalogRestBuilder(this.exposedOn, this.restConfig, this.evita, catalog);
        Rest builtRest = catalogRestBuilder.build();
        builtRest.endpoints().forEach(endpoint -> this.registerCatalogRestEndpoint(catalog, (Rest.Endpoint)endpoint));
    }

    public void unregisterCatalog(@Nonnull String catalogName) {
        CatalogContract catalog = this.evita.getCatalogInstanceOrThrowException(catalogName);
        Set<Rest.Endpoint> endpointsForCatalog = this.registeredCatalogEndpoints.remove(catalogName);
        if (endpointsForCatalog != null) {
            endpointsForCatalog.forEach(endpoint -> {
                String catalogPath = this.constructCatalogPath(catalog, endpoint.path()).toString();
                this.restRouter.remove(endpoint.method(), catalogPath);
                this.corsEndpoints.remove(catalogPath);
                this.restRouter.remove(Methods.OPTIONS, catalogPath);
            });
        }
    }

    public void refreshCatalog(@Nonnull String catalogName) {
        if (!this.registeredCatalogEndpoints.containsKey(catalogName)) {
            log.info("Could not refresh existing catalog `{}`. Registering new one instead...", (Object)catalogName);
            this.registerCatalog(catalogName);
            return;
        }
        CatalogContract catalog = this.evita.getCatalogInstanceOrThrowException(catalogName);
        CatalogRestBuilder catalogRestBuilder = new CatalogRestBuilder(this.exposedOn, this.restConfig, this.evita, catalog);
        Rest builtRest = catalogRestBuilder.build();
        this.unregisterCatalog(catalogName);
        builtRest.endpoints().forEach(endpoint -> this.registerCatalogRestEndpoint(catalog, (Rest.Endpoint)endpoint));
    }

    private void registerSystemApi() {
        SystemRestBuilder systemRestBuilder = new SystemRestBuilder(this.exposedOn, this.restConfig, this.evita);
        Rest builtRest = systemRestBuilder.build();
        builtRest.endpoints().forEach(this::registerSystemRestEndpoint);
    }

    private void registerCatalogRestEndpoint(@Nonnull CatalogContract catalog, @Nonnull Rest.Endpoint endpoint) {
        Set endpointsForCatalog = this.registeredCatalogEndpoints.computeIfAbsent(catalog.getName(), key -> CollectionUtils.createHashSet((int)100));
        endpointsForCatalog.add(endpoint);
        this.registerRestEndpoint(endpoint.method(), this.constructCatalogPath(catalog, endpoint.path()), endpoint.handler());
    }

    private void registerSystemRestEndpoint(@Nonnull Rest.Endpoint endpoint) {
        this.registerRestEndpoint(endpoint.method(), UriPath.of((Object[])new Object[]{"/", "system", endpoint.path()}), endpoint.handler());
    }

    private void registerRestEndpoint(@Nonnull HttpString method, @Nonnull UriPath path, @Nonnull RestEndpointHandler<?> handler) {
        CorsEndpoint corsEndpoint = this.corsEndpoints.computeIfAbsent(path, p -> new CorsEndpoint(this.restConfig));
        corsEndpoint.addMetadataFromHandler(handler);
        this.restRouter.add(method, path.toString(), (HttpHandler)new BlockingHandler((HttpHandler)new CorsFilter((HttpHandler)new RestExceptionHandler(this.objectMapper, (HttpHandler)handler), this.restConfig.getAllowedOrigins())));
    }

    @Nonnull
    private UriPath constructCatalogPath(@Nonnull CatalogContract catalog, @Nonnull UriPath endpointPath) {
        return UriPath.of((Object[])new Object[]{catalog.getSchema().getName(), endpointPath});
    }
}

