/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest;

import io.evitadb.externalApi.http.ExternalApiProvider;
import io.evitadb.externalApi.rest.configuration.RestConfig;
import io.evitadb.utils.NetworkUtils;
import io.undertow.server.HttpHandler;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class RestProvider
implements ExternalApiProvider<RestConfig> {
    public static final String CODE = "rest";
    @Nonnull
    private final RestConfig configuration;
    @Nonnull
    private final HttpHandler apiHandler;
    private String reachableUrl;

    @Nonnull
    public String getCode() {
        return CODE;
    }

    public boolean isReady() {
        Predicate<String> isReady = url -> NetworkUtils.fetchContent((String)url, (String)"GET", (String)"application/json", null).map(content -> content.contains("true")).orElse(false);
        String[] baseUrls = this.configuration.getBaseUrls(this.configuration.getExposedHost());
        if (this.reachableUrl == null) {
            for (String baseUrl : baseUrls) {
                String url2 = baseUrl + "system/liveness";
                if (!isReady.test(url2)) continue;
                this.reachableUrl = url2;
                return true;
            }
            return false;
        }
        return isReady.test(this.reachableUrl);
    }

    public RestProvider(@Nonnull RestConfig configuration, @Nonnull HttpHandler apiHandler) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (apiHandler == null) {
            throw new NullPointerException("apiHandler is marked non-null but is null");
        }
        this.configuration = configuration;
        this.apiHandler = apiHandler;
    }

    @Nonnull
    public RestConfig getConfiguration() {
        return this.configuration;
    }

    @Nonnull
    public HttpHandler getApiHandler() {
        return this.apiHandler;
    }
}

