/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest;

import io.evitadb.api.CatalogStructuralChangeObserver;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.configuration.ApiOptions;
import io.evitadb.externalApi.http.ExternalApiProvider;
import io.evitadb.externalApi.http.ExternalApiProviderRegistrar;
import io.evitadb.externalApi.http.ExternalApiServer;
import io.evitadb.externalApi.rest.RestManager;
import io.evitadb.externalApi.rest.RestProvider;
import io.evitadb.externalApi.rest.api.catalog.CatalogRestRefreshingObserver;
import io.evitadb.externalApi.rest.configuration.RestConfig;
import javax.annotation.Nonnull;

public class RestProviderRegistrar
implements ExternalApiProviderRegistrar<RestConfig> {
    @Nonnull
    public String getExternalApiCode() {
        return "rest";
    }

    @Nonnull
    public Class<RestConfig> getConfigurationClass() {
        return RestConfig.class;
    }

    @Nonnull
    public ExternalApiProvider<RestConfig> register(@Nonnull Evita evita, @Nonnull ExternalApiServer externalApiServer, @Nonnull ApiOptions apiOptions, @Nonnull RestConfig restConfiguration) {
        RestManager restManager = new RestManager(evita, apiOptions.exposedOn(), restConfiguration);
        evita.registerStructuralChangeObserver((CatalogStructuralChangeObserver)new CatalogRestRefreshingObserver(restManager));
        return new RestProvider(restConfiguration, restManager.getRestRouter());
    }
}

