/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.builder;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.configuration.AbstractApiConfiguration;
import io.evitadb.externalApi.rest.api.Rest;
import io.evitadb.externalApi.rest.api.openApi.OpenApiComplexType;
import io.evitadb.externalApi.rest.api.openApi.OpenApiEndpoint;
import io.evitadb.externalApi.rest.api.openApi.OpenApiEnum;
import io.evitadb.externalApi.rest.api.openApi.OpenApiReferenceValidator;
import io.evitadb.externalApi.rest.api.openApi.OpenApiTypeReference;
import io.evitadb.externalApi.rest.api.resolver.serializer.BigDecimalSerializer;
import io.evitadb.externalApi.rest.exception.OpenApiBuildingError;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.utils.UriPath;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import io.evitadb.utils.VersionUtils;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.SpecVersion;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.servers.Server;
import io.undertow.util.HttpString;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class RestBuildingContext {
    @Nonnull
    protected final AbstractApiConfiguration restConfig;
    @Nullable
    private final String exposedOn;
    @Nonnull
    private final Evita evita;
    @Nonnull
    private final ObjectMapper objectMapper;
    @Nonnull
    private final Map<String, OpenApiComplexType> registeredTypes = CollectionUtils.createHashMap((int)100);
    private final Map<UriPath, Map<PathItem.HttpMethod, OpenApiEndpoint<?>>> registeredEndpoints = CollectionUtils.createHashMap((int)100);
    @Nonnull
    private final Map<String, Class<? extends Enum<?>>> registeredCustomEnums = CollectionUtils.createHashMap((int)32);

    protected RestBuildingContext(@Nonnull String exposedOn, @Nonnull AbstractApiConfiguration restConfig, @Nonnull Evita evita) {
        this.restConfig = restConfig;
        this.evita = evita;
        this.exposedOn = exposedOn;
        this.objectMapper = this.setupObjectMapper();
    }

    @Nonnull
    protected ObjectMapper setupObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer((JsonSerializer)new BigDecimalSerializer());
        objectMapper.registerModule((Module)module);
        objectMapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        objectMapper.setConfig((SerializationConfig)objectMapper.getSerializationConfig().with(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY}));
        return objectMapper;
    }

    @Nonnull
    protected abstract List<Server> buildOpenApiServers();

    @Nonnull
    protected abstract String getOpenApiTitle();

    public void registerCustomEnumIfAbsent(@Nonnull OpenApiEnum customEnum) {
        if (this.registeredCustomEnums.containsKey(customEnum.getName())) {
            return;
        }
        this.registeredCustomEnums.put(customEnum.getName(), customEnum.getEnumTemplate());
        this.registerType(customEnum);
    }

    @Nonnull
    public OpenApiTypeReference registerType(@Nonnull OpenApiComplexType type) {
        Assert.isPremiseValid((!this.registeredTypes.containsKey(type.getName()) ? 1 : 0) != 0, () -> new OpenApiBuildingError("Object with name `" + type.getName() + "` is already registered."));
        this.registeredTypes.put(type.getName(), type);
        return OpenApiTypeReference.typeRefTo(type);
    }

    @Nonnull
    public Optional<OpenApiTypeReference> getRegisteredType(@Nonnull String name) {
        return Optional.ofNullable(this.registeredTypes.get(name)).map(OpenApiTypeReference::typeRefTo);
    }

    public void registerEndpoint(@Nonnull OpenApiEndpoint<?> endpoint) {
        Assert.isPremiseValid((!this.registeredEndpoints.containsKey(endpoint.getPath()) || !this.registeredEndpoints.get(endpoint.getPath()).containsKey(endpoint.getMethod()) ? 1 : 0) != 0, () -> new OpenApiBuildingError("There is already registered `" + endpoint.getMethod() + "` endpoint at `" + endpoint.getPath() + "`."));
        this.registeredEndpoints.computeIfAbsent(endpoint.getPath(), path -> CollectionUtils.createHashMap((int)PathItem.HttpMethod.values().length)).put(endpoint.getMethod(), endpoint);
    }

    @Nonnull
    public Rest buildRest() {
        OpenAPI openApi = this.buildOpenApi();
        Map<String, Class<? extends Enum<?>>> enumMapping = this.buildEnumMapping();
        List<Rest.Endpoint> endpoints = this.buildEndpoints(openApi, enumMapping);
        return new Rest(openApi, endpoints);
    }

    @Nonnull
    private OpenAPI buildOpenApi() {
        OpenAPI openApi = new OpenAPI(SpecVersion.V31).servers(this.buildOpenApiServers());
        Info info = new Info();
        info.setTitle(this.getOpenApiTitle());
        info.setContact(new Contact().email("novotny@fg.cz").url("https://www.fg.cz"));
        info.setVersion(VersionUtils.readVersion());
        info.setLicense(new License().name("Business Source License 1.1").url("https://github.com/FgForrest/evitaDB/blob/master/LICENSE"));
        openApi.info(info);
        Components components = new Components();
        this.registeredTypes.forEach((name, object) -> components.addSchemas(name, object.toSchema()));
        openApi.setComponents(components);
        Paths paths = new Paths();
        this.registeredEndpoints.forEach((path, endpoints) -> {
            PathItem pathItem = new PathItem();
            endpoints.forEach((method, endpoint) -> pathItem.operation(method, endpoint.toOperation()));
            paths.addPathItem("/" + path.toString(), pathItem);
        });
        openApi.setPaths(paths);
        this.validateReferences(openApi);
        return openApi;
    }

    @Nonnull
    private Map<String, Class<? extends Enum<?>>> buildEnumMapping() {
        Map enumMapping = this.registeredCustomEnums.entrySet().stream().filter(it -> it.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (o, o2) -> {
            throw new RestInternalError("Enum items cannot merge.");
        }, LinkedHashMap::new));
        return Collections.unmodifiableMap(enumMapping);
    }

    @Nonnull
    private List<Rest.Endpoint> buildEndpoints(@Nonnull OpenAPI openApi, @Nonnull Map<String, Class<? extends Enum<?>>> enumMapping) {
        LinkedList builtEndpoints = new LinkedList();
        this.registeredEndpoints.forEach((path, endpoints) -> endpoints.forEach((method, endpoint) -> builtEndpoints.add(new Rest.Endpoint((UriPath)path, new HttpString(endpoint.getMethod().name()), endpoint.toHandler(this.objectMapper, this.evita, openApi, enumMapping)))));
        return Collections.unmodifiableList(builtEndpoints);
    }

    private void validateReferences(OpenAPI openApi) {
        OpenApiReferenceValidator referenceValidator = new OpenApiReferenceValidator(openApi);
        Set<String> missingSchemas = referenceValidator.validateSchemaReferences();
        if (!missingSchemas.isEmpty()) {
            StringBuilder errorMessageBuilder = new StringBuilder("Found missing schema in OpenAPI :`\n");
            missingSchemas.forEach(it -> errorMessageBuilder.append("- `").append((String)it).append("`\n"));
            throw new OpenApiBuildingError(errorMessageBuilder.toString());
        }
    }

    @Nullable
    public String getExposedOn() {
        return this.exposedOn;
    }

    @Nonnull
    public Evita getEvita() {
        return this.evita;
    }

    @Nonnull
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

