/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog;

import io.evitadb.api.CatalogStructuralChangeObserver;
import io.evitadb.externalApi.rest.RestManager;
import javax.annotation.Nonnull;

public class CatalogRestRefreshingObserver
implements CatalogStructuralChangeObserver {
    private final RestManager restManager;

    public CatalogRestRefreshingObserver(@Nonnull RestManager restManager) {
        this.restManager = restManager;
    }

    public void onCatalogCreate(@Nonnull String catalogName) {
        this.restManager.registerCatalog(catalogName);
    }

    public void onCatalogDelete(@Nonnull String catalogName) {
        this.restManager.unregisterCatalog(catalogName);
    }

    public void onEntityCollectionCreate(@Nonnull String catalogName, @Nonnull String entityType) {
        this.restManager.refreshCatalog(catalogName);
    }

    public void onEntityCollectionDelete(@Nonnull String catalogName, @Nonnull String entityType) {
        this.restManager.refreshCatalog(catalogName);
    }

    public void onCatalogSchemaUpdate(@Nonnull String catalogName) {
        this.restManager.refreshCatalog(catalogName);
    }

    public void onEntitySchemaUpdate(@Nonnull String catalogName, @Nonnull String entityType) {
        this.restManager.refreshCatalog(catalogName);
    }
}

