/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.builder;

import io.evitadb.api.CatalogContract;
import io.evitadb.api.SessionTraits;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.SealedEntitySchema;
import io.evitadb.core.Evita;
import io.evitadb.exception.GenericEvitaInternalError;
import io.evitadb.externalApi.rest.api.builder.RestBuildingContext;
import io.evitadb.externalApi.rest.api.openApi.OpenApiObject;
import io.evitadb.externalApi.rest.api.openApi.OpenApiTypeReference;
import io.evitadb.externalApi.rest.configuration.RestConfig;
import io.evitadb.utils.CollectionUtils;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CatalogRestBuildingContext
extends RestBuildingContext {
    @Nonnull
    private final CatalogContract catalog;
    @Nonnull
    private final Set<Locale> supportedLocales;
    @Nonnull
    private final Set<Currency> supportedCurrencies;
    @Nonnull
    private final Set<EntitySchemaContract> entitySchemas;
    @Nonnull
    private final List<OpenApiTypeReference> entityObjects;
    @Nonnull
    private final List<OpenApiTypeReference> localizedEntityObjects;

    public CatalogRestBuildingContext(@Nullable String exposedOn, @Nonnull RestConfig restConfig, @Nonnull Evita evita, @Nonnull CatalogContract catalog) {
        super(exposedOn, restConfig, evita);
        this.catalog = catalog;
        this.supportedLocales = CollectionUtils.createHashSet((int)20);
        this.supportedCurrencies = CollectionUtils.createHashSet((int)20);
        this.entitySchemas = (Set)evita.queryCatalog(catalog.getName(), session -> {
            Set collections = session.getAllEntityTypes();
            HashSet schemas = CollectionUtils.createHashSet((int)collections.size());
            collections.forEach(c -> {
                SealedEntitySchema entitySchema = (SealedEntitySchema)session.getEntitySchema(c).orElseThrow(() -> new GenericEvitaInternalError("Schema for `" + c + "` entity type unexpectedly not found!"));
                this.supportedLocales.addAll(entitySchema.getLocales());
                this.supportedCurrencies.addAll(entitySchema.getCurrencies());
                schemas.add(entitySchema);
            });
            return schemas;
        }, new SessionTraits.SessionFlags[0]);
        this.entityObjects = new ArrayList<OpenApiTypeReference>(this.entitySchemas.size());
        this.localizedEntityObjects = new ArrayList<OpenApiTypeReference>(this.entitySchemas.size());
    }

    @Override
    @Nonnull
    protected List<Server> buildOpenApiServers() {
        return Arrays.stream(this.restConfig.getBaseUrls(this.getExposedOn())).map(baseUrl -> new Server().url(baseUrl + this.getSchema().getName())).toList();
    }

    @Override
    @Nonnull
    protected String getOpenApiTitle() {
        return "Web services for catalog `" + this.getCatalog().getName() + "`.";
    }

    @Nonnull
    public CatalogSchemaContract getSchema() {
        return this.catalog.getSchema();
    }

    @Nonnull
    public OpenApiTypeReference registerEntityObject(@Nonnull OpenApiObject entityObject) {
        OpenApiTypeReference ref = this.registerType(entityObject);
        this.entityObjects.add(ref);
        return ref;
    }

    @Nonnull
    public OpenApiTypeReference registerLocalizedEntityObject(@Nonnull OpenApiObject entityObject) {
        OpenApiTypeReference ref = this.registerType(entityObject);
        this.localizedEntityObjects.add(ref);
        return ref;
    }

    @Nonnull
    public CatalogContract getCatalog() {
        return this.catalog;
    }

    @Nonnull
    public Set<Locale> getSupportedLocales() {
        return this.supportedLocales;
    }

    @Nonnull
    public Set<Currency> getSupportedCurrencies() {
        return this.supportedCurrencies;
    }

    @Nonnull
    public Set<EntitySchemaContract> getEntitySchemas() {
        return this.entitySchemas;
    }

    @Nonnull
    public List<OpenApiTypeReference> getEntityObjects() {
        return this.entityObjects;
    }

    @Nonnull
    public List<OpenApiTypeReference> getLocalizedEntityObjects() {
        return this.localizedEntityObjects;
    }
}

