/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi;

import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.GlobalAttributeSchemaContract;
import io.evitadb.api.requestResponse.schema.NamedSchemaContract;
import io.evitadb.dataType.ComplexDataObject;
import io.evitadb.externalApi.api.catalog.dataApi.model.CatalogDataApiRootDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.EntityDescriptor;
import io.evitadb.externalApi.api.catalog.model.CatalogRootDescriptor;
import io.evitadb.externalApi.api.model.ObjectDescriptorTransformer;
import io.evitadb.externalApi.api.model.PropertyDescriptorTransformer;
import io.evitadb.externalApi.rest.api.builder.PartialRestBuilder;
import io.evitadb.externalApi.rest.api.catalog.builder.CatalogRestBuildingContext;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.CollectionDataApiRestBuildingContext;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.DataApiEndpointBuilder;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.DataApiNamesConstructor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.DataMutationBuilder;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.EntityObjectBuilder;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.FullResponseObjectBuilder;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.constraint.FilterConstraintSchemaBuilder;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.constraint.OpenApiConstraintSchemaBuildingContext;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.constraint.OrderConstraintSchemaBuilder;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.constraint.RequireConstraintSchemaBuilder;
import io.evitadb.externalApi.rest.api.catalog.dataApi.dto.DataChunkType;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.CollectionDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.EntityUnion;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.FetchEntityRequestDescriptor;
import io.evitadb.externalApi.rest.api.model.ObjectDescriptorToOpenApiEnumTransformer;
import io.evitadb.externalApi.rest.api.openApi.OpenApiEnum;
import io.evitadb.externalApi.rest.api.openApi.OpenApiObject;
import io.evitadb.externalApi.rest.api.openApi.OpenApiObjectUnionType;
import io.evitadb.externalApi.rest.api.openApi.OpenApiProperty;
import io.evitadb.externalApi.rest.api.openApi.OpenApiSimpleType;
import io.evitadb.externalApi.rest.api.openApi.OpenApiTypeReference;
import io.evitadb.externalApi.rest.api.openApi.OpenApiUnion;
import io.evitadb.externalApi.rest.api.resolver.serializer.DataTypeSerializer;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class CatalogDataApiRestBuilder
extends PartialRestBuilder<CatalogRestBuildingContext> {
    @Nonnull
    private final OpenApiConstraintSchemaBuildingContext constraintBuildingContext;
    @Nonnull
    private final FilterConstraintSchemaBuilder filterConstraintSchemaBuilder;
    @Nonnull
    private final FilterConstraintSchemaBuilder localizedFilterConstraintSchemaBuilder;
    @Nonnull
    private final OrderConstraintSchemaBuilder orderConstraintSchemaBuilder;
    @Nonnull
    private final RequireConstraintSchemaBuilder listRequireConstraintSchemaBuilder;
    @Nonnull
    private final RequireConstraintSchemaBuilder localizedListRequireConstraintSchemaBuilder;
    @Nonnull
    private final RequireConstraintSchemaBuilder queryRequireConstraintSchemaBuilder;
    @Nonnull
    private final RequireConstraintSchemaBuilder localizedQueryRequireConstraintSchemaBuilder;
    @Nonnull
    private final RequireConstraintSchemaBuilder upsertRequireConstraintSchemaBuilder;
    @Nonnull
    private final RequireConstraintSchemaBuilder deleteRequireConstraintSchemaBuilder;
    @Nonnull
    private final DataApiEndpointBuilder endpointBuilder;
    @Nonnull
    private final EntityObjectBuilder entityObjectBuilder;
    @Nonnull
    private final FullResponseObjectBuilder fullResponseObjectBuilder;
    @Nonnull
    private final DataMutationBuilder dataMutationBuilder;

    public CatalogDataApiRestBuilder(@Nonnull CatalogRestBuildingContext buildingContext) {
        super(buildingContext);
        this.constraintBuildingContext = new OpenApiConstraintSchemaBuildingContext(buildingContext);
        this.filterConstraintSchemaBuilder = new FilterConstraintSchemaBuilder(this.constraintBuildingContext, false);
        this.localizedFilterConstraintSchemaBuilder = new FilterConstraintSchemaBuilder(this.constraintBuildingContext, true);
        this.orderConstraintSchemaBuilder = new OrderConstraintSchemaBuilder(this.constraintBuildingContext);
        this.listRequireConstraintSchemaBuilder = new RequireConstraintSchemaBuilder(this.constraintBuildingContext, RequireConstraintSchemaBuilder.ALLOWED_CONSTRAINTS_FOR_LIST, new AtomicReference<FilterConstraintSchemaBuilder>(this.filterConstraintSchemaBuilder), new AtomicReference<OrderConstraintSchemaBuilder>(this.orderConstraintSchemaBuilder));
        this.localizedListRequireConstraintSchemaBuilder = new RequireConstraintSchemaBuilder(this.constraintBuildingContext, RequireConstraintSchemaBuilder.ALLOWED_CONSTRAINTS_FOR_LIST, new AtomicReference<FilterConstraintSchemaBuilder>(this.localizedFilterConstraintSchemaBuilder), new AtomicReference<OrderConstraintSchemaBuilder>(this.orderConstraintSchemaBuilder));
        this.queryRequireConstraintSchemaBuilder = new RequireConstraintSchemaBuilder(this.constraintBuildingContext, new AtomicReference<FilterConstraintSchemaBuilder>(this.filterConstraintSchemaBuilder), new AtomicReference<OrderConstraintSchemaBuilder>(this.orderConstraintSchemaBuilder));
        this.localizedQueryRequireConstraintSchemaBuilder = new RequireConstraintSchemaBuilder(this.constraintBuildingContext, new AtomicReference<FilterConstraintSchemaBuilder>(this.localizedFilterConstraintSchemaBuilder), new AtomicReference<OrderConstraintSchemaBuilder>(this.orderConstraintSchemaBuilder));
        this.upsertRequireConstraintSchemaBuilder = new RequireConstraintSchemaBuilder(this.constraintBuildingContext, RequireConstraintSchemaBuilder.ALLOWED_CONSTRAINTS_FOR_UPSERT, new AtomicReference<FilterConstraintSchemaBuilder>(this.filterConstraintSchemaBuilder), new AtomicReference<OrderConstraintSchemaBuilder>(this.orderConstraintSchemaBuilder));
        this.deleteRequireConstraintSchemaBuilder = new RequireConstraintSchemaBuilder(this.constraintBuildingContext, RequireConstraintSchemaBuilder.ALLOWED_CONSTRAINTS_FOR_DELETE, new AtomicReference<FilterConstraintSchemaBuilder>(this.filterConstraintSchemaBuilder), new AtomicReference<OrderConstraintSchemaBuilder>(this.orderConstraintSchemaBuilder));
        this.endpointBuilder = new DataApiEndpointBuilder(buildingContext, this.operationPathParameterBuilderTransformer, this.operationQueryParameterBuilderTransformer);
        this.entityObjectBuilder = new EntityObjectBuilder(buildingContext, this.propertyBuilderTransformer, this.objectBuilderTransformer);
        this.fullResponseObjectBuilder = new FullResponseObjectBuilder(buildingContext, this.propertyBuilderTransformer, this.objectBuilderTransformer, this.unionBuilderTransformer, this.dictionaryBuilderTransformer);
        this.dataMutationBuilder = new DataMutationBuilder(buildingContext, this.propertyBuilderTransformer, this.objectBuilderTransformer, this.upsertRequireConstraintSchemaBuilder);
    }

    @Override
    public void build() {
        this.buildCommonTypes();
        this.buildEndpoints();
        this.constraintBuildingContext.getBuiltTypes().forEach(((CatalogRestBuildingContext)this.buildingContext)::registerType);
    }

    private void buildCommonTypes() {
        this.buildLocaleEnum().ifPresent(((CatalogRestBuildingContext)this.buildingContext)::registerCustomEnumIfAbsent);
        this.buildCurrencyEnum().ifPresent(((CatalogRestBuildingContext)this.buildingContext)::registerCustomEnumIfAbsent);
        ((CatalogRestBuildingContext)this.buildingContext).registerType(CatalogDataApiRestBuilder.buildAssociatedDataScalarEnum());
        ((CatalogRestBuildingContext)this.buildingContext).registerType(OpenApiEnum.enumFrom(DataChunkType.class));
        ((CatalogRestBuildingContext)this.buildingContext).registerType(((OpenApiObject.Builder)CollectionDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.entityObjectBuilder.buildCommonTypes();
        this.fullResponseObjectBuilder.buildCommonTypes();
        this.dataMutationBuilder.buildCommonTypes();
    }

    private void buildEndpoints() {
        ((CatalogRestBuildingContext)this.buildingContext).registerEndpoint(this.endpointBuilder.buildCollectionsEndpoint((CatalogRestBuildingContext)this.buildingContext));
        ((CatalogRestBuildingContext)this.buildingContext).getEntitySchemas().forEach(entitySchema -> {
            CollectionDataApiRestBuildingContext collectionBuildingContext = this.setupForCollection((EntitySchemaContract)entitySchema);
            ((CatalogRestBuildingContext)this.buildingContext).registerEndpoint(this.endpointBuilder.buildGetEntityEndpoint((EntitySchemaContract)entitySchema, false, false));
            ((CatalogRestBuildingContext)this.buildingContext).registerEndpoint(this.endpointBuilder.buildGetEntityEndpoint((EntitySchemaContract)entitySchema, false, true));
            ((CatalogRestBuildingContext)this.buildingContext).registerEndpoint(this.endpointBuilder.buildListEntityEndpoint((EntitySchemaContract)entitySchema, false));
            ((CatalogRestBuildingContext)this.buildingContext).registerEndpoint(this.endpointBuilder.buildQueryEntityEndpoint((EntitySchemaContract)entitySchema, false));
            if (collectionBuildingContext.isLocalizedEntity()) {
                ((CatalogRestBuildingContext)this.buildingContext).registerEndpoint(this.endpointBuilder.buildGetEntityEndpoint((EntitySchemaContract)entitySchema, true, false));
                ((CatalogRestBuildingContext)this.buildingContext).registerEndpoint(this.endpointBuilder.buildGetEntityEndpoint((EntitySchemaContract)entitySchema, true, true));
                ((CatalogRestBuildingContext)this.buildingContext).registerEndpoint(this.endpointBuilder.buildListEntityEndpoint((EntitySchemaContract)entitySchema, true));
                ((CatalogRestBuildingContext)this.buildingContext).registerEndpoint(this.endpointBuilder.buildQueryEntityEndpoint((EntitySchemaContract)entitySchema, true));
            }
            ((CatalogRestBuildingContext)this.buildingContext).registerEndpoint(this.endpointBuilder.buildUpsertEntityEndpoint((EntitySchemaContract)entitySchema, true));
            if (entitySchema.isWithGeneratedPrimaryKey()) {
                ((CatalogRestBuildingContext)this.buildingContext).registerEndpoint(this.endpointBuilder.buildUpsertEntityEndpoint((EntitySchemaContract)entitySchema, false));
            }
            ((CatalogRestBuildingContext)this.buildingContext).registerEndpoint(this.endpointBuilder.buildDeleteEntityEndpoint((EntitySchemaContract)entitySchema));
            ((CatalogRestBuildingContext)this.buildingContext).registerEndpoint(this.endpointBuilder.buildDeleteEntitiesByQueryEndpoint((EntitySchemaContract)entitySchema));
        });
        this.buildEntityUnion(false).ifPresent(((CatalogRestBuildingContext)this.buildingContext)::registerType);
        this.buildEntityUnion(true).ifPresent(((CatalogRestBuildingContext)this.buildingContext)::registerType);
        List<GlobalAttributeSchemaContract> globallyUniqueAttributes = ((CatalogRestBuildingContext)this.buildingContext).getSchema().getAttributes().values().stream().filter(GlobalAttributeSchemaContract::isUniqueGlobally).toList();
        if (!globallyUniqueAttributes.isEmpty()) {
            this.endpointBuilder.buildGetUnknownEntityEndpoint((CatalogRestBuildingContext)this.buildingContext, globallyUniqueAttributes, false).ifPresent(((CatalogRestBuildingContext)this.buildingContext)::registerEndpoint);
            this.endpointBuilder.buildListUnknownEntityEndpoint((CatalogRestBuildingContext)this.buildingContext, globallyUniqueAttributes, false).ifPresent(((CatalogRestBuildingContext)this.buildingContext)::registerEndpoint);
            if (!((CatalogRestBuildingContext)this.buildingContext).getLocalizedEntityObjects().isEmpty()) {
                this.endpointBuilder.buildGetUnknownEntityEndpoint((CatalogRestBuildingContext)this.buildingContext, globallyUniqueAttributes, true).ifPresent(((CatalogRestBuildingContext)this.buildingContext)::registerEndpoint);
                this.endpointBuilder.buildListUnknownEntityEndpoint((CatalogRestBuildingContext)this.buildingContext, globallyUniqueAttributes, true).ifPresent(((CatalogRestBuildingContext)this.buildingContext)::registerEndpoint);
            }
        }
    }

    @Nonnull
    private CollectionDataApiRestBuildingContext setupForCollection(@Nonnull EntitySchemaContract entitySchema) {
        CollectionDataApiRestBuildingContext collectionBuildingContext = new CollectionDataApiRestBuildingContext((CatalogRestBuildingContext)this.buildingContext, entitySchema);
        OpenApiSimpleType filterByObject = this.filterConstraintSchemaBuilder.build(entitySchema.getName());
        collectionBuildingContext.setFilterByObject(filterByObject);
        OpenApiSimpleType localizedFilterByObject = this.localizedFilterConstraintSchemaBuilder.build(entitySchema.getName());
        collectionBuildingContext.setLocalizedFilterByObject(localizedFilterByObject);
        OpenApiSimpleType orderByObject = this.orderConstraintSchemaBuilder.build(entitySchema.getName());
        collectionBuildingContext.setOrderByObject(orderByObject);
        OpenApiSimpleType requireForListObject = this.listRequireConstraintSchemaBuilder.build(entitySchema.getName());
        collectionBuildingContext.setRequireForListObject(requireForListObject);
        OpenApiSimpleType localizedRequireForListObject = this.localizedListRequireConstraintSchemaBuilder.build(entitySchema.getName());
        collectionBuildingContext.setLocalizedRequireForListObject(localizedRequireForListObject);
        OpenApiSimpleType requireForQueryObject = this.queryRequireConstraintSchemaBuilder.build(entitySchema.getName());
        collectionBuildingContext.setRequireForQueryObject(requireForQueryObject);
        OpenApiSimpleType localizedRequireForQueryObject = this.localizedQueryRequireConstraintSchemaBuilder.build(entitySchema.getName());
        collectionBuildingContext.setLocalizedRequireForQueryObject(localizedRequireForQueryObject);
        OpenApiSimpleType requireForDeleteObject = this.deleteRequireConstraintSchemaBuilder.build(entitySchema.getName());
        collectionBuildingContext.setRequireForDeleteObject(requireForDeleteObject);
        ((CatalogRestBuildingContext)this.buildingContext).registerEntityObject(this.entityObjectBuilder.buildEntityObject(entitySchema, false));
        this.buildListRequestBodyObject(collectionBuildingContext, false);
        this.buildQueryRequestBodyObject(collectionBuildingContext, false);
        this.buildDeleteRequestBodyObject(collectionBuildingContext);
        ((CatalogRestBuildingContext)this.buildingContext).registerType(this.fullResponseObjectBuilder.buildFullResponseObject(entitySchema, false));
        if (collectionBuildingContext.isLocalizedEntity()) {
            ((CatalogRestBuildingContext)this.buildingContext).registerLocalizedEntityObject(this.entityObjectBuilder.buildEntityObject(entitySchema, true));
            this.buildListRequestBodyObject(collectionBuildingContext, true);
            this.buildQueryRequestBodyObject(collectionBuildingContext, true);
            ((CatalogRestBuildingContext)this.buildingContext).registerType(this.fullResponseObjectBuilder.buildFullResponseObject(entitySchema, true));
        } else {
            collectionBuildingContext.getCatalogCtx().registerType(this.entityObjectBuilder.buildEntityObject(entitySchema, true));
        }
        this.dataMutationBuilder.buildEntityUpsertRequestObject(entitySchema);
        return collectionBuildingContext;
    }

    @Nonnull
    private OpenApiTypeReference buildListRequestBodyObject(@Nonnull CollectionDataApiRestBuildingContext entitySchemaBuildingContext, boolean localized) {
        OpenApiObject.Builder objectBuilder = ((OpenApiObject.Builder)FetchEntityRequestDescriptor.THIS_LIST.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(DataApiNamesConstructor.constructEntityListRequestBodyObjectName(entitySchemaBuildingContext.getSchema(), localized)).property(((OpenApiProperty.Builder)FetchEntityRequestDescriptor.FILTER_BY.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(localized ? entitySchemaBuildingContext.getLocalizedFilterByObject() : entitySchemaBuildingContext.getFilterByObject())).property(((OpenApiProperty.Builder)FetchEntityRequestDescriptor.ORDER_BY.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(entitySchemaBuildingContext.getOrderByObject())).property(((OpenApiProperty.Builder)FetchEntityRequestDescriptor.REQUIRE.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(localized ? entitySchemaBuildingContext.getLocalizedRequireForListObject() : entitySchemaBuildingContext.getRequireForListObject()));
        return entitySchemaBuildingContext.getCatalogCtx().registerType(objectBuilder.build());
    }

    @Nonnull
    private OpenApiTypeReference buildQueryRequestBodyObject(@Nonnull CollectionDataApiRestBuildingContext entitySchemaBuildingContext, boolean localized) {
        OpenApiObject.Builder objectBuilder = ((OpenApiObject.Builder)FetchEntityRequestDescriptor.THIS_QUERY.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(DataApiNamesConstructor.constructEntityQueryRequestBodyObjectName(entitySchemaBuildingContext.getSchema(), localized)).property(((OpenApiProperty.Builder)FetchEntityRequestDescriptor.FILTER_BY.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(localized ? entitySchemaBuildingContext.getLocalizedFilterByObject() : entitySchemaBuildingContext.getFilterByObject())).property(((OpenApiProperty.Builder)FetchEntityRequestDescriptor.ORDER_BY.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(entitySchemaBuildingContext.getOrderByObject())).property(((OpenApiProperty.Builder)FetchEntityRequestDescriptor.REQUIRE.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(localized ? entitySchemaBuildingContext.getLocalizedRequireForQueryObject() : entitySchemaBuildingContext.getRequireForQueryObject()));
        return entitySchemaBuildingContext.getCatalogCtx().registerType(objectBuilder.build());
    }

    @Nonnull
    private OpenApiTypeReference buildDeleteRequestBodyObject(@Nonnull CollectionDataApiRestBuildingContext entitySchemaBuildingContext) {
        OpenApiObject.Builder objectBuilder = ((OpenApiObject.Builder)FetchEntityRequestDescriptor.THIS_DELETE.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(FetchEntityRequestDescriptor.THIS_DELETE.name(new NamedSchemaContract[]{entitySchemaBuildingContext.getSchema()})).property(((OpenApiProperty.Builder)FetchEntityRequestDescriptor.FILTER_BY.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(entitySchemaBuildingContext.getFilterByObject())).property(((OpenApiProperty.Builder)FetchEntityRequestDescriptor.ORDER_BY.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(entitySchemaBuildingContext.getOrderByObject())).property(((OpenApiProperty.Builder)FetchEntityRequestDescriptor.REQUIRE.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(entitySchemaBuildingContext.getRequireForDeleteObject()));
        return entitySchemaBuildingContext.getCatalogCtx().registerType(objectBuilder.build());
    }

    @Nonnull
    private Optional<OpenApiUnion> buildEntityUnion(boolean localized) {
        if (localized) {
            List<OpenApiTypeReference> entityObjects = ((CatalogRestBuildingContext)this.buildingContext).getLocalizedEntityObjects();
            if (entityObjects.isEmpty()) {
                return Optional.empty();
            }
            OpenApiUnion.Builder localizedEntityUnionBuilder = ((OpenApiUnion.Builder)EntityUnion.THIS_LOCALIZED.to((ObjectDescriptorTransformer)this.unionBuilderTransformer)).type(OpenApiObjectUnionType.ONE_OF).discriminator(EntityDescriptor.TYPE.name());
            entityObjects.forEach(localizedEntityUnionBuilder::object);
            return Optional.of(localizedEntityUnionBuilder.build());
        }
        List<OpenApiTypeReference> entityObjects = ((CatalogRestBuildingContext)this.buildingContext).getEntityObjects();
        if (entityObjects.isEmpty()) {
            return Optional.empty();
        }
        OpenApiUnion.Builder entityUnionBuilder = ((OpenApiUnion.Builder)EntityUnion.THIS.to((ObjectDescriptorTransformer)this.unionBuilderTransformer)).type(OpenApiObjectUnionType.ONE_OF).discriminator(EntityDescriptor.TYPE.name());
        entityObjects.forEach(entityUnionBuilder::object);
        return Optional.of(entityUnionBuilder.build());
    }

    @Nonnull
    private static OpenApiEnum buildAssociatedDataScalarEnum() {
        return OpenApiEnum.newEnum(CatalogDataApiRestBuilder.buildScalarEnum()).name(CatalogRootDescriptor.ASSOCIATED_DATA_SCALAR_ENUM.name()).description(CatalogRootDescriptor.ASSOCIATED_DATA_SCALAR_ENUM.description()).item(DataTypeSerializer.serialize(ComplexDataObject.class)).build();
    }

    @Nonnull
    private Optional<OpenApiEnum> buildLocaleEnum() {
        if (((CatalogRestBuildingContext)this.buildingContext).getSupportedLocales().isEmpty()) {
            return Optional.empty();
        }
        OpenApiEnum localeEnum = ((OpenApiEnum.Builder)CatalogDataApiRootDescriptor.LOCALE_ENUM.to((ObjectDescriptorTransformer)new ObjectDescriptorToOpenApiEnumTransformer(((CatalogRestBuildingContext)this.buildingContext).getSupportedLocales().stream().map(Locale::toLanguageTag).collect(Collectors.toSet())))).format("locale").build();
        return Optional.of(localeEnum);
    }

    @Nonnull
    private Optional<OpenApiEnum> buildCurrencyEnum() {
        if (((CatalogRestBuildingContext)this.buildingContext).getSupportedCurrencies().isEmpty()) {
            return Optional.empty();
        }
        OpenApiEnum currencyEnum = ((OpenApiEnum.Builder)CatalogDataApiRootDescriptor.CURRENCY_ENUM.to((ObjectDescriptorTransformer)new ObjectDescriptorToOpenApiEnumTransformer(((CatalogRestBuildingContext)this.buildingContext).getSupportedCurrencies().stream().map(Currency::toString).collect(Collectors.toSet())))).format("iso-4217").build();
        return Optional.of(currencyEnum);
    }
}

