/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.builder;

import io.evitadb.api.CatalogContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.externalApi.rest.api.catalog.builder.CatalogRestBuildingContext;
import io.evitadb.externalApi.rest.api.openApi.OpenApiSimpleType;
import io.evitadb.externalApi.rest.exception.OpenApiBuildingError;
import io.evitadb.utils.Assert;
import java.util.Optional;
import javax.annotation.Nonnull;

public class CollectionDataApiRestBuildingContext {
    @Nonnull
    private final CatalogRestBuildingContext catalogCtx;
    @Nonnull
    private final EntitySchemaContract schema;
    private OpenApiSimpleType filterByObject;
    private OpenApiSimpleType localizedFilterByObject;
    private OpenApiSimpleType orderByObject;
    private OpenApiSimpleType requireForListObject;
    private OpenApiSimpleType localizedRequireForListObject;
    private OpenApiSimpleType requireForQueryObject;
    private OpenApiSimpleType localizedRequireForQueryObject;
    private OpenApiSimpleType requireForDeleteObject;

    @Nonnull
    public CatalogContract getCatalog() {
        return this.catalogCtx.getCatalog();
    }

    public boolean isLocalizedEntity() {
        return !this.schema.getLocales().isEmpty();
    }

    public void setFilterByObject(@Nonnull OpenApiSimpleType filterByObject) {
        Assert.isPremiseValid((this.filterByObject == null ? 1 : 0) != 0, () -> new OpenApiBuildingError("FilterBy object for schema `" + this.schema.getName() + "` has been already initialized."));
        this.filterByObject = filterByObject;
    }

    @Nonnull
    public OpenApiSimpleType getFilterByObject() {
        return Optional.ofNullable(this.filterByObject).orElseThrow(() -> new OpenApiBuildingError("FilterBy for schema `" + this.schema.getName() + "` has not been initialized."));
    }

    public void setLocalizedFilterByObject(@Nonnull OpenApiSimpleType filterByLocalizedInputObject) {
        Assert.isPremiseValid((this.localizedFilterByObject == null ? 1 : 0) != 0, () -> new OpenApiBuildingError("FilterBy object for schema `" + this.schema.getName() + "` has been already initialized."));
        this.localizedFilterByObject = filterByLocalizedInputObject;
    }

    @Nonnull
    public OpenApiSimpleType getLocalizedFilterByObject() {
        return Optional.ofNullable(this.localizedFilterByObject).orElseThrow(() -> new OpenApiBuildingError("Localized FilterBy for schema `" + this.schema.getName() + "` has not been initialized."));
    }

    public void setOrderByObject(@Nonnull OpenApiSimpleType orderByObject) {
        Assert.isPremiseValid((this.orderByObject == null ? 1 : 0) != 0, () -> new OpenApiBuildingError("OrderBy object for schema `" + this.schema.getName() + "` has been already initialized."));
        this.orderByObject = orderByObject;
    }

    @Nonnull
    public OpenApiSimpleType getOrderByObject() {
        return Optional.ofNullable(this.orderByObject).orElseThrow(() -> new OpenApiBuildingError("OrderBy for schema `" + this.schema.getName() + "` has not been initialized."));
    }

    public void setRequireForListObject(@Nonnull OpenApiSimpleType requireForListObject) {
        Assert.isPremiseValid((this.requireForListObject == null ? 1 : 0) != 0, () -> new OpenApiBuildingError("Require for list object for schema `" + this.schema.getName() + "` has been already initialized."));
        this.requireForListObject = requireForListObject;
    }

    @Nonnull
    public OpenApiSimpleType getRequireForListObject() {
        return Optional.ofNullable(this.requireForListObject).orElseThrow(() -> new OpenApiBuildingError("Require for list object for schema `" + this.schema.getName() + "` has not been initialized."));
    }

    public void setLocalizedRequireForListObject(@Nonnull OpenApiSimpleType localizedRequireForListObject) {
        Assert.isPremiseValid((this.localizedRequireForListObject == null ? 1 : 0) != 0, () -> new OpenApiBuildingError("Require for list object for schema `" + this.schema.getName() + "` has been already initialized."));
        this.localizedRequireForListObject = localizedRequireForListObject;
    }

    @Nonnull
    public OpenApiSimpleType getLocalizedRequireForListObject() {
        return Optional.ofNullable(this.localizedRequireForListObject).orElseThrow(() -> new OpenApiBuildingError("Localized Require for list object for schema `" + this.schema.getName() + "` has not been initialized."));
    }

    public void setRequireForQueryObject(@Nonnull OpenApiSimpleType requireForQueryObject) {
        Assert.isPremiseValid((this.requireForQueryObject == null ? 1 : 0) != 0, () -> new OpenApiBuildingError("Require for query object for schema `" + this.schema.getName() + "` has been already initialized."));
        this.requireForQueryObject = requireForQueryObject;
    }

    @Nonnull
    public OpenApiSimpleType getRequireForQueryObject() {
        return Optional.ofNullable(this.requireForQueryObject).orElseThrow(() -> new OpenApiBuildingError("Require for query object for schema `" + this.schema.getName() + "` has not been initialized."));
    }

    public void setLocalizedRequireForQueryObject(@Nonnull OpenApiSimpleType localizedRequireForQueryObject) {
        Assert.isPremiseValid((this.localizedRequireForQueryObject == null ? 1 : 0) != 0, () -> new OpenApiBuildingError("Localized Require for query object for schema `" + this.schema.getName() + "` has been already initialized."));
        this.localizedRequireForQueryObject = localizedRequireForQueryObject;
    }

    @Nonnull
    public OpenApiSimpleType getLocalizedRequireForQueryObject() {
        return Optional.ofNullable(this.localizedRequireForQueryObject).orElseThrow(() -> new OpenApiBuildingError("Localized Require for query object for schema `" + this.schema.getName() + "` has not been initialized."));
    }

    public void setRequireForDeleteObject(@Nonnull OpenApiSimpleType requireForDeleteObject) {
        Assert.isPremiseValid((this.requireForDeleteObject == null ? 1 : 0) != 0, () -> new OpenApiBuildingError("Require for query object for schema `" + this.schema.getName() + "` has been already initialized."));
        this.requireForDeleteObject = requireForDeleteObject;
    }

    @Nonnull
    public OpenApiSimpleType getRequireForDeleteObject() {
        return Optional.ofNullable(this.requireForDeleteObject).orElseThrow(() -> new OpenApiBuildingError("Require for query object for schema `" + this.schema.getName() + "` has not been initialized."));
    }

    public CollectionDataApiRestBuildingContext(@Nonnull CatalogRestBuildingContext catalogCtx, @Nonnull EntitySchemaContract schema) {
        if (catalogCtx == null) {
            throw new NullPointerException("catalogCtx is marked non-null but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
        this.catalogCtx = catalogCtx;
        this.schema = schema;
    }

    @Nonnull
    public CatalogRestBuildingContext getCatalogCtx() {
        return this.catalogCtx;
    }

    @Nonnull
    public EntitySchemaContract getSchema() {
        return this.schema;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionDataApiRestBuildingContext)) {
            return false;
        }
        CollectionDataApiRestBuildingContext other = (CollectionDataApiRestBuildingContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CatalogRestBuildingContext this$catalogCtx = this.getCatalogCtx();
        CatalogRestBuildingContext other$catalogCtx = other.getCatalogCtx();
        if (this$catalogCtx == null ? other$catalogCtx != null : !this$catalogCtx.equals(other$catalogCtx)) {
            return false;
        }
        EntitySchemaContract this$schema = this.getSchema();
        EntitySchemaContract other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        OpenApiSimpleType this$filterByObject = this.getFilterByObject();
        OpenApiSimpleType other$filterByObject = other.getFilterByObject();
        if (this$filterByObject == null ? other$filterByObject != null : !this$filterByObject.equals(other$filterByObject)) {
            return false;
        }
        OpenApiSimpleType this$localizedFilterByObject = this.getLocalizedFilterByObject();
        OpenApiSimpleType other$localizedFilterByObject = other.getLocalizedFilterByObject();
        if (this$localizedFilterByObject == null ? other$localizedFilterByObject != null : !this$localizedFilterByObject.equals(other$localizedFilterByObject)) {
            return false;
        }
        OpenApiSimpleType this$orderByObject = this.getOrderByObject();
        OpenApiSimpleType other$orderByObject = other.getOrderByObject();
        if (this$orderByObject == null ? other$orderByObject != null : !this$orderByObject.equals(other$orderByObject)) {
            return false;
        }
        OpenApiSimpleType this$requireForListObject = this.getRequireForListObject();
        OpenApiSimpleType other$requireForListObject = other.getRequireForListObject();
        if (this$requireForListObject == null ? other$requireForListObject != null : !this$requireForListObject.equals(other$requireForListObject)) {
            return false;
        }
        OpenApiSimpleType this$localizedRequireForListObject = this.getLocalizedRequireForListObject();
        OpenApiSimpleType other$localizedRequireForListObject = other.getLocalizedRequireForListObject();
        if (this$localizedRequireForListObject == null ? other$localizedRequireForListObject != null : !this$localizedRequireForListObject.equals(other$localizedRequireForListObject)) {
            return false;
        }
        OpenApiSimpleType this$requireForQueryObject = this.getRequireForQueryObject();
        OpenApiSimpleType other$requireForQueryObject = other.getRequireForQueryObject();
        if (this$requireForQueryObject == null ? other$requireForQueryObject != null : !this$requireForQueryObject.equals(other$requireForQueryObject)) {
            return false;
        }
        OpenApiSimpleType this$localizedRequireForQueryObject = this.getLocalizedRequireForQueryObject();
        OpenApiSimpleType other$localizedRequireForQueryObject = other.getLocalizedRequireForQueryObject();
        if (this$localizedRequireForQueryObject == null ? other$localizedRequireForQueryObject != null : !this$localizedRequireForQueryObject.equals(other$localizedRequireForQueryObject)) {
            return false;
        }
        OpenApiSimpleType this$requireForDeleteObject = this.getRequireForDeleteObject();
        OpenApiSimpleType other$requireForDeleteObject = other.getRequireForDeleteObject();
        return !(this$requireForDeleteObject == null ? other$requireForDeleteObject != null : !this$requireForDeleteObject.equals(other$requireForDeleteObject));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollectionDataApiRestBuildingContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CatalogRestBuildingContext $catalogCtx = this.getCatalogCtx();
        result = result * 59 + ($catalogCtx == null ? 43 : $catalogCtx.hashCode());
        EntitySchemaContract $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        OpenApiSimpleType $filterByObject = this.getFilterByObject();
        result = result * 59 + ($filterByObject == null ? 43 : $filterByObject.hashCode());
        OpenApiSimpleType $localizedFilterByObject = this.getLocalizedFilterByObject();
        result = result * 59 + ($localizedFilterByObject == null ? 43 : $localizedFilterByObject.hashCode());
        OpenApiSimpleType $orderByObject = this.getOrderByObject();
        result = result * 59 + ($orderByObject == null ? 43 : $orderByObject.hashCode());
        OpenApiSimpleType $requireForListObject = this.getRequireForListObject();
        result = result * 59 + ($requireForListObject == null ? 43 : $requireForListObject.hashCode());
        OpenApiSimpleType $localizedRequireForListObject = this.getLocalizedRequireForListObject();
        result = result * 59 + ($localizedRequireForListObject == null ? 43 : $localizedRequireForListObject.hashCode());
        OpenApiSimpleType $requireForQueryObject = this.getRequireForQueryObject();
        result = result * 59 + ($requireForQueryObject == null ? 43 : $requireForQueryObject.hashCode());
        OpenApiSimpleType $localizedRequireForQueryObject = this.getLocalizedRequireForQueryObject();
        result = result * 59 + ($localizedRequireForQueryObject == null ? 43 : $localizedRequireForQueryObject.hashCode());
        OpenApiSimpleType $requireForDeleteObject = this.getRequireForDeleteObject();
        result = result * 59 + ($requireForDeleteObject == null ? 43 : $requireForDeleteObject.hashCode());
        return result;
    }

    public String toString() {
        return "CollectionDataApiRestBuildingContext(catalogCtx=" + this.getCatalogCtx() + ", schema=" + this.getSchema() + ", filterByObject=" + this.getFilterByObject() + ", localizedFilterByObject=" + this.getLocalizedFilterByObject() + ", orderByObject=" + this.getOrderByObject() + ", requireForListObject=" + this.getRequireForListObject() + ", localizedRequireForListObject=" + this.getLocalizedRequireForListObject() + ", requireForQueryObject=" + this.getRequireForQueryObject() + ", localizedRequireForQueryObject=" + this.getLocalizedRequireForQueryObject() + ", requireForDeleteObject=" + this.getRequireForDeleteObject() + ")";
    }
}

