/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.builder;

import io.evitadb.api.requestResponse.schema.AttributeSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.GlobalAttributeSchemaContract;
import io.evitadb.api.requestResponse.schema.NamedSchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.api.catalog.dataApi.model.CatalogDataApiRootDescriptor;
import io.evitadb.externalApi.api.model.PropertyDescriptorTransformer;
import io.evitadb.externalApi.rest.api.catalog.builder.CatalogRestBuildingContext;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.DataApiNamesConstructor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.CollectionDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.EntityUnion;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.EntityUpsertRequestDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.FetchEntityRequestDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.header.CollectionsEndpointHeaderDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.header.DeleteEntityEndpointHeaderDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.header.FetchEntityEndpointHeaderDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.header.GetEntityEndpointHeaderDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.header.ListUnknownEntitiesEndpointHeaderDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.header.UnknownEntityEndpointHeaderDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.header.UpsertEntityEndpointHeaderDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.CollectionRestHandlingContext;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.CollectionsHandler;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.DeleteEntitiesByQueryHandler;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.DeleteEntityHandler;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.GetEntityHandler;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.GetUnknownEntityHandler;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.ListEntitiesHandler;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.ListUnknownEntitiesHandler;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.QueryEntitiesHandler;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.UpsertEntityHandler;
import io.evitadb.externalApi.rest.api.dataType.DataTypesConverter;
import io.evitadb.externalApi.rest.api.model.PropertyDescriptorToOpenApiOperationPathParameterTransformer;
import io.evitadb.externalApi.rest.api.model.PropertyDescriptorToOpenApiOperationQueryParameterTransformer;
import io.evitadb.externalApi.rest.api.openApi.OpenApiArray;
import io.evitadb.externalApi.rest.api.openApi.OpenApiCatalogEndpoint;
import io.evitadb.externalApi.rest.api.openApi.OpenApiCollectionEndpoint;
import io.evitadb.externalApi.rest.api.openApi.OpenApiEndpointParameter;
import io.evitadb.externalApi.rest.api.openApi.OpenApiNonNull;
import io.evitadb.externalApi.rest.api.openApi.OpenApiTypeReference;
import io.swagger.v3.oas.models.PathItem;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataApiEndpointBuilder {
    private static final String LOCALIZED_OPERATION_ID_SUFFIX = "Localized";
    private static final String GET_BY_ID_OPERATION_ID_SUFFIX = "ById";
    private static final String DELETE_BY_QUERY_OPERATION_ID_SUFFIX = "ByQuery";
    @Nonnull
    private final CatalogRestBuildingContext buildingContext;
    @Nonnull
    private final PropertyDescriptorToOpenApiOperationPathParameterTransformer operationPathParameterBuilderTransformer;
    @Nonnull
    private final PropertyDescriptorToOpenApiOperationQueryParameterTransformer operationQueryParameterBuilderTransformer;

    @Nonnull
    public OpenApiCollectionEndpoint buildGetEntityEndpoint(@Nonnull EntitySchemaContract entitySchema, boolean localized, boolean withPkInPath) {
        String operationId;
        if (withPkInPath) {
            String suffix = GET_BY_ID_OPERATION_ID_SUFFIX + Optional.ofNullable(DataApiEndpointBuilder.getLocalizedSuffix(localized)).orElse("");
            operationId = CatalogDataApiRootDescriptor.GET_ENTITY.operation((NamedSchemaContract)entitySchema, suffix);
        } else {
            operationId = CatalogDataApiRootDescriptor.GET_ENTITY.operation((NamedSchemaContract)entitySchema, DataApiEndpointBuilder.getLocalizedSuffix(localized));
        }
        return OpenApiCollectionEndpoint.newCollectionEndpoint(this.buildingContext.getSchema(), entitySchema).path(localized, p -> p.staticItem(CatalogDataApiRootDescriptor.GET_ENTITY.urlPathItem()).paramItem(withPkInPath ? (OpenApiEndpointParameter.Builder)GetEntityEndpointHeaderDescriptor.PRIMARY_KEY.to((PropertyDescriptorTransformer)this.operationPathParameterBuilderTransformer) : null)).method(PathItem.HttpMethod.GET).operationId(operationId).description(CatalogDataApiRootDescriptor.GET_ENTITY.description(new Object[]{entitySchema.getName()})).deprecationNotice(entitySchema.getDeprecationNotice()).queryParameters(this.buildGetEntityQueryParameters(entitySchema, localized, withPkInPath)).successResponse(OpenApiTypeReference.typeRefTo(DataApiNamesConstructor.constructEntityObjectName(entitySchema, localized))).handler(GetEntityHandler::new).build();
    }

    @Nonnull
    public OpenApiCollectionEndpoint buildListEntityEndpoint(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        return OpenApiCollectionEndpoint.newCollectionEndpoint(this.buildingContext.getSchema(), entitySchema).path(localized, p -> p.staticItem(CatalogDataApiRootDescriptor.LIST_ENTITY.urlPathItem())).method(PathItem.HttpMethod.POST).operationId(CatalogDataApiRootDescriptor.LIST_ENTITY.operation((NamedSchemaContract)entitySchema, DataApiEndpointBuilder.getLocalizedSuffix(localized))).description(CatalogDataApiRootDescriptor.LIST_ENTITY.description(new Object[]{entitySchema.getName()})).deprecationNotice(entitySchema.getDeprecationNotice()).requestBody(OpenApiTypeReference.typeRefTo(DataApiNamesConstructor.constructEntityListRequestBodyObjectName(entitySchema, localized))).successResponse(OpenApiNonNull.nonNull(OpenApiTypeReference.typeRefTo(DataApiNamesConstructor.constructEntityObjectName(entitySchema, localized)))).handler(ListEntitiesHandler::new).build();
    }

    @Nonnull
    public OpenApiCollectionEndpoint buildQueryEntityEndpoint(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        return OpenApiCollectionEndpoint.newCollectionEndpoint(this.buildingContext.getSchema(), entitySchema).path(localized, p -> p.staticItem(CatalogDataApiRootDescriptor.QUERY_ENTITY.urlPathItem())).method(PathItem.HttpMethod.POST).operationId(CatalogDataApiRootDescriptor.QUERY_ENTITY.operation((NamedSchemaContract)entitySchema, DataApiEndpointBuilder.getLocalizedSuffix(localized))).description(CatalogDataApiRootDescriptor.QUERY_ENTITY.description(new Object[]{entitySchema.getName()})).deprecationNotice(entitySchema.getDeprecationNotice()).requestBody(OpenApiTypeReference.typeRefTo(DataApiNamesConstructor.constructEntityQueryRequestBodyObjectName(entitySchema, localized))).successResponse(OpenApiNonNull.nonNull(OpenApiTypeReference.typeRefTo(DataApiNamesConstructor.constructEntityFullResponseObjectName(entitySchema, localized)))).handler(QueryEntitiesHandler::new).build();
    }

    @Nonnull
    public OpenApiCatalogEndpoint buildCollectionsEndpoint(@Nonnull CatalogRestBuildingContext buildingContext) {
        return OpenApiCatalogEndpoint.newCatalogEndpoint(buildingContext.getSchema()).path(p -> p.staticItem(CatalogDataApiRootDescriptor.COLLECTIONS.urlPathItem())).method(PathItem.HttpMethod.GET).operationId(CatalogDataApiRootDescriptor.COLLECTIONS.operation()).description(CatalogDataApiRootDescriptor.COLLECTIONS.description()).queryParameter(((OpenApiEndpointParameter.Builder)CollectionsEndpointHeaderDescriptor.ENTITY_COUNT.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).type(DataTypesConverter.getOpenApiScalar(Boolean.class)).build()).successResponse(OpenApiNonNull.nonNull(OpenApiArray.arrayOf(OpenApiTypeReference.typeRefTo(CollectionDescriptor.THIS.name())))).handler(CollectionsHandler::new).build();
    }

    @Nonnull
    public Optional<OpenApiCatalogEndpoint> buildGetUnknownEntityEndpoint(@Nonnull CatalogRestBuildingContext buildingContext, @Nonnull List<GlobalAttributeSchemaContract> globallyUniqueAttributes, boolean localized) {
        if (buildingContext.getEntitySchemas().isEmpty()) {
            return Optional.empty();
        }
        LinkedList<OpenApiEndpointParameter> queryParameters = new LinkedList<OpenApiEndpointParameter>();
        queryParameters.addAll(globallyUniqueAttributes.stream().map(arg -> OpenApiEndpointParameter.newQueryParameter().name(arg.getNameVariant(ExternalApiNamingConventions.ARGUMENT_NAME_NAMING_CONVENTION)).description(arg.getDescription()).deprecationNotice(arg.getDeprecationNotice()).type(DataTypesConverter.getOpenApiScalar(arg.getPlainType())).build()).toList());
        queryParameters.add(((OpenApiEndpointParameter.Builder)UnknownEntityEndpointHeaderDescriptor.FILTER_JOIN.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        boolean localeArgumentNeeded = globallyUniqueAttributes.stream().anyMatch(GlobalAttributeSchemaContract::isUniqueGloballyWithinLocale);
        queryParameters.addAll(this.buildFetchQueryParametersForUnknownEntity(!localized || localeArgumentNeeded));
        return Optional.of(OpenApiCatalogEndpoint.newCatalogEndpoint(buildingContext.getSchema()).path(localized, p -> p.staticItem(CatalogDataApiRootDescriptor.GET_UNKNOWN_ENTITY.classifier()).staticItem(CatalogDataApiRootDescriptor.GET_UNKNOWN_ENTITY.urlPathItem())).method(PathItem.HttpMethod.GET).operationId(CatalogDataApiRootDescriptor.GET_UNKNOWN_ENTITY.operation(DataApiEndpointBuilder.getLocalizedSuffix(localized))).description(CatalogDataApiRootDescriptor.GET_UNKNOWN_ENTITY.description()).queryParameters(queryParameters).successResponse(OpenApiTypeReference.typeRefTo(localized ? EntityUnion.THIS_LOCALIZED.name() : EntityUnion.THIS.name())).handler(GetUnknownEntityHandler::new).build());
    }

    @Nonnull
    public Optional<OpenApiCatalogEndpoint> buildListUnknownEntityEndpoint(@Nonnull CatalogRestBuildingContext buildingContext, @Nonnull List<GlobalAttributeSchemaContract> globallyUniqueAttributes, boolean localized) {
        if (buildingContext.getEntitySchemas().isEmpty()) {
            return Optional.empty();
        }
        LinkedList<OpenApiEndpointParameter> queryParameters = new LinkedList<OpenApiEndpointParameter>();
        queryParameters.add(((OpenApiEndpointParameter.Builder)ListUnknownEntitiesEndpointHeaderDescriptor.LIMIT.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        queryParameters.addAll(globallyUniqueAttributes.stream().map(arg -> OpenApiEndpointParameter.newQueryParameter().name(arg.getNameVariant(ExternalApiNamingConventions.ARGUMENT_NAME_NAMING_CONVENTION)).description(arg.getDescription()).deprecationNotice(arg.getDeprecationNotice()).type(OpenApiArray.arrayOf(DataTypesConverter.getOpenApiScalar(arg.getPlainType()))).build()).toList());
        queryParameters.add(((OpenApiEndpointParameter.Builder)ListUnknownEntitiesEndpointHeaderDescriptor.FILTER_JOIN.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        boolean localeArgumentNeeded = globallyUniqueAttributes.stream().anyMatch(GlobalAttributeSchemaContract::isUniqueGloballyWithinLocale);
        queryParameters.addAll(this.buildFetchQueryParametersForUnknownEntity(!localized || localeArgumentNeeded));
        return Optional.of(OpenApiCatalogEndpoint.newCatalogEndpoint(buildingContext.getSchema()).path(localized, p -> p.staticItem(CatalogDataApiRootDescriptor.LIST_UNKNOWN_ENTITY.classifier()).staticItem(CatalogDataApiRootDescriptor.LIST_UNKNOWN_ENTITY.urlPathItem())).method(PathItem.HttpMethod.GET).operationId(CatalogDataApiRootDescriptor.LIST_UNKNOWN_ENTITY.operation(DataApiEndpointBuilder.getLocalizedSuffix(localized))).description(CatalogDataApiRootDescriptor.LIST_UNKNOWN_ENTITY.description()).queryParameters(queryParameters).successResponse(OpenApiNonNull.nonNull(OpenApiArray.arrayOf(OpenApiTypeReference.typeRefTo(localized ? EntityUnion.THIS_LOCALIZED.name() : EntityUnion.THIS.name())))).handler(ListUnknownEntitiesHandler::new).build());
    }

    @Nonnull
    public OpenApiCollectionEndpoint buildUpsertEntityEndpoint(@Nonnull EntitySchemaContract entitySchema, boolean withPrimaryKeyInPath) {
        return OpenApiCollectionEndpoint.newCollectionEndpoint(this.buildingContext.getSchema(), entitySchema).path(p -> p.staticItem(CatalogDataApiRootDescriptor.UPSERT_ENTITY.urlPathItem()).paramItem(withPrimaryKeyInPath ? (OpenApiEndpointParameter.Builder)UpsertEntityEndpointHeaderDescriptor.PRIMARY_KEY.to((PropertyDescriptorTransformer)this.operationPathParameterBuilderTransformer) : null)).method(withPrimaryKeyInPath ? PathItem.HttpMethod.PUT : PathItem.HttpMethod.POST).operationId(CatalogDataApiRootDescriptor.UPSERT_ENTITY.operation((NamedSchemaContract)entitySchema)).description(CatalogDataApiRootDescriptor.UPSERT_ENTITY.description(new Object[]{entitySchema.getName()})).deprecationNotice(entitySchema.getDeprecationNotice()).requestBody(OpenApiTypeReference.typeRefTo(EntityUpsertRequestDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema}))).successResponse(OpenApiNonNull.nonNull(OpenApiTypeReference.typeRefTo(DataApiNamesConstructor.constructEntityObjectName(entitySchema, false)))).handler(ctx -> new UpsertEntityHandler((CollectionRestHandlingContext)ctx, withPrimaryKeyInPath)).build();
    }

    @Nonnull
    public OpenApiCollectionEndpoint buildDeleteEntityEndpoint(@Nonnull EntitySchemaContract entitySchema) {
        return OpenApiCollectionEndpoint.newCollectionEndpoint(this.buildingContext.getSchema(), entitySchema).path(p -> p.staticItem(CatalogDataApiRootDescriptor.DELETE_ENTITY.urlPathItem()).paramItem(((OpenApiEndpointParameter.Builder)DeleteEntityEndpointHeaderDescriptor.PRIMARY_KEY.to((PropertyDescriptorTransformer)this.operationPathParameterBuilderTransformer)).type(DataTypesConverter.getOpenApiScalar(Integer.class, true)))).method(PathItem.HttpMethod.DELETE).operationId(CatalogDataApiRootDescriptor.DELETE_ENTITY.operation((NamedSchemaContract)entitySchema)).description(CatalogDataApiRootDescriptor.DELETE_ENTITY.description(new Object[]{entitySchema.getName()})).deprecationNotice(entitySchema.getDeprecationNotice()).queryParameters(this.buildEntityFetchQueryParameters(entitySchema)).successResponse(OpenApiTypeReference.typeRefTo(DataApiNamesConstructor.constructEntityObjectName(entitySchema, false))).handler(DeleteEntityHandler::new).build();
    }

    @Nonnull
    public OpenApiCollectionEndpoint buildDeleteEntitiesByQueryEndpoint(@Nonnull EntitySchemaContract entitySchema) {
        return OpenApiCollectionEndpoint.newCollectionEndpoint(this.buildingContext.getSchema(), entitySchema).path(p -> p.staticItem(CatalogDataApiRootDescriptor.DELETE_ENTITY.urlPathItem())).method(PathItem.HttpMethod.DELETE).operationId(CatalogDataApiRootDescriptor.DELETE_ENTITY.operation((NamedSchemaContract)entitySchema, DELETE_BY_QUERY_OPERATION_ID_SUFFIX)).description(CatalogDataApiRootDescriptor.DELETE_ENTITY.description(new Object[]{entitySchema.getName()})).deprecationNotice(entitySchema.getDeprecationNotice()).requestBody(OpenApiTypeReference.typeRefTo(FetchEntityRequestDescriptor.THIS_DELETE.name(new NamedSchemaContract[]{entitySchema}))).successResponse(OpenApiNonNull.nonNull(OpenApiTypeReference.typeRefTo(DataApiNamesConstructor.constructEntityObjectName(entitySchema, false)))).handler(DeleteEntitiesByQueryHandler::new).build();
    }

    @Nonnull
    private List<OpenApiEndpointParameter> buildFetchQueryParametersForUnknownEntity(boolean needsLocale) {
        ArrayList<OpenApiEndpointParameter> queryParameters = new ArrayList<OpenApiEndpointParameter>(8);
        if (needsLocale) {
            queryParameters.add(((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.LOCALE.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        }
        queryParameters.add(((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.DATA_IN_LOCALES.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        queryParameters.add(((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.FETCH_ALL.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        queryParameters.add(((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.BODY_FETCH.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        queryParameters.add(((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.ASSOCIATED_DATA_CONTENT_ALL.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        queryParameters.add(((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.ATTRIBUTE_CONTENT_ALL.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        queryParameters.add(((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.PRICE_CONTENT.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        queryParameters.add(((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.REFERENCE_CONTENT_ALL.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        queryParameters.add(((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.HIERARCHY_CONTENT.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        return queryParameters;
    }

    @Nonnull
    private List<OpenApiEndpointParameter> buildGetEntityQueryParameters(@Nonnull EntitySchemaContract entitySchema, boolean localized, boolean withPkInPath) {
        LinkedList<OpenApiEndpointParameter> parameters = new LinkedList<OpenApiEndpointParameter>();
        if (!withPkInPath) {
            parameters.add(((OpenApiEndpointParameter.Builder)GetEntityEndpointHeaderDescriptor.PRIMARY_KEY.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        }
        if (!entitySchema.getLocales().isEmpty()) {
            OpenApiTypeReference localeEnum = OpenApiTypeReference.typeRefTo(CatalogDataApiRootDescriptor.LOCALE_ENUM.name());
            if (!localized) {
                OpenApiEndpointParameter dataInLocalesParameter = ((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.DATA_IN_LOCALES.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).type(OpenApiArray.arrayOf(localeEnum)).build();
                parameters.add(dataInLocalesParameter);
                OpenApiEndpointParameter localeParameter = ((OpenApiEndpointParameter.Builder)GetEntityEndpointHeaderDescriptor.LOCALE.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).type(localeEnum).build();
                parameters.add(localeParameter);
            }
        }
        if (!entitySchema.getCurrencies().isEmpty()) {
            parameters.add(((OpenApiEndpointParameter.Builder)GetEntityEndpointHeaderDescriptor.PRICE_IN_CURRENCY.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).type(OpenApiTypeReference.typeRefTo(CatalogDataApiRootDescriptor.CURRENCY_ENUM.name())).build());
            parameters.add(((OpenApiEndpointParameter.Builder)GetEntityEndpointHeaderDescriptor.PRICE_IN_PRICE_LISTS.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
            parameters.add(((OpenApiEndpointParameter.Builder)GetEntityEndpointHeaderDescriptor.PRICE_VALID_IN.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
            parameters.add(((OpenApiEndpointParameter.Builder)GetEntityEndpointHeaderDescriptor.PRICE_VALID_NOW.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        }
        if (!withPkInPath) {
            parameters.addAll(entitySchema.getAttributes().values().stream().filter(AttributeSchemaContract::isUnique).map(as -> OpenApiEndpointParameter.newQueryParameter().name(as.getNameVariant(ExternalApiNamingConventions.ARGUMENT_NAME_NAMING_CONVENTION)).description(as.getDescription()).deprecationNotice(as.getDeprecationNotice()).type(DataTypesConverter.getOpenApiScalar(as.getPlainType())).build()).toList());
        }
        parameters.addAll(this.buildEntityFetchQueryParameters(entitySchema));
        return parameters;
    }

    @Nonnull
    private List<OpenApiEndpointParameter> buildEntityFetchQueryParameters(@Nonnull EntitySchemaContract entitySchema) {
        LinkedList<OpenApiEndpointParameter> parameters = new LinkedList<OpenApiEndpointParameter>();
        parameters.add(((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.FETCH_ALL.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        parameters.add(((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.BODY_FETCH.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        if (!entitySchema.getAssociatedData().isEmpty()) {
            parameters.add(((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.ASSOCIATED_DATA_CONTENT.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
            parameters.add(((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.ASSOCIATED_DATA_CONTENT_ALL.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        }
        if (!entitySchema.getAttributes().isEmpty()) {
            parameters.add(((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.ATTRIBUTE_CONTENT.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
            parameters.add(((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.ATTRIBUTE_CONTENT_ALL.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        }
        if (!entitySchema.getCurrencies().isEmpty()) {
            parameters.add(((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.PRICE_CONTENT.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        }
        if (!entitySchema.getReferences().isEmpty()) {
            parameters.add(((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.REFERENCE_CONTENT.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
            parameters.add(((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.REFERENCE_CONTENT_ALL.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        }
        if (entitySchema.isWithHierarchy()) {
            parameters.add(((OpenApiEndpointParameter.Builder)FetchEntityEndpointHeaderDescriptor.HIERARCHY_CONTENT.to((PropertyDescriptorTransformer)this.operationQueryParameterBuilderTransformer)).build());
        }
        return parameters;
    }

    @Nullable
    private static String getLocalizedSuffix(boolean localized) {
        return localized ? LOCALIZED_OPERATION_ID_SUFFIX : null;
    }

    public DataApiEndpointBuilder(@Nonnull CatalogRestBuildingContext buildingContext, @Nonnull PropertyDescriptorToOpenApiOperationPathParameterTransformer operationPathParameterBuilderTransformer, @Nonnull PropertyDescriptorToOpenApiOperationQueryParameterTransformer operationQueryParameterBuilderTransformer) {
        if (buildingContext == null) {
            throw new NullPointerException("buildingContext is marked non-null but is null");
        }
        if (operationPathParameterBuilderTransformer == null) {
            throw new NullPointerException("operationPathParameterBuilderTransformer is marked non-null but is null");
        }
        if (operationQueryParameterBuilderTransformer == null) {
            throw new NullPointerException("operationQueryParameterBuilderTransformer is marked non-null but is null");
        }
        this.buildingContext = buildingContext;
        this.operationPathParameterBuilderTransformer = operationPathParameterBuilderTransformer;
        this.operationQueryParameterBuilderTransformer = operationQueryParameterBuilderTransformer;
    }
}

