/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.builder;

import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.NamedSchemaContract;
import io.evitadb.api.requestResponse.schema.ReferenceSchemaContract;
import io.evitadb.externalApi.api.catalog.dataApi.model.AttributesDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.EntityDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.RecordPageDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.RecordStripDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.ReferenceDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.ResponseDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.ExtraResultsDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.FacetSummaryDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.HierarchyDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.DataChunkUnionDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.FetchEntityRequestDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.extraResult.HierarchyOfDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.extraResult.LevelInfoDescriptor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataApiNamesConstructor {
    private static final String LOCALIZED_ENTITY_NAME_SUFFIX = "Localized";

    @Nonnull
    public static String constructEntityObjectName(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        return EntityDescriptor.THIS.name(DataApiNamesConstructor.getLocalizedSuffix(localized), new NamedSchemaContract[]{entitySchema});
    }

    @Nonnull
    public static String constructEntityListRequestBodyObjectName(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        return FetchEntityRequestDescriptor.THIS_LIST.name(DataApiNamesConstructor.getLocalizedSuffix(localized), new NamedSchemaContract[]{entitySchema});
    }

    @Nonnull
    public static String constructEntityQueryRequestBodyObjectName(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        return FetchEntityRequestDescriptor.THIS_QUERY.name(DataApiNamesConstructor.getLocalizedSuffix(localized), new NamedSchemaContract[]{entitySchema});
    }

    @Nonnull
    public static String constructReferenceObjectName(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        return ReferenceDescriptor.THIS.name(DataApiNamesConstructor.getLocalizedSuffix(localized), new NamedSchemaContract[]{entitySchema, referenceSchema});
    }

    @Nonnull
    public static String constructReferenceAttributesObjectName(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        return AttributesDescriptor.THIS.name(DataApiNamesConstructor.getLocalizedSuffix(localized), new NamedSchemaContract[]{entitySchema, referenceSchema});
    }

    @Nonnull
    public static String constructEntityFullResponseObjectName(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        return ResponseDescriptor.THIS.name(DataApiNamesConstructor.getLocalizedSuffix(localized), new NamedSchemaContract[]{entitySchema});
    }

    @Nonnull
    public static String constructEntityDataChunkAggregateObjectName(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        return DataChunkUnionDescriptor.THIS.name(DataApiNamesConstructor.getLocalizedSuffix(localized), new NamedSchemaContract[]{entitySchema});
    }

    @Nonnull
    public static String constructRecordPageObjectName(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        return RecordPageDescriptor.THIS.name(DataApiNamesConstructor.getLocalizedSuffix(localized), new NamedSchemaContract[]{entitySchema});
    }

    @Nonnull
    public static String constructRecordStripObjectName(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        return RecordStripDescriptor.THIS.name(DataApiNamesConstructor.getLocalizedSuffix(localized), new NamedSchemaContract[]{entitySchema});
    }

    @Nonnull
    public static String constructExtraResultsObjectName(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        return ExtraResultsDescriptor.THIS.name(DataApiNamesConstructor.getLocalizedSuffix(localized), new NamedSchemaContract[]{entitySchema});
    }

    @Nonnull
    public static String constructFacetGroupStatisticsObjectName(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        return FacetSummaryDescriptor.FacetGroupStatisticsDescriptor.THIS.name(DataApiNamesConstructor.getLocalizedSuffix(localized), new NamedSchemaContract[]{entitySchema, referenceSchema});
    }

    @Nonnull
    public static String constructFacetStatisticsObjectName(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        return FacetSummaryDescriptor.FacetStatisticsDescriptor.THIS.name(DataApiNamesConstructor.getLocalizedSuffix(localized), new NamedSchemaContract[]{entitySchema, referenceSchema});
    }

    @Nonnull
    public static String constructFacetSummaryObjectName(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        return FacetSummaryDescriptor.THIS.name(DataApiNamesConstructor.getLocalizedSuffix(localized), new NamedSchemaContract[]{entitySchema});
    }

    @Nonnull
    public static String constructHierarchyObjectName(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        return HierarchyDescriptor.THIS.name(DataApiNamesConstructor.getLocalizedSuffix(localized), new NamedSchemaContract[]{entitySchema});
    }

    @Nonnull
    public static String constructHierarchyOfSelfObjectName(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        return HierarchyOfDescriptor.THIS.name(DataApiNamesConstructor.getLocalizedSuffix(localized), new NamedSchemaContract[]{entitySchema, entitySchema});
    }

    @Nonnull
    public static String constructHierarchyOfReferenceObjectName(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        return HierarchyOfDescriptor.THIS.name(DataApiNamesConstructor.getLocalizedSuffix(localized), new NamedSchemaContract[]{entitySchema, referenceSchema});
    }

    @Nonnull
    public static String constructSelfLevelInfoObjectName(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        return LevelInfoDescriptor.THIS.name(DataApiNamesConstructor.getLocalizedSuffix(localized), new NamedSchemaContract[]{entitySchema, entitySchema});
    }

    @Nonnull
    public static String constructLevelInfoObjectName(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        return LevelInfoDescriptor.THIS.name(DataApiNamesConstructor.getLocalizedSuffix(localized), new NamedSchemaContract[]{entitySchema, referenceSchema});
    }

    @Nullable
    private static String getLocalizedSuffix(boolean localized) {
        return localized ? LOCALIZED_ENTITY_NAME_SUFFIX : null;
    }

    private DataApiNamesConstructor() {
    }
}

