/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.builder;

import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.EvolutionMode;
import io.evitadb.api.requestResponse.schema.NamedSchemaContract;
import io.evitadb.externalApi.api.catalog.dataApi.model.mutation.LocalMutationAggregateDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.mutation.associatedData.RemoveAssociatedDataMutationDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.mutation.associatedData.UpsertAssociatedDataMutationDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.mutation.attribute.ApplyDeltaAttributeMutationDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.mutation.attribute.ReferenceAttributeMutationAggregateDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.mutation.attribute.RemoveAttributeMutationDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.mutation.attribute.UpsertAttributeMutationDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.mutation.entity.SetParentMutationDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.mutation.price.RemovePriceMutationDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.mutation.price.SetPriceInnerRecordHandlingMutationDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.mutation.price.UpsertPriceMutationDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.mutation.reference.InsertReferenceMutationDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.mutation.reference.ReferenceAttributeMutationDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.mutation.reference.RemoveReferenceGroupMutationDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.mutation.reference.RemoveReferenceMutationDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.mutation.reference.SetReferenceGroupMutationDescriptor;
import io.evitadb.externalApi.api.model.ObjectDescriptorTransformer;
import io.evitadb.externalApi.api.model.PropertyDescriptorTransformer;
import io.evitadb.externalApi.rest.api.catalog.builder.CatalogRestBuildingContext;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.constraint.RequireConstraintSchemaBuilder;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.EntityUpsertRequestDescriptor;
import io.evitadb.externalApi.rest.api.dataType.DataTypesConverter;
import io.evitadb.externalApi.rest.api.model.ObjectDescriptorToOpenApiObjectTransformer;
import io.evitadb.externalApi.rest.api.model.PropertyDescriptorToOpenApiPropertyTransformer;
import io.evitadb.externalApi.rest.api.openApi.OpenApiArray;
import io.evitadb.externalApi.rest.api.openApi.OpenApiNonNull;
import io.evitadb.externalApi.rest.api.openApi.OpenApiObject;
import io.evitadb.externalApi.rest.api.openApi.OpenApiProperty;
import io.evitadb.externalApi.rest.api.openApi.OpenApiSimpleType;
import io.evitadb.externalApi.rest.api.openApi.OpenApiTypeReference;
import java.util.Optional;
import javax.annotation.Nonnull;

public class DataMutationBuilder {
    @Nonnull
    private final CatalogRestBuildingContext buildingContext;
    @Nonnull
    private final PropertyDescriptorToOpenApiPropertyTransformer propertyBuilderTransformer;
    @Nonnull
    private final ObjectDescriptorToOpenApiObjectTransformer objectBuilderTransformer;
    @Nonnull
    private final RequireConstraintSchemaBuilder requireConstraintSchemaBuilder;

    public DataMutationBuilder(@Nonnull CatalogRestBuildingContext buildingContext, @Nonnull PropertyDescriptorToOpenApiPropertyTransformer propertyBuilderTransformer, @Nonnull ObjectDescriptorToOpenApiObjectTransformer objectBuilderTransformer, @Nonnull RequireConstraintSchemaBuilder requireConstraintSchemaBuilder) {
        this.buildingContext = buildingContext;
        this.propertyBuilderTransformer = propertyBuilderTransformer;
        this.objectBuilderTransformer = objectBuilderTransformer;
        this.requireConstraintSchemaBuilder = requireConstraintSchemaBuilder;
    }

    public void buildCommonTypes() {
        this.buildingContext.registerType(((OpenApiObject.Builder)RemoveAssociatedDataMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)UpsertAssociatedDataMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)ApplyDeltaAttributeMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)RemoveAttributeMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)UpsertAttributeMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)SetParentMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)SetPriceInnerRecordHandlingMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)RemovePriceMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)UpsertPriceMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)InsertReferenceMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)RemoveReferenceMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)SetReferenceGroupMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)RemoveReferenceGroupMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)ReferenceAttributeMutationDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)ReferenceAttributeMutationAggregateDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
    }

    @Nonnull
    public OpenApiTypeReference buildEntityUpsertRequestObject(@Nonnull EntitySchemaContract entitySchema) {
        OpenApiObject.Builder upsertEntityObjectBuilder = ((OpenApiObject.Builder)EntityUpsertRequestDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(EntityUpsertRequestDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema}));
        Optional<OpenApiTypeReference> localMutationSchema = this.buildLocalMutationSchema(entitySchema);
        localMutationSchema.ifPresent(objectSchema -> upsertEntityObjectBuilder.property(((OpenApiProperty.Builder)EntityUpsertRequestDescriptor.MUTATIONS.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(OpenApiArray.arrayOf((OpenApiSimpleType)localMutationSchema.get())))));
        upsertEntityObjectBuilder.property(((OpenApiProperty.Builder)EntityUpsertRequestDescriptor.REQUIRE.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(this.requireConstraintSchemaBuilder.build(entitySchema.getName()))));
        return this.buildingContext.registerType(upsertEntityObjectBuilder.build());
    }

    @Nonnull
    private Optional<OpenApiTypeReference> buildLocalMutationSchema(@Nonnull EntitySchemaContract entitySchema) {
        String schemaName = LocalMutationAggregateDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema});
        OpenApiObject.Builder localMutationObjectBuilder = ((OpenApiObject.Builder)LocalMutationAggregateDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(schemaName).description(LocalMutationAggregateDescriptor.THIS.description(new Object[]{entitySchema.getName()}));
        boolean hasAnyMutations = false;
        if (!entitySchema.getAssociatedData().isEmpty() || entitySchema.getEvolutionMode().contains(EvolutionMode.ADDING_ASSOCIATED_DATA)) {
            hasAnyMutations = true;
            localMutationObjectBuilder.property((OpenApiProperty.Builder)LocalMutationAggregateDescriptor.REMOVE_ASSOCIATED_DATA_MUTATION.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
            localMutationObjectBuilder.property((OpenApiProperty.Builder)LocalMutationAggregateDescriptor.UPSERT_ASSOCIATED_DATA_MUTATION.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
        }
        if (!entitySchema.getAttributes().isEmpty() || entitySchema.getEvolutionMode().contains(EvolutionMode.ADDING_ATTRIBUTES)) {
            hasAnyMutations = true;
            localMutationObjectBuilder.property((OpenApiProperty.Builder)LocalMutationAggregateDescriptor.APPLY_DELTA_ATTRIBUTE_MUTATION.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
            localMutationObjectBuilder.property((OpenApiProperty.Builder)LocalMutationAggregateDescriptor.REMOVE_ATTRIBUTE_MUTATION.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
            localMutationObjectBuilder.property((OpenApiProperty.Builder)LocalMutationAggregateDescriptor.UPSERT_ATTRIBUTE_MUTATION.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
        }
        if (entitySchema.isWithHierarchy() || entitySchema.getEvolutionMode().contains(EvolutionMode.ADDING_HIERARCHY)) {
            hasAnyMutations = true;
            localMutationObjectBuilder.property(((OpenApiProperty.Builder)LocalMutationAggregateDescriptor.REMOVE_PARENT_MUTATION.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(DataTypesConverter.getOpenApiScalar(Boolean.class)));
            localMutationObjectBuilder.property((OpenApiProperty.Builder)LocalMutationAggregateDescriptor.SET_PARENT_MUTATION.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
        }
        if (entitySchema.isWithPrice() || entitySchema.getEvolutionMode().contains(EvolutionMode.ADDING_PRICES)) {
            hasAnyMutations = true;
            localMutationObjectBuilder.property((OpenApiProperty.Builder)LocalMutationAggregateDescriptor.SET_PRICE_INNER_RECORD_HANDLING_MUTATION.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
            localMutationObjectBuilder.property((OpenApiProperty.Builder)LocalMutationAggregateDescriptor.REMOVE_PRICE_MUTATION.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
            localMutationObjectBuilder.property((OpenApiProperty.Builder)LocalMutationAggregateDescriptor.UPSERT_PRICE_MUTATION.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
        }
        if (!entitySchema.getReferences().isEmpty() || entitySchema.getEvolutionMode().contains(EvolutionMode.ADDING_REFERENCES)) {
            hasAnyMutations = true;
            localMutationObjectBuilder.property((OpenApiProperty.Builder)LocalMutationAggregateDescriptor.INSERT_REFERENCE_MUTATION.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
            localMutationObjectBuilder.property((OpenApiProperty.Builder)LocalMutationAggregateDescriptor.REMOVE_REFERENCE_MUTATION.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
            localMutationObjectBuilder.property((OpenApiProperty.Builder)LocalMutationAggregateDescriptor.SET_REFERENCE_GROUP_MUTATION.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
            localMutationObjectBuilder.property((OpenApiProperty.Builder)LocalMutationAggregateDescriptor.REMOVE_REFERENCE_GROUP_MUTATION.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
            localMutationObjectBuilder.property((OpenApiProperty.Builder)LocalMutationAggregateDescriptor.REFERENCE_ATTRIBUTE_MUTATION.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
        }
        if (!hasAnyMutations) {
            return Optional.empty();
        }
        return Optional.of(this.buildingContext.registerType(localMutationObjectBuilder.build()));
    }
}

