/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.builder;

import io.evitadb.api.requestResponse.schema.AssociatedDataSchemaContract;
import io.evitadb.api.requestResponse.schema.AttributeSchemaContract;
import io.evitadb.api.requestResponse.schema.Cardinality;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.NamedSchemaContract;
import io.evitadb.api.requestResponse.schema.ReferenceSchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.api.catalog.dataApi.model.AssociatedDataDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.AttributesDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.PriceDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.ReferenceDescriptor;
import io.evitadb.externalApi.api.model.ObjectDescriptorTransformer;
import io.evitadb.externalApi.api.model.PropertyDescriptorTransformer;
import io.evitadb.externalApi.rest.api.catalog.builder.CatalogRestBuildingContext;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.DataApiNamesConstructor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.entity.GlobalAssociatedDataDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.entity.GlobalAttributesDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.entity.LocalizedAssociatedDataDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.entity.LocalizedAssociatedDataForLocaleDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.entity.LocalizedAttributesDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.entity.LocalizedAttributesForLocaleDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.entity.RestEntityDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.entity.SectionedAssociatedDataDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.entity.SectionedAttributesDescriptor;
import io.evitadb.externalApi.rest.api.dataType.DataTypesConverter;
import io.evitadb.externalApi.rest.api.model.ObjectDescriptorToOpenApiObjectTransformer;
import io.evitadb.externalApi.rest.api.model.PropertyDescriptorToOpenApiPropertyTransformer;
import io.evitadb.externalApi.rest.api.openApi.OpenApiArray;
import io.evitadb.externalApi.rest.api.openApi.OpenApiNonNull;
import io.evitadb.externalApi.rest.api.openApi.OpenApiObject;
import io.evitadb.externalApi.rest.api.openApi.OpenApiProperty;
import io.evitadb.externalApi.rest.api.openApi.OpenApiSimpleType;
import io.evitadb.externalApi.rest.api.openApi.OpenApiTypeReference;
import io.evitadb.externalApi.rest.exception.OpenApiBuildingError;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityObjectBuilder {
    @Nonnull
    private final CatalogRestBuildingContext buildingContext;
    @Nonnull
    private final PropertyDescriptorToOpenApiPropertyTransformer propertyBuilderTransformer;
    @Nonnull
    private final ObjectDescriptorToOpenApiObjectTransformer objectBuilderTransformer;

    public void buildCommonTypes() {
        this.buildingContext.registerType(((OpenApiObject.Builder)PriceDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)RestEntityDescriptor.THIS_REFERENCE.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
    }

    @Nonnull
    public OpenApiObject buildEntityObject(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        String objectName = DataApiNamesConstructor.constructEntityObjectName(entitySchema, localized);
        OpenApiObject.Builder entityObject = ((OpenApiObject.Builder)RestEntityDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(objectName).description(entitySchema.getDescription());
        if (!entitySchema.getLocales().isEmpty()) {
            entityObject.property((OpenApiProperty.Builder)RestEntityDescriptor.LOCALES.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
            entityObject.property((OpenApiProperty.Builder)RestEntityDescriptor.ALL_LOCALES.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
        }
        if (entitySchema.isWithHierarchy()) {
            entityObject.property(((OpenApiProperty.Builder)RestEntityDescriptor.PARENT_ENTITY.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiTypeReference.typeRefTo(objectName)));
        }
        if (!entitySchema.getCurrencies().isEmpty()) {
            entityObject.property((OpenApiProperty.Builder)RestEntityDescriptor.PRICE_INNER_RECORD_HANDLING.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
            entityObject.property((OpenApiProperty.Builder)RestEntityDescriptor.PRICE_FOR_SALE.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
            entityObject.property((OpenApiProperty.Builder)RestEntityDescriptor.MULTIPLE_PRICES_FOR_SALE_AVAILABLE.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
            entityObject.property((OpenApiProperty.Builder)RestEntityDescriptor.PRICES.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer));
        }
        if (!entitySchema.getAttributes().isEmpty()) {
            entityObject.property(this.buildEntityAttributesProperty(entitySchema, localized));
        }
        if (!entitySchema.getAssociatedData().isEmpty()) {
            entityObject.property(this.buildEntityAssociatedDataProperty(entitySchema, localized));
        }
        if (!entitySchema.getReferences().isEmpty()) {
            this.buildEntityReferenceProperties(entitySchema, localized).forEach(entityObject::property);
        }
        return entityObject.build();
    }

    @Nonnull
    private OpenApiProperty buildEntityAttributesProperty(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        OpenApiTypeReference attributesObject = this.buildEntityAttributesObject(entitySchema, localized);
        return ((OpenApiProperty.Builder)RestEntityDescriptor.ATTRIBUTES.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(attributesObject)).build();
    }

    @Nonnull
    private OpenApiTypeReference buildEntityAttributesObject(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        OpenApiObject attributesObject = localized ? this.buildLocalizedAttributesObject(entitySchema.getAttributes().values(), new NamedSchemaContract[]{entitySchema}) : this.buildNonLocalizedAttributesObject(entitySchema, entitySchema.getAttributes().values(), new NamedSchemaContract[]{entitySchema});
        return this.buildingContext.registerType(attributesObject);
    }

    @Nonnull
    private OpenApiObject buildLocalizedAttributesObject(@Nonnull Collection<? extends AttributeSchemaContract> attributeSchemas, NamedSchemaContract ... objectNameSchemas) {
        OpenApiObject.Builder attributesObject = ((OpenApiObject.Builder)AttributesDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(AttributesDescriptor.THIS.name(objectNameSchemas));
        attributeSchemas.forEach(attributeSchema -> attributesObject.property(EntityObjectBuilder.buildAttributeProperty(attributeSchema)));
        return attributesObject.build();
    }

    @Nonnull
    private OpenApiObject buildNonLocalizedAttributesObject(@Nonnull EntitySchemaContract entitySchema, @Nonnull Collection<? extends AttributeSchemaContract> attributeSchemas, NamedSchemaContract ... objectNameSchemas) {
        OpenApiObject.Builder attributesObject = ((OpenApiObject.Builder)SectionedAttributesDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(SectionedAttributesDescriptor.THIS.name(objectNameSchemas));
        OpenApiObject.Builder globalAttributesObjectBuilder = ((OpenApiObject.Builder)GlobalAttributesDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(GlobalAttributesDescriptor.THIS.name(objectNameSchemas));
        OpenApiObject.Builder localizedAttributesForLocaleObjectBuilder = ((OpenApiObject.Builder)LocalizedAttributesForLocaleDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(LocalizedAttributesForLocaleDescriptor.THIS.name(objectNameSchemas));
        attributeSchemas.forEach(attributeSchema -> {
            OpenApiProperty attributeProperty = EntityObjectBuilder.buildAttributeProperty(attributeSchema);
            if (attributeSchema.isLocalized()) {
                localizedAttributesForLocaleObjectBuilder.property(attributeProperty);
            } else {
                globalAttributesObjectBuilder.property(attributeProperty);
            }
        });
        OpenApiTypeReference globalAttributesObject = this.buildingContext.registerType(globalAttributesObjectBuilder.build());
        OpenApiTypeReference localizedAttributesForLocaleObject = this.buildingContext.registerType(localizedAttributesForLocaleObjectBuilder.build());
        OpenApiProperty globalAttributesProperty = ((OpenApiProperty.Builder)SectionedAttributesDescriptor.GLOBAL.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(globalAttributesObject)).build();
        attributesObject.property(globalAttributesProperty);
        if (!entitySchema.getLocales().isEmpty()) {
            OpenApiObject.Builder localizedAttributesObjectBuilder = ((OpenApiObject.Builder)LocalizedAttributesDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(LocalizedAttributesDescriptor.THIS.name(objectNameSchemas));
            entitySchema.getLocales().forEach(locale -> localizedAttributesObjectBuilder.property(p -> p.name(locale.toLanguageTag()).type(OpenApiNonNull.nonNull(localizedAttributesForLocaleObject))));
            OpenApiTypeReference localizedAttributesObject = this.buildingContext.registerType(localizedAttributesObjectBuilder.build());
            attributesObject.property(((OpenApiProperty.Builder)SectionedAttributesDescriptor.LOCALIZED.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(localizedAttributesObject)));
        }
        return attributesObject.build();
    }

    @Nonnull
    private static OpenApiProperty buildAttributeProperty(@Nonnull AttributeSchemaContract attributeSchema) {
        OpenApiSimpleType attributeType = DataTypesConverter.getOpenApiScalar(attributeSchema.getType(), !attributeSchema.isNullable());
        return OpenApiProperty.newProperty().name(attributeSchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).description(attributeSchema.getDescription()).deprecationNotice(attributeSchema.getDeprecationNotice()).type(attributeType).build();
    }

    @Nonnull
    private OpenApiProperty buildEntityAssociatedDataProperty(@Nonnull EntitySchemaContract entitySchema, boolean distinguishLocalizedData) {
        OpenApiTypeReference associatedDataObject = this.buildEntityAssociatedDataObject(entitySchema, distinguishLocalizedData);
        return ((OpenApiProperty.Builder)RestEntityDescriptor.ASSOCIATED_DATA.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(associatedDataObject)).build();
    }

    @Nonnull
    private OpenApiTypeReference buildEntityAssociatedDataObject(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        OpenApiObject associatedDataObject = localized ? this.buildLocalizedAssociatedDataObject(entitySchema) : this.buildNonLocalizedAssociatedDataObject(entitySchema);
        return this.buildingContext.registerType(associatedDataObject);
    }

    @Nonnull
    private OpenApiObject buildLocalizedAssociatedDataObject(@Nonnull EntitySchemaContract entitySchema) {
        OpenApiObject.Builder associatedDataObjectBuilder = ((OpenApiObject.Builder)AssociatedDataDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(AssociatedDataDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema}));
        entitySchema.getAssociatedData().values().forEach(associatedSchema -> associatedDataObjectBuilder.property(EntityObjectBuilder.buildSingleAssociatedDataProperty(associatedSchema)));
        return associatedDataObjectBuilder.build();
    }

    @Nonnull
    private OpenApiObject buildNonLocalizedAssociatedDataObject(@Nonnull EntitySchemaContract entitySchema) {
        OpenApiObject.Builder associatedDataObject = ((OpenApiObject.Builder)SectionedAssociatedDataDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(SectionedAssociatedDataDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema}));
        OpenApiObject.Builder globalDataObjectBuilder = ((OpenApiObject.Builder)GlobalAssociatedDataDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(GlobalAssociatedDataDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema}));
        OpenApiObject.Builder localizedDataForLocaleObjectBuilder = ((OpenApiObject.Builder)LocalizedAssociatedDataForLocaleDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(LocalizedAssociatedDataForLocaleDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema}));
        entitySchema.getAssociatedData().values().forEach(associatedSchema -> {
            OpenApiProperty associatedDataProperty = EntityObjectBuilder.buildSingleAssociatedDataProperty(associatedSchema);
            if (associatedSchema.isLocalized()) {
                localizedDataForLocaleObjectBuilder.property(associatedDataProperty);
            } else {
                globalDataObjectBuilder.property(associatedDataProperty);
            }
        });
        OpenApiTypeReference globalDataObject = this.buildingContext.registerType(globalDataObjectBuilder.build());
        OpenApiProperty globalDataProperty = ((OpenApiProperty.Builder)SectionedAssociatedDataDescriptor.GLOBAL.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(globalDataObject)).build();
        associatedDataObject.property(globalDataProperty);
        OpenApiTypeReference localizedDataForLocaleObject = this.buildingContext.registerType(localizedDataForLocaleObjectBuilder.build());
        if (!entitySchema.getLocales().isEmpty()) {
            OpenApiObject.Builder localizedDataObjectBuilder = ((OpenApiObject.Builder)LocalizedAssociatedDataDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(LocalizedAssociatedDataDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema}));
            entitySchema.getLocales().forEach(locale -> localizedDataObjectBuilder.property(p -> p.name(locale.toLanguageTag()).type(OpenApiNonNull.nonNull(localizedDataForLocaleObject))));
            OpenApiTypeReference localizedDataObject = this.buildingContext.registerType(localizedDataObjectBuilder.build());
            associatedDataObject.property(((OpenApiProperty.Builder)SectionedAssociatedDataDescriptor.LOCALIZED.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(localizedDataObject)));
        }
        return associatedDataObject.build();
    }

    @Nonnull
    private static OpenApiProperty buildSingleAssociatedDataProperty(@Nonnull AssociatedDataSchemaContract associatedDataSchema) {
        OpenApiSimpleType associatedDataType = DataTypesConverter.getOpenApiScalar(associatedDataSchema.getType(), !associatedDataSchema.isNullable());
        return OpenApiProperty.newProperty().name(associatedDataSchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).description(associatedDataSchema.getDescription()).deprecationNotice(associatedDataSchema.getDeprecationNotice()).type(associatedDataType).build();
    }

    @Nonnull
    private List<OpenApiProperty> buildEntityReferenceProperties(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        return entitySchema.getReferences().values().stream().map(referenceSchema -> {
            OpenApiTypeReference referenceObject = this.buildReferenceObject(entitySchema, (ReferenceSchemaContract)referenceSchema, localized);
            OpenApiProperty.Builder referencePropertyBuilder = OpenApiProperty.newProperty().name(referenceSchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).description(referenceSchema.getDescription()).deprecationNotice(referenceSchema.getDeprecationNotice());
            if (referenceSchema.getCardinality() == Cardinality.ZERO_OR_MORE || referenceSchema.getCardinality() == Cardinality.ONE_OR_MORE) {
                referencePropertyBuilder.type(referenceSchema.getCardinality() == Cardinality.ONE_OR_MORE ? OpenApiNonNull.nonNull(OpenApiArray.arrayOf(referenceObject)) : OpenApiArray.arrayOf(referenceObject));
            } else {
                referencePropertyBuilder.type(referenceSchema.getCardinality() == Cardinality.EXACTLY_ONE ? OpenApiNonNull.nonNull(referenceObject) : referenceObject);
            }
            return referencePropertyBuilder.build();
        }).toList();
    }

    @Nonnull
    private OpenApiTypeReference buildReferenceObject(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        OpenApiObject.Builder referenceObject = ((OpenApiObject.Builder)ReferenceDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(DataApiNamesConstructor.constructReferenceObjectName(entitySchema, referenceSchema, localized)).description(referenceSchema.getDescription());
        referenceObject.property(this.buildReferenceReferencedEntityObjectProperty(referenceSchema, localized));
        if (referenceSchema.getReferencedGroupType() != null) {
            referenceObject.property(this.buildReferenceGroupEntityProperty(referenceSchema, localized));
        }
        if (!referenceSchema.getAttributes().isEmpty()) {
            referenceObject.property(this.buildReferenceAttributesProperty(entitySchema, referenceSchema, localized));
        }
        return this.buildingContext.registerType(referenceObject.build());
    }

    @Nonnull
    private OpenApiProperty buildReferenceReferencedEntityObjectProperty(@Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        OpenApiTypeReference referencedEntityObject = this.buildReferenceReferencedEntityObject(referenceSchema, localized);
        return ((OpenApiProperty.Builder)ReferenceDescriptor.REFERENCED_ENTITY.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(referencedEntityObject).build();
    }

    @Nonnull
    private OpenApiTypeReference buildReferenceReferencedEntityObject(@Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        OpenApiTypeReference referencedEntityObject;
        if (referenceSchema.isReferencedEntityTypeManaged()) {
            EntitySchemaContract referencedEntitySchema = (EntitySchemaContract)this.buildingContext.getSchema().getEntitySchema(referenceSchema.getReferencedEntityType()).orElseThrow(() -> new OpenApiBuildingError("Could not find entity schema for referenced schema `" + referenceSchema.getReferencedEntityType() + "`."));
            String entityName = DataApiNamesConstructor.constructEntityObjectName(referencedEntitySchema, localized);
            referencedEntityObject = OpenApiTypeReference.typeRefTo(entityName);
        } else {
            referencedEntityObject = OpenApiTypeReference.typeRefTo(RestEntityDescriptor.THIS_REFERENCE.name());
        }
        return referencedEntityObject;
    }

    @Nullable
    private OpenApiProperty buildReferenceGroupEntityProperty(@Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        OpenApiTypeReference groupEntityObject = this.buildReferenceGroupEntityObject(referenceSchema, localized);
        if (groupEntityObject == null) {
            return null;
        }
        return ((OpenApiProperty.Builder)ReferenceDescriptor.GROUP_ENTITY.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(groupEntityObject)).build();
    }

    @Nullable
    private OpenApiTypeReference buildReferenceGroupEntityObject(@Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        OpenApiTypeReference groupEntityObject;
        if (referenceSchema.getReferencedGroupType() == null) {
            return null;
        }
        if (referenceSchema.isReferencedGroupTypeManaged()) {
            EntitySchemaContract referencedGroupSchema = (EntitySchemaContract)this.buildingContext.getSchema().getEntitySchema(referenceSchema.getReferencedGroupType()).orElseThrow(() -> new OpenApiBuildingError("Could not find entity schema for referenced schema `" + referenceSchema.getReferencedGroupType() + "`."));
            String groupType = DataApiNamesConstructor.constructEntityObjectName(referencedGroupSchema, localized);
            groupEntityObject = OpenApiTypeReference.typeRefTo(groupType);
        } else {
            groupEntityObject = OpenApiTypeReference.typeRefTo(RestEntityDescriptor.THIS_REFERENCE.name());
        }
        return groupEntityObject;
    }

    @Nonnull
    private OpenApiProperty buildReferenceAttributesProperty(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        OpenApiTypeReference referenceAttributesObject = this.buildReferenceAttributesObject(entitySchema, referenceSchema, localized);
        return ((OpenApiProperty.Builder)ReferenceDescriptor.ATTRIBUTES.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(referenceAttributesObject)).build();
    }

    @Nonnull
    private OpenApiTypeReference buildReferenceAttributesObject(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        OpenApiObject attributesObject = localized ? this.buildLocalizedAttributesObject(entitySchema.getAttributes().values(), new NamedSchemaContract[]{entitySchema, referenceSchema}) : this.buildNonLocalizedAttributesObject(entitySchema, entitySchema.getAttributes().values(), new NamedSchemaContract[]{entitySchema, referenceSchema});
        return this.buildingContext.registerType(attributesObject);
    }

    public EntityObjectBuilder(@Nonnull CatalogRestBuildingContext buildingContext, @Nonnull PropertyDescriptorToOpenApiPropertyTransformer propertyBuilderTransformer, @Nonnull ObjectDescriptorToOpenApiObjectTransformer objectBuilderTransformer) {
        if (buildingContext == null) {
            throw new NullPointerException("buildingContext is marked non-null but is null");
        }
        if (propertyBuilderTransformer == null) {
            throw new NullPointerException("propertyBuilderTransformer is marked non-null but is null");
        }
        if (objectBuilderTransformer == null) {
            throw new NullPointerException("objectBuilderTransformer is marked non-null but is null");
        }
        this.buildingContext = buildingContext;
        this.propertyBuilderTransformer = propertyBuilderTransformer;
        this.objectBuilderTransformer = objectBuilderTransformer;
    }
}

