/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.builder;

import io.evitadb.api.requestResponse.schema.EntityAttributeSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.NamedSchemaContract;
import io.evitadb.api.requestResponse.schema.ReferenceSchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.api.catalog.dataApi.model.DataChunkDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.EntityDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.RecordPageDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.RecordStripDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.ResponseDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.AttributeHistogramDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.ExtraResultsDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.FacetSummaryDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.HierarchyDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.HistogramDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.QueryTelemetryDescriptor;
import io.evitadb.externalApi.api.model.ObjectDescriptorTransformer;
import io.evitadb.externalApi.api.model.PropertyDescriptorTransformer;
import io.evitadb.externalApi.rest.api.catalog.builder.CatalogRestBuildingContext;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.DataApiNamesConstructor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.dto.DataChunkType;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.DataChunkUnionDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.extraResult.HierarchyOfDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.extraResult.LevelInfoDescriptor;
import io.evitadb.externalApi.rest.api.model.ObjectDescriptorToOpenApiDictionaryTransformer;
import io.evitadb.externalApi.rest.api.model.ObjectDescriptorToOpenApiObjectTransformer;
import io.evitadb.externalApi.rest.api.model.ObjectDescriptorToOpenApiUnionTransformer;
import io.evitadb.externalApi.rest.api.model.PropertyDescriptorToOpenApiPropertyTransformer;
import io.evitadb.externalApi.rest.api.openApi.OpenApiArray;
import io.evitadb.externalApi.rest.api.openApi.OpenApiDictionary;
import io.evitadb.externalApi.rest.api.openApi.OpenApiNonNull;
import io.evitadb.externalApi.rest.api.openApi.OpenApiObject;
import io.evitadb.externalApi.rest.api.openApi.OpenApiObjectUnionType;
import io.evitadb.externalApi.rest.api.openApi.OpenApiProperty;
import io.evitadb.externalApi.rest.api.openApi.OpenApiTypeReference;
import io.evitadb.externalApi.rest.api.openApi.OpenApiUnion;
import io.evitadb.externalApi.rest.exception.OpenApiBuildingError;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FullResponseObjectBuilder {
    @Nonnull
    private final CatalogRestBuildingContext buildingContext;
    @Nonnull
    private final PropertyDescriptorToOpenApiPropertyTransformer propertyBuilderTransformer;
    @Nonnull
    private final ObjectDescriptorToOpenApiObjectTransformer objectBuilderTransformer;
    @Nonnull
    private final ObjectDescriptorToOpenApiUnionTransformer unionBuilderTransformer;
    @Nonnull
    private final ObjectDescriptorToOpenApiDictionaryTransformer dictionaryBuilderTransformer;

    public void buildCommonTypes() {
        this.buildingContext.registerType(((OpenApiObject.Builder)HistogramDescriptor.BucketDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)HistogramDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)QueryTelemetryDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
        this.buildingContext.registerType(((OpenApiObject.Builder)FacetSummaryDescriptor.FacetRequestImpactDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).build());
    }

    @Nonnull
    public OpenApiObject buildFullResponseObject(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        OpenApiObject.Builder responseObjectBuilder = ((OpenApiObject.Builder)ResponseDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(DataApiNamesConstructor.constructEntityFullResponseObjectName(entitySchema, localized)).property(this.buildDataChunkProperty(entitySchema, localized));
        this.buildExtraResultsProperty(entitySchema, localized).ifPresent(responseObjectBuilder::property);
        return responseObjectBuilder.build();
    }

    @Nonnull
    private OpenApiProperty buildDataChunkProperty(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        return ((OpenApiProperty.Builder)ResponseDescriptor.RECORD_PAGE.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(this.buildDataChunkObject(entitySchema, localized))).build();
    }

    @Nonnull
    private OpenApiTypeReference buildDataChunkObject(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        OpenApiUnion dataChunkObject = ((OpenApiUnion.Builder)DataChunkUnionDescriptor.THIS.to((ObjectDescriptorTransformer)this.unionBuilderTransformer)).name(DataApiNamesConstructor.constructEntityDataChunkAggregateObjectName(entitySchema, localized)).type(OpenApiObjectUnionType.ONE_OF).discriminator(DataChunkUnionDescriptor.DISCRIMINATOR.name()).object(this.buildRecordPageObject(entitySchema, localized)).object(this.buildRecordStripObject(entitySchema, localized)).build();
        return this.buildingContext.registerType(dataChunkObject);
    }

    @Nonnull
    private OpenApiTypeReference buildRecordPageObject(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        OpenApiTypeReference entityObject = OpenApiTypeReference.typeRefTo(DataApiNamesConstructor.constructEntityObjectName(entitySchema, localized));
        OpenApiObject recordPageObject = ((OpenApiObject.Builder)RecordPageDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(DataApiNamesConstructor.constructRecordPageObjectName(entitySchema, localized)).property(this.buildDataChunkDataProperty(entityObject)).property(this.createDataChunkDiscriminatorProperty()).build();
        return this.buildingContext.registerType(recordPageObject);
    }

    @Nonnull
    private OpenApiTypeReference buildRecordStripObject(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        OpenApiTypeReference entityObject = OpenApiTypeReference.typeRefTo(DataApiNamesConstructor.constructEntityObjectName(entitySchema, localized));
        OpenApiObject recordStripObject = ((OpenApiObject.Builder)RecordStripDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(DataApiNamesConstructor.constructRecordStripObjectName(entitySchema, localized)).property(this.buildDataChunkDataProperty(entityObject)).property(this.createDataChunkDiscriminatorProperty()).build();
        return this.buildingContext.registerType(recordStripObject);
    }

    @Nonnull
    private OpenApiProperty buildDataChunkDataProperty(@Nonnull OpenApiTypeReference entityObject) {
        return ((OpenApiProperty.Builder)DataChunkDescriptor.DATA.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(OpenApiArray.arrayOf(entityObject))).build();
    }

    @Nonnull
    private OpenApiProperty createDataChunkDiscriminatorProperty() {
        return ((OpenApiProperty.Builder)DataChunkUnionDescriptor.DISCRIMINATOR.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(OpenApiTypeReference.typeRefTo(DataChunkType.class.getSimpleName()))).build();
    }

    @Nonnull
    private Optional<OpenApiProperty> buildExtraResultsProperty(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        Optional<OpenApiTypeReference> extraResultsObject = this.buildExtraResultsObject(entitySchema, localized);
        if (extraResultsObject.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((OpenApiProperty.Builder)ResponseDescriptor.EXTRA_RESULTS.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(extraResultsObject.get())).build());
    }

    @Nonnull
    private Optional<OpenApiTypeReference> buildExtraResultsObject(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        OpenApiObject.Builder extraResultObjectBuilder = ((OpenApiObject.Builder)ExtraResultsDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(DataApiNamesConstructor.constructExtraResultsObjectName(entitySchema, localized));
        ArrayList<OpenApiProperty> extraResultProperties = new ArrayList<OpenApiProperty>(10);
        this.buildAttributeHistogramProperty(entitySchema).ifPresent(extraResultProperties::add);
        this.buildPriceHistogramProperty(entitySchema).ifPresent(extraResultProperties::add);
        this.buildFacetSummaryProperty(entitySchema, localized).ifPresent(extraResultProperties::add);
        this.buildHierarchyProperty(entitySchema, localized).ifPresent(extraResultProperties::add);
        extraResultProperties.add(((OpenApiProperty.Builder)ExtraResultsDescriptor.QUERY_TELEMETRY.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).build());
        if (extraResultProperties.isEmpty()) {
            return Optional.empty();
        }
        extraResultProperties.forEach(extraResultObjectBuilder::property);
        return Optional.of(this.buildingContext.registerType(extraResultObjectBuilder.build()));
    }

    @Nonnull
    private Optional<OpenApiProperty> buildAttributeHistogramProperty(@Nonnull EntitySchemaContract entitySchema) {
        Optional<OpenApiTypeReference> attributeHistogramObject = this.buildAttributeHistogramObject(entitySchema);
        if (attributeHistogramObject.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((OpenApiProperty.Builder)ExtraResultsDescriptor.ATTRIBUTE_HISTOGRAM.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(attributeHistogramObject.get()).build());
    }

    @Nonnull
    private Optional<OpenApiTypeReference> buildAttributeHistogramObject(@Nonnull EntitySchemaContract entitySchema) {
        String objectName = AttributeHistogramDescriptor.THIS.name(new NamedSchemaContract[]{entitySchema});
        Optional<OpenApiTypeReference> existingAttributeHistogramObject = this.buildingContext.getRegisteredType(objectName);
        if (existingAttributeHistogramObject.isPresent()) {
            return existingAttributeHistogramObject;
        }
        List<EntityAttributeSchemaContract> attributeSchemas = entitySchema.getAttributes().values().stream().filter(attributeSchema -> attributeSchema.isFilterable() && Number.class.isAssignableFrom(attributeSchema.getPlainType())).toList();
        if (attributeSchemas.isEmpty()) {
            return Optional.empty();
        }
        OpenApiObject.Builder attributeHistogramObjectBuilder = ((OpenApiObject.Builder)AttributeHistogramDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(objectName);
        attributeSchemas.forEach(attributeSchema -> attributeHistogramObjectBuilder.property(p -> p.name(attributeSchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).type(OpenApiTypeReference.typeRefTo(HistogramDescriptor.THIS.name()))));
        return Optional.of(this.buildingContext.registerType(attributeHistogramObjectBuilder.build()));
    }

    @Nonnull
    private Optional<OpenApiProperty> buildPriceHistogramProperty(@Nonnull EntitySchemaContract entitySchema) {
        if (entitySchema.getCurrencies().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((OpenApiProperty.Builder)ExtraResultsDescriptor.PRICE_HISTOGRAM.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).build());
    }

    @Nonnull
    private Optional<OpenApiProperty> buildFacetSummaryProperty(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        Optional<OpenApiTypeReference> facetSummaryObject = this.buildFacetSummaryObject(entitySchema, localized);
        if (facetSummaryObject.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(((OpenApiProperty.Builder)ExtraResultsDescriptor.FACET_SUMMARY.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(facetSummaryObject.get()).build());
    }

    @Nonnull
    private Optional<OpenApiTypeReference> buildFacetSummaryObject(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        List<ReferenceSchemaContract> referenceSchemas = entitySchema.getReferences().values().stream().filter(ReferenceSchemaContract::isFaceted).toList();
        if (referenceSchemas.isEmpty()) {
            return Optional.empty();
        }
        OpenApiObject.Builder facetSummaryObjectBuilder = ((OpenApiObject.Builder)FacetSummaryDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(DataApiNamesConstructor.constructFacetSummaryObjectName(entitySchema, localized));
        referenceSchemas.forEach(referenceSchema -> facetSummaryObjectBuilder.property(this.buildFacetGroupStatisticsProperty(entitySchema, (ReferenceSchemaContract)referenceSchema, localized)));
        return Optional.of(this.buildingContext.registerType(facetSummaryObjectBuilder.build()));
    }

    @Nonnull
    private OpenApiProperty buildFacetGroupStatisticsProperty(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        OpenApiTypeReference facetGroupStatisticsObject = this.buildFacetGroupStatisticsObject(entitySchema, referenceSchema, localized);
        boolean isGrouped = referenceSchema.getReferencedGroupType() != null;
        OpenApiProperty.Builder facetGroupStatisticsFieldBuilder = OpenApiProperty.newProperty().name(referenceSchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION));
        if (isGrouped) {
            facetGroupStatisticsFieldBuilder.type(OpenApiArray.arrayOf(facetGroupStatisticsObject));
        } else {
            facetGroupStatisticsFieldBuilder.type(facetGroupStatisticsObject);
        }
        return facetGroupStatisticsFieldBuilder.build();
    }

    @Nonnull
    private OpenApiTypeReference buildFacetGroupStatisticsObject(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        EntitySchemaContract groupEntitySchema = referenceSchema.isReferencedGroupTypeManaged() ? (EntitySchemaContract)Optional.ofNullable(referenceSchema.getReferencedGroupType()).flatMap(groupType -> this.buildingContext.getSchema().getEntitySchema(groupType)).orElse(null) : null;
        OpenApiTypeReference groupEntityObject = this.buildReferencedEntityObject(groupEntitySchema, localized);
        OpenApiTypeReference facetStatisticsObject = this.buildFacetStatisticsObject(entitySchema, referenceSchema, localized);
        OpenApiObject.Builder facetGroupStatisticsObjectBuilder = ((OpenApiObject.Builder)FacetSummaryDescriptor.FacetGroupStatisticsDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(DataApiNamesConstructor.constructFacetGroupStatisticsObjectName(entitySchema, referenceSchema, localized));
        if (referenceSchema.getReferencedGroupType() != null) {
            facetGroupStatisticsObjectBuilder.property(((OpenApiProperty.Builder)FacetSummaryDescriptor.FacetGroupStatisticsDescriptor.GROUP_ENTITY.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(groupEntityObject));
        }
        facetGroupStatisticsObjectBuilder.property(((OpenApiProperty.Builder)FacetSummaryDescriptor.FacetGroupStatisticsDescriptor.FACET_STATISTICS.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(OpenApiArray.arrayOf(facetStatisticsObject))));
        return this.buildingContext.registerType(facetGroupStatisticsObjectBuilder.build());
    }

    @Nonnull
    private OpenApiTypeReference buildFacetStatisticsObject(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        EntitySchemaContract facetEntitySchema = referenceSchema.isReferencedEntityTypeManaged() ? this.buildingContext.getSchema().getEntitySchemaOrThrowException(referenceSchema.getReferencedEntityType()) : null;
        OpenApiTypeReference facetEntityObject = this.buildReferencedEntityObject(facetEntitySchema, localized);
        OpenApiObject facetStatisticsObject = ((OpenApiObject.Builder)FacetSummaryDescriptor.FacetStatisticsDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(DataApiNamesConstructor.constructFacetStatisticsObjectName(entitySchema, referenceSchema, localized)).property(((OpenApiProperty.Builder)FacetSummaryDescriptor.FacetStatisticsDescriptor.FACET_ENTITY.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(facetEntityObject)).build();
        return this.buildingContext.registerType(facetStatisticsObject);
    }

    @Nonnull
    private OpenApiTypeReference buildReferencedEntityObject(@Nullable EntitySchemaContract referencedEntitySchema, boolean localized) {
        if (referencedEntitySchema != null) {
            return OpenApiTypeReference.typeRefTo(DataApiNamesConstructor.constructEntityObjectName(referencedEntitySchema, localized));
        }
        return OpenApiTypeReference.typeRefTo(EntityDescriptor.THIS_REFERENCE.name());
    }

    @Nonnull
    private Optional<OpenApiProperty> buildHierarchyProperty(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        List<ReferenceSchemaContract> referenceSchemas = entitySchema.getReferences().values().stream().filter(referenceSchema -> referenceSchema.isReferencedEntityTypeManaged() && this.buildingContext.getSchema().getEntitySchema(referenceSchema.getReferencedEntityType()).map(EntitySchemaContract::isWithHierarchy).orElseThrow(() -> new OpenApiBuildingError("Reference `" + referenceSchema.getName() + "` should have existing entity schema but no schema found.")) != false).toList();
        if (referenceSchemas.isEmpty() && !entitySchema.isWithHierarchy()) {
            return Optional.empty();
        }
        OpenApiTypeReference hierarchyObject = this.buildHierarchyObject(entitySchema, referenceSchemas, localized);
        return Optional.of(((OpenApiProperty.Builder)ExtraResultsDescriptor.HIERARCHY.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(hierarchyObject).build());
    }

    @Nonnull
    private OpenApiTypeReference buildHierarchyObject(@Nonnull EntitySchemaContract entitySchema, @Nonnull List<ReferenceSchemaContract> referenceSchemas, boolean localized) {
        OpenApiObject.Builder hierarchyStatisticsObjectBuilder = ((OpenApiObject.Builder)HierarchyDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(DataApiNamesConstructor.constructHierarchyObjectName(entitySchema, localized));
        if (entitySchema.isWithHierarchy()) {
            hierarchyStatisticsObjectBuilder.property(this.buildHierarchyOfSelfProperty(entitySchema, localized));
        }
        referenceSchemas.forEach(referenceSchema -> hierarchyStatisticsObjectBuilder.property(this.buildHierarchyOfReferenceProperty(entitySchema, (ReferenceSchemaContract)referenceSchema, localized)));
        return this.buildingContext.registerType(hierarchyStatisticsObjectBuilder.build());
    }

    @Nonnull
    private OpenApiProperty buildHierarchyOfSelfProperty(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        OpenApiTypeReference hierarchyOfSelfObject = this.buildHierarchyOfSelfObject(entitySchema, localized);
        return ((OpenApiProperty.Builder)HierarchyDescriptor.SELF.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(hierarchyOfSelfObject)).build();
    }

    @Nonnull
    private OpenApiTypeReference buildHierarchyOfSelfObject(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        OpenApiTypeReference selfLevelInfoObject = this.buildSelfLevelInfoObject(entitySchema, localized);
        OpenApiDictionary hierarchyOfSelfObject = ((OpenApiDictionary.Builder)HierarchyOfDescriptor.THIS.to((ObjectDescriptorTransformer)this.dictionaryBuilderTransformer)).name(DataApiNamesConstructor.constructHierarchyOfSelfObjectName(entitySchema, localized)).valueType(OpenApiArray.arrayOf(selfLevelInfoObject)).build();
        return this.buildingContext.registerType(hierarchyOfSelfObject);
    }

    @Nonnull
    private OpenApiTypeReference buildSelfLevelInfoObject(@Nonnull EntitySchemaContract entitySchema, boolean localized) {
        String objectName = DataApiNamesConstructor.constructSelfLevelInfoObjectName(entitySchema, localized);
        OpenApiObject selfLevelInfoObject = ((OpenApiObject.Builder)LevelInfoDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(objectName).property(((OpenApiProperty.Builder)LevelInfoDescriptor.ENTITY.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(OpenApiTypeReference.typeRefTo(DataApiNamesConstructor.constructEntityObjectName(entitySchema, localized))))).property(((OpenApiProperty.Builder)LevelInfoDescriptor.CHILDREN.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(OpenApiArray.arrayOf(OpenApiTypeReference.typeRefTo(objectName))))).build();
        return this.buildingContext.registerType(selfLevelInfoObject);
    }

    @Nonnull
    private OpenApiProperty buildHierarchyOfReferenceProperty(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        OpenApiTypeReference hierarchyOfSelfObject = this.buildHierarchyOfReferenceObject(entitySchema, referenceSchema, localized);
        return ((OpenApiProperty.Builder)HierarchyDescriptor.REFERENCE.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).name(referenceSchema.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).description(HierarchyDescriptor.REFERENCE.description(new Object[]{referenceSchema.getReferencedEntityType()})).type(OpenApiNonNull.nonNull(hierarchyOfSelfObject)).build();
    }

    @Nonnull
    private OpenApiTypeReference buildHierarchyOfReferenceObject(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        OpenApiTypeReference levelInfoObject = this.buildLevelInfoObject(entitySchema, referenceSchema, localized);
        OpenApiDictionary hierarchyOfReferenceObject = ((OpenApiDictionary.Builder)HierarchyOfDescriptor.THIS.to((ObjectDescriptorTransformer)this.dictionaryBuilderTransformer)).name(DataApiNamesConstructor.constructHierarchyOfReferenceObjectName(entitySchema, referenceSchema, localized)).valueType(OpenApiArray.arrayOf(levelInfoObject)).build();
        return this.buildingContext.registerType(hierarchyOfReferenceObject);
    }

    @Nonnull
    private OpenApiTypeReference buildLevelInfoObject(@Nonnull EntitySchemaContract entitySchema, @Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        String levelInfoObjectName = DataApiNamesConstructor.constructLevelInfoObjectName(entitySchema, referenceSchema, localized);
        OpenApiObject levelInfoObject = ((OpenApiObject.Builder)LevelInfoDescriptor.THIS.to((ObjectDescriptorTransformer)this.objectBuilderTransformer)).name(levelInfoObjectName).property(this.buildLevelInfoEntityProperty(referenceSchema, localized)).property(((OpenApiProperty.Builder)LevelInfoDescriptor.CHILDREN.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(OpenApiArray.arrayOf(OpenApiTypeReference.typeRefTo(levelInfoObjectName))))).build();
        return this.buildingContext.registerType(levelInfoObject);
    }

    @Nonnull
    private OpenApiProperty buildLevelInfoEntityProperty(@Nonnull ReferenceSchemaContract referenceSchema, boolean localized) {
        EntitySchemaContract referencedEntitySchema = this.buildingContext.getSchema().getEntitySchemaOrThrowException(referenceSchema.getReferencedEntityType());
        String referencedEntityObjectName = DataApiNamesConstructor.constructEntityObjectName(referencedEntitySchema, localized);
        return ((OpenApiProperty.Builder)LevelInfoDescriptor.ENTITY.to((PropertyDescriptorTransformer)this.propertyBuilderTransformer)).type(OpenApiNonNull.nonNull(OpenApiTypeReference.typeRefTo(referencedEntityObjectName))).build();
    }

    public FullResponseObjectBuilder(@Nonnull CatalogRestBuildingContext buildingContext, @Nonnull PropertyDescriptorToOpenApiPropertyTransformer propertyBuilderTransformer, @Nonnull ObjectDescriptorToOpenApiObjectTransformer objectBuilderTransformer, @Nonnull ObjectDescriptorToOpenApiUnionTransformer unionBuilderTransformer, @Nonnull ObjectDescriptorToOpenApiDictionaryTransformer dictionaryBuilderTransformer) {
        if (buildingContext == null) {
            throw new NullPointerException("buildingContext is marked non-null but is null");
        }
        if (propertyBuilderTransformer == null) {
            throw new NullPointerException("propertyBuilderTransformer is marked non-null but is null");
        }
        if (objectBuilderTransformer == null) {
            throw new NullPointerException("objectBuilderTransformer is marked non-null but is null");
        }
        if (unionBuilderTransformer == null) {
            throw new NullPointerException("unionBuilderTransformer is marked non-null but is null");
        }
        if (dictionaryBuilderTransformer == null) {
            throw new NullPointerException("dictionaryBuilderTransformer is marked non-null but is null");
        }
        this.buildingContext = buildingContext;
        this.propertyBuilderTransformer = propertyBuilderTransformer;
        this.objectBuilderTransformer = objectBuilderTransformer;
        this.unionBuilderTransformer = unionBuilderTransformer;
        this.dictionaryBuilderTransformer = dictionaryBuilderTransformer;
    }
}

