/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.builder.constraint;

import io.evitadb.api.query.Constraint;
import io.evitadb.api.query.descriptor.ConstraintDescriptor;
import io.evitadb.api.query.descriptor.ConstraintDescriptorProvider;
import io.evitadb.api.query.descriptor.ConstraintType;
import io.evitadb.api.query.filter.EntityLocaleEquals;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.query.filter.FilterGroupBy;
import io.evitadb.api.requestResponse.schema.AttributeSchemaContract;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.DataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.EntityDataLocator;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.constraint.OpenApiConstraintSchemaBuilder;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.constraint.OpenApiConstraintSchemaBuildingContext;
import io.evitadb.externalApi.rest.api.openApi.OpenApiSimpleType;
import io.evitadb.utils.CollectionUtils;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class FilterConstraintSchemaBuilder
extends OpenApiConstraintSchemaBuilder {
    private static final Set<Class<? extends Constraint<?>>> FORBIDDEN_CONSTRAINTS = Set.of(FilterBy.class, FilterGroupBy.class);
    private static final Set<Class<? extends Constraint<?>>> FORBIDDEN_CONSTRAINTS_WITH_LOCALE = Set.of(FilterBy.class, FilterGroupBy.class, EntityLocaleEquals.class);

    public FilterConstraintSchemaBuilder(@Nonnull OpenApiConstraintSchemaBuildingContext constraintSchemaBuildingCtx, boolean forbidLocaleInQuery) {
        super(constraintSchemaBuildingCtx, CollectionUtils.createHashMap((int)0), Set.of(), forbidLocaleInQuery ? FORBIDDEN_CONSTRAINTS_WITH_LOCALE : FORBIDDEN_CONSTRAINTS);
    }

    @Nonnull
    public OpenApiSimpleType build(@Nonnull String rootEntityType) {
        return (OpenApiSimpleType)this.build((DataLocator)new EntityDataLocator(rootEntityType));
    }

    @Nonnull
    protected ConstraintType getConstraintType() {
        return ConstraintType.FILTER;
    }

    @Nonnull
    protected ConstraintDescriptor getDefaultRootConstraintContainerDescriptor() {
        return ConstraintDescriptorProvider.getConstraint(FilterBy.class);
    }

    @Nonnull
    protected String getContainerObjectTypeName() {
        return "FilterContainer";
    }

    @Nonnull
    protected Predicate<AttributeSchemaContract> getAttributeSchemaFilter() {
        return attributeSchema -> attributeSchema.isUnique() || attributeSchema.isFilterable();
    }
}

