/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.builder.constraint;

import io.evitadb.api.query.Constraint;
import io.evitadb.api.query.descriptor.ConstraintCreator;
import io.evitadb.api.query.descriptor.ConstraintDescriptor;
import io.evitadb.api.query.descriptor.ConstraintDescriptorProvider;
import io.evitadb.api.query.descriptor.ConstraintPropertyType;
import io.evitadb.api.query.descriptor.ConstraintType;
import io.evitadb.externalApi.api.catalog.dataApi.builder.constraint.AllowedConstraintPredicate;
import io.evitadb.externalApi.api.catalog.dataApi.builder.constraint.ConstraintBuildContext;
import io.evitadb.externalApi.api.catalog.dataApi.builder.constraint.ConstraintSchemaBuilder;
import io.evitadb.externalApi.api.catalog.dataApi.builder.constraint.ConstraintSchemaBuildingContext;
import io.evitadb.externalApi.api.catalog.dataApi.builder.constraint.ContainerKey;
import io.evitadb.externalApi.api.catalog.dataApi.builder.constraint.WrapperObjectKey;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.ConstraintProcessingUtils;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.ConstraintTraverseContext;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.DataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.model.CatalogDataApiRootDescriptor;
import io.evitadb.externalApi.exception.ExternalApiInternalError;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.constraint.OpenApiConstraintSchemaBuildingContext;
import io.evitadb.externalApi.rest.api.dataType.DataTypesConverter;
import io.evitadb.externalApi.rest.api.openApi.OpenApiArray;
import io.evitadb.externalApi.rest.api.openApi.OpenApiNonNull;
import io.evitadb.externalApi.rest.api.openApi.OpenApiObject;
import io.evitadb.externalApi.rest.api.openApi.OpenApiProperty;
import io.evitadb.externalApi.rest.api.openApi.OpenApiScalar;
import io.evitadb.externalApi.rest.api.openApi.OpenApiSimpleType;
import io.evitadb.externalApi.rest.api.openApi.OpenApiTypeReference;
import io.evitadb.externalApi.rest.exception.OpenApiBuildingError;
import io.evitadb.utils.Assert;
import io.evitadb.utils.ClassUtils;
import io.evitadb.utils.CollectionUtils;
import java.util.Collection;
import java.util.Currency;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class OpenApiConstraintSchemaBuilder
extends ConstraintSchemaBuilder<OpenApiConstraintSchemaBuildingContext, OpenApiSimpleType, OpenApiObject, OpenApiProperty> {
    protected OpenApiConstraintSchemaBuilder(@Nonnull OpenApiConstraintSchemaBuildingContext sharedContext, @Nonnull Map<ConstraintType, AtomicReference<? extends ConstraintSchemaBuilder<OpenApiConstraintSchemaBuildingContext, OpenApiSimpleType, OpenApiObject, OpenApiProperty>>> additionalBuilders, @Nonnull Set<Class<? extends Constraint<?>>> allowedConstraints, @Nonnull Set<Class<? extends Constraint<?>>> forbiddenConstraints) {
        super((ConstraintSchemaBuildingContext)sharedContext, additionalBuilders, allowedConstraints, forbiddenConstraints);
    }

    @Nonnull
    protected OpenApiSimpleType buildContainer(@Nonnull ConstraintBuildContext buildContext, @Nonnull ContainerKey containerKey, @Nonnull AllowedConstraintPredicate allowedChildrenPredicate) {
        String containerName = this.constructContainerName(containerKey);
        OpenApiObject.Builder containerBuilder = OpenApiObject.newObject().name(containerName);
        OpenApiTypeReference containerPointer = OpenApiTypeReference.typeRefTo(containerName);
        ((OpenApiConstraintSchemaBuildingContext)this.sharedContext).cacheContainer(containerKey, containerPointer);
        LinkedList children = new LinkedList();
        children.addAll(this.buildGenericChildren(buildContext, allowedChildrenPredicate));
        children.addAll(this.buildEntityChildren(buildContext, allowedChildrenPredicate));
        children.addAll(this.buildAttributeChildren(buildContext, allowedChildrenPredicate));
        children.addAll(this.buildAssociatedDataChildren(buildContext, allowedChildrenPredicate));
        children.addAll(this.buildPriceChildren(buildContext, allowedChildrenPredicate));
        Collection referenceSchemas = this.findReferenceSchemas(buildContext.dataLocator());
        children.addAll(this.buildReferenceChildren(buildContext, allowedChildrenPredicate, referenceSchemas));
        children.addAll(this.buildHierarchyChildren(buildContext, allowedChildrenPredicate, referenceSchemas));
        children.addAll(this.buildFacetChildren(buildContext, allowedChildrenPredicate, referenceSchemas));
        if (children.isEmpty()) {
            ((OpenApiConstraintSchemaBuildingContext)this.sharedContext).removeCachedContainer(containerKey);
            return this.buildNoneConstraintValue();
        }
        children.forEach(property -> {
            Assert.isPremiseValid((!containerBuilder.hasProperty(property.getName()) ? 1 : 0) != 0, () -> this.createSchemaBuildingError("There is already defined property `" + property.getName() + "` with container name `" + containerName + "`."));
            containerBuilder.property((OpenApiProperty)property);
        });
        ((OpenApiConstraintSchemaBuildingContext)this.sharedContext).addNewType(containerBuilder.build());
        return containerPointer;
    }

    @Nullable
    protected OpenApiProperty buildFieldFromConstraintDescriptor(@Nonnull ConstraintDescriptor constraintDescriptor, @Nonnull String constraintKey, @Nonnull OpenApiSimpleType constraintValue) {
        return OpenApiProperty.newProperty().name(constraintKey).description(this.constructConstraintDescription(constraintDescriptor)).type(constraintValue).build();
    }

    @Nonnull
    protected OpenApiSimpleType buildNoneConstraintValue() {
        return DataTypesConverter.getOpenApiScalar(Boolean.class);
    }

    @Nonnull
    protected OpenApiSimpleType buildPrimitiveConstraintValue(@Nonnull ConstraintBuildContext buildContext, @Nonnull ConstraintCreator.ValueParameterDescriptor valueParameter, boolean canBeRequired, @Nullable ConstraintSchemaBuilder.ValueTypeSupplier valueTypeSupplier) {
        Class valueParameterType = valueParameter.type();
        if (this.isJavaTypeGeneric(valueParameterType)) {
            Assert.isPremiseValid((valueTypeSupplier != null ? 1 : 0) != 0, () -> this.createSchemaBuildingError("Value parameter `" + valueParameter.name() + "` has generic type but no value type supplier is present."));
            Class suppliedValueType = (Class)valueTypeSupplier.apply((Object)valueParameter);
            Assert.isPremiseValid((suppliedValueType != null ? 1 : 0) != 0, () -> this.createSchemaBuildingError("Expected value type supplier to supply type not null."));
            return this.resolveOpenApiType(valueParameterType, suppliedValueType, canBeRequired && valueParameter.required());
        }
        if (Locale.class.equals((Object)valueParameterType) || Locale.class.equals(valueParameterType.getComponentType())) {
            return DataTypesConverter.wrapOpenApiComponentType(OpenApiTypeReference.typeRefTo(CatalogDataApiRootDescriptor.LOCALE_ENUM.name()), valueParameterType, canBeRequired && valueParameter.required());
        }
        if (Currency.class.equals((Object)valueParameterType) || Currency.class.equals(valueParameterType.getComponentType())) {
            return DataTypesConverter.wrapOpenApiComponentType(OpenApiTypeReference.typeRefTo(CatalogDataApiRootDescriptor.CURRENCY_ENUM.name()), valueParameterType, canBeRequired && valueParameter.required());
        }
        return this.resolveOpenApiType(valueParameterType, canBeRequired && valueParameter.required());
    }

    @Nonnull
    protected OpenApiSimpleType buildWrapperRangeConstraintValue(@Nonnull ConstraintBuildContext buildContext, @Nonnull List<ConstraintCreator.ValueParameterDescriptor> valueParameters, @Nullable ConstraintSchemaBuilder.ValueTypeSupplier valueTypeSupplier) {
        OpenApiSimpleType itemType = this.buildPrimitiveConstraintValue(buildContext, valueParameters.get(0), false, valueTypeSupplier);
        return OpenApiArray.arrayOf(itemType, 2, 2);
    }

    @Nonnull
    protected Map<String, OpenApiSimpleType> buildChildConstraintValue(@Nonnull ConstraintBuildContext buildContext, @Nonnull ConstraintCreator.ChildParameterDescriptor childParameter) {
        Optional childDataLocator = this.resolveChildDataLocator(buildContext, childParameter.domain());
        if (childDataLocator.isEmpty()) {
            return Map.of();
        }
        ConstraintBuildContext childBuildContext = buildContext.switchToChildContext((DataLocator)childDataLocator.get());
        LinkedHashMap childTypes = CollectionUtils.createLinkedHashMap((int)1);
        Class childParameterType = childParameter.type();
        if (!childParameterType.isArray() && !ClassUtils.isAbstract((Class)childParameterType)) {
            ConstraintDescriptorProvider.getConstraints((Class)childParameterType).forEach(childConstraintDescriptor -> {
                String key = this.keyBuilder.build((ConstraintTraverseContext)buildContext, childConstraintDescriptor, null);
                Optional childConstraintDataLocator = this.resolveChildDataLocator(buildContext, ConstraintProcessingUtils.getDomainForPropertyType((ConstraintPropertyType)childConstraintDescriptor.propertyType()));
                if (childConstraintDataLocator.isEmpty()) {
                    return;
                }
                childTypes.put(key, (OpenApiSimpleType)this.build(childBuildContext.switchToChildContext((DataLocator)childConstraintDataLocator.get()), (ConstraintDescriptor)childConstraintDescriptor));
            });
        } else {
            OpenApiSimpleType childType = (OpenApiSimpleType)this.obtainContainer(childBuildContext, childParameter);
            if (childType instanceof OpenApiScalar) {
                childTypes.put("_", childType);
            } else if (childParameterType.isArray() && !childParameter.uniqueChildren()) {
                childTypes.put("_", OpenApiArray.arrayOf(childType));
            } else {
                childTypes.put("_", childType);
            }
        }
        return childTypes;
    }

    @Nonnull
    protected OpenApiSimpleType buildWrapperObjectConstraintValue(@Nonnull ConstraintBuildContext buildContext, @Nonnull WrapperObjectKey wrapperObjectKey, @Nonnull List<ConstraintCreator.ValueParameterDescriptor> valueParameters, @Nullable List<ConstraintCreator.ChildParameterDescriptor> childParameters, @Nonnull List<ConstraintCreator.AdditionalChildParameterDescriptor> additionalChildParameters, @Nullable ConstraintSchemaBuilder.ValueTypeSupplier valueTypeSupplier) {
        String wrapperObjectName = this.constructWrapperObjectName(wrapperObjectKey);
        OpenApiObject.Builder wrapperObjectBuilder = OpenApiObject.newObject().name(wrapperObjectName);
        OpenApiTypeReference wrapperObjectPointer = OpenApiTypeReference.typeRefTo(wrapperObjectName);
        ((OpenApiConstraintSchemaBuildingContext)this.sharedContext).cacheWrapperObject(wrapperObjectKey, wrapperObjectPointer);
        valueParameters.forEach(valueParameter -> {
            OpenApiSimpleType nestedPrimitiveConstraintValue = this.buildPrimitiveConstraintValue(buildContext, (ConstraintCreator.ValueParameterDescriptor)valueParameter, !valueParameter.type().isArray(), valueTypeSupplier);
            wrapperObjectBuilder.property(p -> p.name(valueParameter.name()).type(nestedPrimitiveConstraintValue));
        });
        childParameters.forEach(childParameter -> {
            Map<String, OpenApiSimpleType> nestedChildConstraints = this.buildChildConstraintValue(buildContext, (ConstraintCreator.ChildParameterDescriptor)childParameter);
            if (nestedChildConstraints.isEmpty()) {
                return;
            }
            if (nestedChildConstraints.size() == 1) {
                OpenApiSimpleType nestedChildConstraintValue = nestedChildConstraints.values().iterator().next();
                if (childParameter.required() && !childParameter.type().isArray()) {
                    nestedChildConstraintValue = OpenApiNonNull.nonNull(nestedChildConstraintValue);
                }
                wrapperObjectBuilder.property(OpenApiProperty.newProperty().name(childParameter.name()).type(nestedChildConstraintValue));
            } else {
                nestedChildConstraints.entrySet().forEach(nestedChildConstraint -> {
                    String key = (String)nestedChildConstraint.getKey();
                    Assert.isPremiseValid((!key.equals("_") ? 1 : 0) != 0, () -> this.createSchemaBuildingError("Multiple nested child constraint variants but missing proper key."));
                    if (childParameter.required() && !childParameter.type().isArray()) {
                        nestedChildConstraint.setValue(OpenApiNonNull.nonNull((OpenApiSimpleType)nestedChildConstraint.getValue()));
                    }
                    wrapperObjectBuilder.property(OpenApiProperty.newProperty().name(key).type((OpenApiSimpleType)nestedChildConstraint.getValue()));
                });
            }
        });
        additionalChildParameters.forEach(additionalChildParameter -> this.buildAdditionalChildConstraintValue(buildContext, (ConstraintCreator.AdditionalChildParameterDescriptor)additionalChildParameter).ifPresent(nestedAdditionalChildConstraintValue -> {
            if (additionalChildParameter.required() && !additionalChildParameter.type().isArray()) {
                nestedAdditionalChildConstraintValue = OpenApiNonNull.nonNull(nestedAdditionalChildConstraintValue);
            }
            wrapperObjectBuilder.property(OpenApiProperty.newProperty().name(additionalChildParameter.name()).type((OpenApiSimpleType)nestedAdditionalChildConstraintValue));
        }));
        ((OpenApiConstraintSchemaBuildingContext)this.sharedContext).addNewType(wrapperObjectBuilder.build());
        return wrapperObjectPointer;
    }

    @Nonnull
    private OpenApiSimpleType resolveOpenApiType(@Nonnull Class<?> valueType, boolean nonNull) {
        if (this.isJavaTypeEnum(valueType)) {
            DataTypesConverter.ConvertedEnum convertedEnum = DataTypesConverter.getOpenApiEnum(valueType, nonNull);
            ((OpenApiConstraintSchemaBuildingContext)this.sharedContext).getCatalogCtx().registerCustomEnumIfAbsent(convertedEnum.enumType());
            return convertedEnum.resultType();
        }
        return DataTypesConverter.getOpenApiScalar(valueType, nonNull);
    }

    @Nonnull
    private OpenApiSimpleType resolveOpenApiType(@Nonnull Class<?> valueType, @Nonnull Class<?> replacementComponentType, boolean nonNull) {
        if (this.isJavaTypeEnum(replacementComponentType)) {
            DataTypesConverter.ConvertedEnum convertedEnum = DataTypesConverter.getOpenApiEnum(valueType, replacementComponentType, nonNull);
            ((OpenApiConstraintSchemaBuildingContext)this.sharedContext).getCatalogCtx().registerCustomEnumIfAbsent(convertedEnum.enumType());
            return convertedEnum.resultType();
        }
        return DataTypesConverter.getOpenApiScalar(valueType, replacementComponentType, nonNull);
    }

    protected <T extends ExternalApiInternalError> T createSchemaBuildingError(@Nonnull String message) {
        return (T)((Object)new OpenApiBuildingError(message));
    }
}

