/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.builder.constraint;

import io.evitadb.api.query.Constraint;
import io.evitadb.api.query.descriptor.ConstraintDescriptor;
import io.evitadb.api.query.descriptor.ConstraintDescriptorProvider;
import io.evitadb.api.query.descriptor.ConstraintType;
import io.evitadb.api.query.require.AssociatedDataContent;
import io.evitadb.api.query.require.AttributeContent;
import io.evitadb.api.query.require.DataInLocales;
import io.evitadb.api.query.require.EntityFetch;
import io.evitadb.api.query.require.FacetGroupsConjunction;
import io.evitadb.api.query.require.FacetGroupsDisjunction;
import io.evitadb.api.query.require.FacetGroupsNegation;
import io.evitadb.api.query.require.HierarchyContent;
import io.evitadb.api.query.require.HierarchyDistance;
import io.evitadb.api.query.require.HierarchyLevel;
import io.evitadb.api.query.require.HierarchyNode;
import io.evitadb.api.query.require.Page;
import io.evitadb.api.query.require.PriceContent;
import io.evitadb.api.query.require.PriceType;
import io.evitadb.api.query.require.ReferenceContent;
import io.evitadb.api.query.require.Require;
import io.evitadb.api.query.require.Strip;
import io.evitadb.api.requestResponse.schema.AttributeSchemaContract;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.DataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.GenericDataLocator;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.constraint.FilterConstraintSchemaBuilder;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.constraint.OpenApiConstraintSchemaBuilder;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.constraint.OpenApiConstraintSchemaBuildingContext;
import io.evitadb.externalApi.rest.api.catalog.dataApi.builder.constraint.OrderConstraintSchemaBuilder;
import io.evitadb.externalApi.rest.api.openApi.OpenApiSimpleType;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class RequireConstraintSchemaBuilder
extends OpenApiConstraintSchemaBuilder {
    public static final Set<Class<? extends Constraint<?>>> ALLOWED_CONSTRAINTS_FOR_LIST = Set.of(EntityFetch.class, AssociatedDataContent.class, AttributeContent.class, DataInLocales.class, PriceContent.class, ReferenceContent.class, HierarchyContent.class, HierarchyDistance.class, HierarchyLevel.class, HierarchyNode.class, FacetGroupsConjunction.class, FacetGroupsDisjunction.class, FacetGroupsNegation.class, Page.class, PriceType.class, Strip.class);
    public static final Set<Class<? extends Constraint<?>>> ALLOWED_CONSTRAINTS_FOR_UPSERT = Set.of(EntityFetch.class, AssociatedDataContent.class, AttributeContent.class, HierarchyContent.class, HierarchyDistance.class, HierarchyLevel.class, HierarchyNode.class, DataInLocales.class, PriceContent.class, ReferenceContent.class);
    public static final Set<Class<? extends Constraint<?>>> ALLOWED_CONSTRAINTS_FOR_DELETE = Set.of(EntityFetch.class, AssociatedDataContent.class, AttributeContent.class, DataInLocales.class, PriceContent.class, ReferenceContent.class, HierarchyContent.class, HierarchyDistance.class, HierarchyLevel.class, HierarchyNode.class, Strip.class, Page.class);
    private static final Set<Class<? extends Constraint<?>>> REQUIRED_FORBIDDEN = Set.of(Require.class);

    public RequireConstraintSchemaBuilder(@Nonnull OpenApiConstraintSchemaBuildingContext constraintSchemaBuildingCtx, @Nonnull AtomicReference<FilterConstraintSchemaBuilder> filterConstraintSchemaBuilder, @Nonnull AtomicReference<OrderConstraintSchemaBuilder> orderConstraintSchemaBuilder) {
        this(constraintSchemaBuildingCtx, Set.of(), filterConstraintSchemaBuilder, orderConstraintSchemaBuilder);
    }

    @Nonnull
    public OpenApiSimpleType build(@Nonnull String rootEntityType) {
        return (OpenApiSimpleType)this.build((DataLocator)new GenericDataLocator(rootEntityType));
    }

    public RequireConstraintSchemaBuilder(@Nonnull OpenApiConstraintSchemaBuildingContext constraintSchemaBuildingCtx, @Nonnull Set<Class<? extends Constraint<?>>> allowedConstraints, @Nonnull AtomicReference<FilterConstraintSchemaBuilder> filterConstraintSchemaBuilder, @Nonnull AtomicReference<OrderConstraintSchemaBuilder> orderConstraintSchemaBuilder) {
        super(constraintSchemaBuildingCtx, Map.of(ConstraintType.FILTER, filterConstraintSchemaBuilder, ConstraintType.ORDER, orderConstraintSchemaBuilder), allowedConstraints, REQUIRED_FORBIDDEN);
    }

    @Nonnull
    protected ConstraintType getConstraintType() {
        return ConstraintType.REQUIRE;
    }

    @Nonnull
    protected ConstraintDescriptor getDefaultRootConstraintContainerDescriptor() {
        return ConstraintDescriptorProvider.getConstraint(Require.class);
    }

    @Nonnull
    protected String getContainerObjectTypeName() {
        return "RequireContainer";
    }

    @Nonnull
    protected Predicate<AttributeSchemaContract> getAttributeSchemaFilter() {
        return attributeSchema -> true;
    }
}

