/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.dto;

import com.fasterxml.jackson.databind.JsonNode;
import io.evitadb.dataType.DataChunk;
import io.evitadb.externalApi.rest.api.catalog.dataApi.dto.DataChunkType;

public abstract class DataChunkDto {
    private final JsonNode data;
    private final DataChunkType type;
    private final int totalRecordCount;
    private final boolean first;
    private final boolean last;
    private final boolean hasPrevious;
    private final boolean hasNext;
    private final boolean singlePage;
    private final boolean empty;

    protected DataChunkDto(DataChunk<?> paginatedList, JsonNode data, DataChunkType type) {
        this.data = data;
        this.type = type;
        this.totalRecordCount = paginatedList.getTotalRecordCount();
        this.first = paginatedList.isFirst();
        this.last = paginatedList.isLast();
        this.hasPrevious = paginatedList.hasPrevious();
        this.hasNext = paginatedList.hasNext();
        this.singlePage = paginatedList.isSinglePage();
        this.empty = paginatedList.isEmpty();
    }

    public JsonNode getData() {
        return this.data;
    }

    public DataChunkType getType() {
        return this.type;
    }

    public int getTotalRecordCount() {
        return this.totalRecordCount;
    }

    public boolean isFirst() {
        return this.first;
    }

    public boolean isLast() {
        return this.last;
    }

    public boolean isHasPrevious() {
        return this.hasPrevious;
    }

    public boolean isHasNext() {
        return this.hasNext;
    }

    public boolean isSinglePage() {
        return this.singlePage;
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

