/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.constraint;

import io.evitadb.api.query.FilterConstraint;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.requestResponse.schema.AttributeSchemaContract;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.GlobalAttributeSchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.header.FetchEntityEndpointHeaderDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.header.GetEntityEndpointHeaderDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.header.ListUnknownEntitiesEndpointHeaderDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.header.QueryHeaderFilterArgumentsJoinType;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.header.UnknownEntityEndpointHeaderDescriptor;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.exception.RestInvalidArgumentException;
import io.evitadb.externalApi.rest.exception.RestQueryResolvingInternalError;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.time.OffsetDateTime;
import java.util.Currency;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FilterByConstraintFromRequestQueryBuilder {
    @Nullable
    public static <A extends Serializable & Comparable<A>> FilterBy buildFilterByForSingleEntity(@Nonnull Map<String, Object> parameters, @Nonnull EntitySchemaContract entitySchema) {
        LinkedList<Object> filterConstraints = new LinkedList<Object>();
        if (parameters.containsKey(GetEntityEndpointHeaderDescriptor.PRIMARY_KEY.name())) {
            filterConstraints.add(QueryConstraints.entityPrimaryKeyInSet((Integer[])new Integer[]{(Integer)parameters.get(GetEntityEndpointHeaderDescriptor.PRIMARY_KEY.name())}));
        }
        if (parameters.containsKey(GetEntityEndpointHeaderDescriptor.PRICE_IN_PRICE_LISTS.name())) {
            filterConstraints.add(QueryConstraints.priceInPriceLists((String[])((String[])parameters.get(GetEntityEndpointHeaderDescriptor.PRICE_IN_PRICE_LISTS.name()))));
        }
        if (parameters.containsKey(GetEntityEndpointHeaderDescriptor.PRICE_IN_CURRENCY.name())) {
            filterConstraints.add(QueryConstraints.priceInCurrency((Currency)((Currency)parameters.get(GetEntityEndpointHeaderDescriptor.PRICE_IN_CURRENCY.name()))));
        }
        if (parameters.containsKey(GetEntityEndpointHeaderDescriptor.PRICE_VALID_IN.name())) {
            filterConstraints.add(QueryConstraints.priceValidIn((OffsetDateTime)((OffsetDateTime)parameters.get(GetEntityEndpointHeaderDescriptor.PRICE_VALID_IN.name()))));
        }
        if (Boolean.TRUE.equals(parameters.get(GetEntityEndpointHeaderDescriptor.PRICE_VALID_NOW.name()))) {
            filterConstraints.add(QueryConstraints.priceValidInNow());
        }
        if (parameters.containsKey(GetEntityEndpointHeaderDescriptor.LOCALE.name())) {
            filterConstraints.add(QueryConstraints.entityLocaleEquals((Locale)((Locale)parameters.get(GetEntityEndpointHeaderDescriptor.LOCALE.name()))));
        }
        entitySchema.getAttributes().values().stream().filter(AttributeSchemaContract::isUnique).map(attributeSchema -> attributeSchema.getNameVariant(ExternalApiNamingConventions.ARGUMENT_NAME_NAMING_CONVENTION)).forEach(name -> {
            if (parameters.containsKey(name)) {
                filterConstraints.add(QueryConstraints.attributeEquals((String)name, (Serializable)((Serializable)parameters.get(name))));
            }
        });
        if (filterConstraints.isEmpty()) {
            return null;
        }
        return QueryConstraints.filterBy((FilterConstraint[])new FilterConstraint[]{QueryConstraints.and((FilterConstraint[])((FilterConstraint[])filterConstraints.toArray(FilterConstraint[]::new)))});
    }

    @Nullable
    public static <A extends Serializable & Comparable<A>> FilterBy buildFilterByForUnknownEntity(@Nonnull Map<String, Object> parameters, @Nonnull CatalogSchemaContract catalogSchema) {
        LinkedList filterConstraints = new LinkedList();
        Map<GlobalAttributeSchemaContract, Object> uniqueAttributes = FilterByConstraintFromRequestQueryBuilder.getGloballyUniqueAttributesFromParameters(parameters, catalogSchema);
        uniqueAttributes.forEach((attributeSchema, attributeValue) -> {
            String name = attributeSchema.getNameVariant(ExternalApiNamingConventions.ARGUMENT_NAME_NAMING_CONVENTION);
            filterConstraints.add(QueryConstraints.attributeEquals((String)name, (Serializable)((Serializable)attributeValue)));
        });
        Locale locale = (Locale)parameters.get(FetchEntityEndpointHeaderDescriptor.LOCALE.name());
        if (locale == null && uniqueAttributes.keySet().stream().anyMatch(GlobalAttributeSchemaContract::isUniqueGloballyWithinLocale)) {
            throw new RestInvalidArgumentException("Globally unique within locale attribute used but no locale was passed.");
        }
        Optional.ofNullable(locale).ifPresent(it -> filterConstraints.add(QueryConstraints.entityLocaleEquals((Locale)it)));
        QueryHeaderFilterArgumentsJoinType filterJoin = (QueryHeaderFilterArgumentsJoinType)((Object)parameters.getOrDefault(UnknownEntityEndpointHeaderDescriptor.FILTER_JOIN.name(), (Object)QueryHeaderFilterArgumentsJoinType.AND));
        if (filterConstraints.isEmpty()) {
            return null;
        }
        if (filterJoin == QueryHeaderFilterArgumentsJoinType.AND) {
            return QueryConstraints.filterBy((FilterConstraint[])new FilterConstraint[]{QueryConstraints.and((FilterConstraint[])((FilterConstraint[])filterConstraints.toArray(FilterConstraint[]::new)))});
        }
        if (filterJoin == QueryHeaderFilterArgumentsJoinType.OR) {
            return QueryConstraints.filterBy((FilterConstraint[])new FilterConstraint[]{QueryConstraints.or((FilterConstraint[])((FilterConstraint[])filterConstraints.toArray(FilterConstraint[]::new)))});
        }
        throw new RestInternalError("Unsupported filter join type `" + filterJoin + "`.");
    }

    @Nullable
    public static <A extends Serializable & Comparable<A>> FilterBy buildFilterByForUnknownEntityList(@Nonnull Map<String, Object> parameters, @Nonnull CatalogSchemaContract catalogSchema) {
        LinkedList filterConstraints = new LinkedList();
        Map<GlobalAttributeSchemaContract, Object> uniqueAttributes = FilterByConstraintFromRequestQueryBuilder.getGloballyUniqueAttributesFromParameters(parameters, catalogSchema);
        uniqueAttributes.forEach((attributeSchema, attributeValue) -> {
            String name = attributeSchema.getNameVariant(ExternalApiNamingConventions.ARGUMENT_NAME_NAMING_CONVENTION);
            if (attributeValue instanceof Object[]) {
                Object[] array = (Object[])attributeValue;
                filterConstraints.add(QueryConstraints.attributeInSet((String)name, (Serializable[])FilterByConstraintFromRequestQueryBuilder.convertObjectArrayToSpecificArray((Class)attributeSchema.getType(), (Object[])array)));
            } else {
                filterConstraints.add(QueryConstraints.attributeEquals((String)name, (Serializable)((Serializable)attributeValue)));
            }
        });
        Locale locale = (Locale)parameters.get(FetchEntityEndpointHeaderDescriptor.LOCALE.name());
        if (locale == null && uniqueAttributes.keySet().stream().anyMatch(GlobalAttributeSchemaContract::isUniqueGloballyWithinLocale)) {
            throw new RestInvalidArgumentException("Globally unique within locale attribute used but no locale was passed.");
        }
        Optional.ofNullable(locale).ifPresent(it -> filterConstraints.add(QueryConstraints.entityLocaleEquals((Locale)it)));
        QueryHeaderFilterArgumentsJoinType filterJoin = (QueryHeaderFilterArgumentsJoinType)((Object)parameters.getOrDefault(ListUnknownEntitiesEndpointHeaderDescriptor.FILTER_JOIN.name(), (Object)QueryHeaderFilterArgumentsJoinType.AND));
        if (filterConstraints.isEmpty()) {
            return null;
        }
        if (filterJoin == QueryHeaderFilterArgumentsJoinType.AND) {
            return QueryConstraints.filterBy((FilterConstraint[])new FilterConstraint[]{QueryConstraints.and((FilterConstraint[])((FilterConstraint[])filterConstraints.toArray(FilterConstraint[]::new)))});
        }
        if (filterJoin == QueryHeaderFilterArgumentsJoinType.OR) {
            return QueryConstraints.filterBy((FilterConstraint[])new FilterConstraint[]{QueryConstraints.or((FilterConstraint[])((FilterConstraint[])filterConstraints.toArray(FilterConstraint[]::new)))});
        }
        throw new RestInternalError("Unsupported filter join type `" + filterJoin + "`.");
    }

    @Nonnull
    private static Map<GlobalAttributeSchemaContract, Object> getGloballyUniqueAttributesFromParameters(@Nonnull Map<String, Object> parameters, @Nonnull CatalogSchemaContract catalogSchema) {
        HashMap uniqueAttributes = CollectionUtils.createHashMap((int)parameters.size());
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            String attributeName = parameter.getKey();
            GlobalAttributeSchemaContract attributeSchema = catalogSchema.getAttributeByName(attributeName, ExternalApiNamingConventions.ARGUMENT_NAME_NAMING_CONVENTION).orElse(null);
            if (attributeSchema == null) continue;
            Assert.isPremiseValid((boolean)attributeSchema.isUniqueGlobally(), () -> new RestQueryResolvingInternalError("Cannot find entity by non-unique attribute `" + attributeName + "`."));
            Object attributeValue = parameter.getValue();
            if (attributeValue == null) continue;
            uniqueAttributes.put(attributeSchema, attributeValue);
        }
        return uniqueAttributes;
    }

    @Nonnull
    private static <V extends Serializable & Comparable<?>> V[] convertObjectArrayToSpecificArray(@Nonnull Class<? extends Serializable> targetComponentType, @Nonnull Object[] restList) {
        try {
            Object array = Array.newInstance(targetComponentType, restList.length);
            for (int i = 0; i < restList.length; ++i) {
                Array.set(array, i, restList[i]);
            }
            return (Serializable[])array;
        }
        catch (ClassCastException e) {
            throw new RestInternalError("Could not cast REST list to array of type `" + targetComponentType.getName() + "`");
        }
    }

    private FilterByConstraintFromRequestQueryBuilder() {
    }
}

