/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.constraint;

import com.fasterxml.jackson.databind.JsonNode;
import io.evitadb.api.query.Constraint;
import io.evitadb.api.query.descriptor.ConstraintType;
import io.evitadb.externalApi.api.catalog.dataApi.constraint.DataLocator;
import io.evitadb.externalApi.api.catalog.dataApi.resolver.constraint.ConstraintResolver;
import io.evitadb.externalApi.exception.ExternalApiInternalError;
import io.evitadb.externalApi.exception.ExternalApiInvalidUsageException;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.CollectionRestHandlingContext;
import io.evitadb.externalApi.rest.api.openApi.SchemaUtils;
import io.evitadb.externalApi.rest.api.resolver.serializer.DataDeserializer;
import io.evitadb.externalApi.rest.exception.RestInvalidArgumentException;
import io.evitadb.externalApi.rest.exception.RestQueryResolvingInternalError;
import io.evitadb.utils.Assert;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class RestConstraintResolver<C extends Constraint<?>>
extends ConstraintResolver<C> {
    @Nonnull
    protected final CollectionRestHandlingContext restHandlingContext;
    @Nonnull
    protected final DataDeserializer dataDeserializer;

    protected RestConstraintResolver(@Nonnull CollectionRestHandlingContext restHandlingContext, @Nonnull Map<ConstraintType, AtomicReference<? extends ConstraintResolver<?>>> additionalResolvers) {
        super(restHandlingContext.getCatalogSchema(), additionalResolvers);
        this.restHandlingContext = restHandlingContext;
        this.dataDeserializer = new DataDeserializer(this.restHandlingContext.getOpenApi(), this.restHandlingContext.getEnumMapping());
    }

    @Nullable
    public C resolve(@Nonnull DataLocator dataLocator, @Nonnull String key, @Nullable Object value) {
        Object deserializedInputValue = this.deserializeInputValue(key, value);
        return (C)super.resolve(dataLocator, key, deserializedInputValue);
    }

    @Nullable
    private Object deserializeInputValue(@Nonnull String key, Object value) {
        Assert.isPremiseValid((boolean)(value instanceof JsonNode), () -> this.createQueryResolvingInternalError("Input value is not a JSON node. Instead it is `" + value.getClass().getName() + "`."));
        Schema rootSchema = (Schema)SchemaUtils.getTargetSchema(((MediaType)this.restHandlingContext.getEndpointOperation().getRequestBody().getContent().get((Object)"application/json")).getSchema(), this.restHandlingContext.getOpenApi()).getProperties().get(key);
        try {
            return this.dataDeserializer.deserializeTree(SchemaUtils.getTargetSchema(rootSchema, this.restHandlingContext.getOpenApi()), (JsonNode)value);
        }
        catch (Exception e) {
            throw this.createInvalidArgumentException("Could not parse query: " + e.getMessage());
        }
    }

    @Nonnull
    protected <T extends ExternalApiInternalError> T createQueryResolvingInternalError(@Nonnull String message) {
        return (T)((Object)new RestQueryResolvingInternalError(message));
    }

    @Nonnull
    protected <T extends ExternalApiInvalidUsageException> T createInvalidArgumentException(@Nonnull String message) {
        return (T)((Object)new RestInvalidArgumentException(message));
    }
}

