/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint;

import io.evitadb.api.query.ConstraintContainer;
import io.evitadb.api.query.Query;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.QueryUtils;
import io.evitadb.api.query.RequireConstraint;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.query.head.Collection;
import io.evitadb.api.query.order.OrderBy;
import io.evitadb.api.query.require.EntityContentRequire;
import io.evitadb.api.query.require.EntityFetch;
import io.evitadb.api.query.require.Require;
import io.evitadb.api.query.require.SeparateEntityContentRequireContainer;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.api.requestResponse.data.SealedEntity;
import io.evitadb.externalApi.http.EndpointResponse;
import io.evitadb.externalApi.http.SuccessEndpointResponse;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.CollectionRestHandlingContext;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.QueryOrientedEntitiesHandler;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.serializer.EntityJsonSerializer;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.serializer.EntitySerializationContext;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.io.RestEndpointExchange;
import io.evitadb.utils.ArrayUtils;
import io.evitadb.utils.Assert;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteEntitiesByQueryHandler
extends QueryOrientedEntitiesHandler {
    private static final Logger log = LoggerFactory.getLogger(DeleteEntitiesByQueryHandler.class);
    @Nonnull
    private final EntityJsonSerializer entityJsonSerializer;

    public DeleteEntitiesByQueryHandler(@Nonnull CollectionRestHandlingContext restHandlingContext) {
        super(restHandlingContext);
        this.entityJsonSerializer = new EntityJsonSerializer(((CollectionRestHandlingContext)this.restHandlingContext).isLocalized(), ((CollectionRestHandlingContext)this.restHandlingContext).getObjectMapper());
    }

    @Override
    protected boolean modifiesData() {
        return true;
    }

    @Nonnull
    protected EndpointResponse doHandleRequest(@Nonnull RestEndpointExchange exchange) {
        Query query = this.resolveQuery(exchange);
        if (QueryUtils.findRequire((Query)query, EntityFetch.class, SeparateEntityContentRequireContainer.class) == null) {
            query = Query.query((Collection)query.getCollection(), (FilterBy)query.getFilterBy(), (OrderBy)query.getOrderBy(), (Require)QueryConstraints.require((RequireConstraint[])((RequireConstraint[])ArrayUtils.mergeArrays((Object[][])new RequireConstraint[][]{Optional.ofNullable(query.getRequire()).map(ConstraintContainer::getChildren).orElse(new RequireConstraint[0]), {QueryConstraints.entityFetch((EntityContentRequire[])new EntityContentRequire[0])}}))));
        }
        log.debug("Generated evitaDB query for deletion of entity list of type `{}` is `{}`.", (Object)((CollectionRestHandlingContext)this.restHandlingContext).getEntitySchema(), (Object)query);
        SealedEntity[] deletedEntities = exchange.session().deleteSealedEntitiesAndReturnBodies(query);
        return new SuccessEndpointResponse(this.convertResultIntoSerializableObject(exchange, deletedEntities));
    }

    @Override
    @Nonnull
    public Set<String> getSupportedHttpMethods() {
        return Set.of("DELETE");
    }

    @Override
    @Nonnull
    protected Object convertResultIntoSerializableObject(@Nonnull RestEndpointExchange exchange, @Nonnull Object deletedEntities) {
        Assert.isPremiseValid((boolean)(deletedEntities instanceof SealedEntity[]), () -> new RestInternalError("Expected SealedEntity[], but got `" + deletedEntities.getClass().getName() + "`."));
        return this.entityJsonSerializer.serialize(new EntitySerializationContext(((CollectionRestHandlingContext)this.restHandlingContext).getCatalogSchema()), (EntityClassifier[])((SealedEntity[])deletedEntities));
    }
}

