/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint;

import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.serializer.EntityJsonSerializer;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.serializer.EntitySerializationContext;
import io.evitadb.externalApi.rest.api.catalog.resolver.endpoint.CatalogRestHandlingContext;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.io.JsonRestHandler;
import io.evitadb.externalApi.rest.io.RestEndpointExchange;
import io.evitadb.utils.Assert;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityHandler<CTX extends CatalogRestHandlingContext>
extends JsonRestHandler<CTX> {
    private static final Logger log = LoggerFactory.getLogger(EntityHandler.class);
    @Nonnull
    private final EntityJsonSerializer entityJsonSerializer;

    protected EntityHandler(@Nonnull CTX restApiHandlingContext) {
        super(restApiHandlingContext);
        this.entityJsonSerializer = new EntityJsonSerializer(((CatalogRestHandlingContext)this.restHandlingContext).isLocalized(), ((CatalogRestHandlingContext)this.restHandlingContext).getObjectMapper());
    }

    @Nonnull
    public LinkedHashSet<String> getSupportedResponseContentTypes() {
        return DEFAULT_SUPPORTED_CONTENT_TYPES;
    }

    @Override
    @Nonnull
    protected Object convertResultIntoSerializableObject(@Nonnull RestEndpointExchange exchange, @Nonnull Object deletedEntity) {
        Assert.isPremiseValid((boolean)(deletedEntity instanceof EntityClassifier), () -> new RestInternalError("Entity must be instance of EntityClassifier, but got `" + deletedEntity.getClass().getName() + "`."));
        return this.entityJsonSerializer.serialize(new EntitySerializationContext(((CatalogRestHandlingContext)this.restHandlingContext).getCatalogSchema()), (EntityClassifier)deletedEntity);
    }
}

