/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint;

import io.evitadb.api.query.Query;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.query.require.Require;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.externalApi.http.EndpointResponse;
import io.evitadb.externalApi.http.NotFoundEndpointResponse;
import io.evitadb.externalApi.http.SuccessEndpointResponse;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.constraint.FilterByConstraintFromRequestQueryBuilder;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.constraint.RequireConstraintFromRequestQueryBuilder;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.EntityHandler;
import io.evitadb.externalApi.rest.api.catalog.resolver.endpoint.CatalogRestHandlingContext;
import io.evitadb.externalApi.rest.io.RestEndpointExchange;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetUnknownEntityHandler
extends EntityHandler<CatalogRestHandlingContext> {
    private static final Logger log = LoggerFactory.getLogger(GetUnknownEntityHandler.class);

    public GetUnknownEntityHandler(@Nonnull CatalogRestHandlingContext restHandlingContext) {
        super(restHandlingContext);
    }

    @Nonnull
    protected EndpointResponse doHandleRequest(@Nonnull RestEndpointExchange exchange) {
        Map<String, Object> parametersFromRequest = this.getParametersFromRequest(exchange);
        Query query = Query.query((FilterBy)FilterByConstraintFromRequestQueryBuilder.buildFilterByForUnknownEntity(parametersFromRequest, ((CatalogRestHandlingContext)this.restHandlingContext).getCatalogSchema()), (Require)RequireConstraintFromRequestQueryBuilder.buildRequire(parametersFromRequest));
        log.debug("Generated evitaDB query for single unknown entity fetch is `{}`.", (Object)query);
        return exchange.session().queryOne(query, EntityClassifier.class).map(it -> new SuccessEndpointResponse(this.convertResultIntoSerializableObject(exchange, it))).orElse((EndpointResponse)new NotFoundEndpointResponse());
    }

    @Nonnull
    public Set<String> getSupportedHttpMethods() {
        return Set.of("GET");
    }
}

