/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint;

import io.evitadb.api.query.Query;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.externalApi.http.EndpointResponse;
import io.evitadb.externalApi.http.SuccessEndpointResponse;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.CollectionRestHandlingContext;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.QueryOrientedEntitiesHandler;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.serializer.EntityJsonSerializer;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.serializer.EntitySerializationContext;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.io.RestEndpointExchange;
import io.evitadb.utils.Assert;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListEntitiesHandler
extends QueryOrientedEntitiesHandler {
    private static final Logger log = LoggerFactory.getLogger(ListEntitiesHandler.class);
    @Nonnull
    private final EntityJsonSerializer entityJsonSerializer;

    public ListEntitiesHandler(@Nonnull CollectionRestHandlingContext restApiHandlingContext) {
        super(restApiHandlingContext);
        this.entityJsonSerializer = new EntityJsonSerializer(((CollectionRestHandlingContext)this.restHandlingContext).isLocalized(), ((CollectionRestHandlingContext)this.restHandlingContext).getObjectMapper());
    }

    @Nonnull
    protected EndpointResponse doHandleRequest(@Nonnull RestEndpointExchange exchange) {
        Query query = this.resolveQuery(exchange);
        log.debug("Generated evitaDB query for entity list of type `{}` is `{}`.", (Object)((CollectionRestHandlingContext)this.restHandlingContext).getEntitySchema(), (Object)query);
        List entities = exchange.session().queryList(query, EntityClassifier.class);
        return new SuccessEndpointResponse(this.convertResultIntoSerializableObject(exchange, entities));
    }

    @Override
    @Nonnull
    protected Object convertResultIntoSerializableObject(@Nonnull RestEndpointExchange exchange, @Nonnull Object entities) {
        Assert.isPremiseValid((boolean)(entities instanceof List), () -> new RestInternalError("Expected list of entities, but got `" + entities.getClass().getName() + "`."));
        return this.entityJsonSerializer.serialize(new EntitySerializationContext(((CollectionRestHandlingContext)this.restHandlingContext).getCatalogSchema()), (List)entities);
    }
}

