/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint;

import io.evitadb.api.query.Query;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.query.require.Require;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.externalApi.http.EndpointResponse;
import io.evitadb.externalApi.http.SuccessEndpointResponse;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.constraint.FilterByConstraintFromRequestQueryBuilder;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.constraint.RequireConstraintFromRequestQueryBuilder;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.serializer.EntityJsonSerializer;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.serializer.EntitySerializationContext;
import io.evitadb.externalApi.rest.api.catalog.resolver.endpoint.CatalogRestHandlingContext;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.io.JsonRestHandler;
import io.evitadb.externalApi.rest.io.RestEndpointExchange;
import io.evitadb.utils.Assert;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListUnknownEntitiesHandler
extends JsonRestHandler<CatalogRestHandlingContext> {
    private static final Logger log = LoggerFactory.getLogger(ListUnknownEntitiesHandler.class);
    @Nonnull
    private final EntityJsonSerializer entityJsonSerializer;

    public ListUnknownEntitiesHandler(@Nonnull CatalogRestHandlingContext restHandlingContext) {
        super(restHandlingContext);
        this.entityJsonSerializer = new EntityJsonSerializer(((CatalogRestHandlingContext)this.restHandlingContext).isLocalized(), ((CatalogRestHandlingContext)this.restHandlingContext).getObjectMapper());
    }

    @Nonnull
    protected EndpointResponse doHandleRequest(@Nonnull RestEndpointExchange exchange) {
        Map<String, Object> parametersFromRequest = this.getParametersFromRequest(exchange);
        Query query = Query.query((FilterBy)FilterByConstraintFromRequestQueryBuilder.buildFilterByForUnknownEntityList(parametersFromRequest, ((CatalogRestHandlingContext)this.restHandlingContext).getCatalogSchema()), (Require)RequireConstraintFromRequestQueryBuilder.buildRequire(parametersFromRequest));
        log.debug("Generated evitaDB query for unknown entity list fetch is `{}`.", (Object)query);
        List entities = exchange.session().queryList(query, EntityClassifier.class);
        return new SuccessEndpointResponse(this.convertResultIntoSerializableObject(exchange, entities));
    }

    @Nonnull
    public Set<String> getSupportedHttpMethods() {
        return Set.of("GET");
    }

    @Nonnull
    public LinkedHashSet<String> getSupportedResponseContentTypes() {
        return DEFAULT_SUPPORTED_CONTENT_TYPES;
    }

    @Override
    @Nonnull
    protected Object convertResultIntoSerializableObject(@Nonnull RestEndpointExchange exchange, @Nonnull Object entities) {
        Assert.isPremiseValid((boolean)(entities instanceof List), () -> new RestInternalError("Expected list of entities, but got `" + entities.getClass().getName() + "`."));
        return this.entityJsonSerializer.serialize(new EntitySerializationContext(((CatalogRestHandlingContext)this.restHandlingContext).getCatalogSchema()), (List)entities);
    }
}

