/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint;

import io.evitadb.api.query.Query;
import io.evitadb.api.requestResponse.EvitaResponse;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.dataType.DataChunk;
import io.evitadb.dataType.PaginatedList;
import io.evitadb.dataType.StripList;
import io.evitadb.externalApi.http.EndpointResponse;
import io.evitadb.externalApi.http.SuccessEndpointResponse;
import io.evitadb.externalApi.rest.api.catalog.dataApi.dto.DataChunkDto;
import io.evitadb.externalApi.rest.api.catalog.dataApi.dto.PaginatedListDto;
import io.evitadb.externalApi.rest.api.catalog.dataApi.dto.QueryResponse;
import io.evitadb.externalApi.rest.api.catalog.dataApi.dto.StripListDto;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.CollectionRestHandlingContext;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.QueryOrientedEntitiesHandler;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.serializer.EntityJsonSerializer;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.serializer.EntitySerializationContext;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.serializer.ExtraResultsJsonSerializer;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.io.RestEndpointExchange;
import io.evitadb.utils.Assert;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryEntitiesHandler
extends QueryOrientedEntitiesHandler {
    private static final Logger log = LoggerFactory.getLogger(QueryEntitiesHandler.class);
    @Nonnull
    private final EntityJsonSerializer entityJsonSerializer;
    @Nonnull
    private final ExtraResultsJsonSerializer extraResultsJsonSerializer;

    public QueryEntitiesHandler(@Nonnull CollectionRestHandlingContext restHandlingContext) {
        super(restHandlingContext);
        this.entityJsonSerializer = new EntityJsonSerializer(((CollectionRestHandlingContext)this.restHandlingContext).isLocalized(), ((CollectionRestHandlingContext)this.restHandlingContext).getObjectMapper());
        this.extraResultsJsonSerializer = new ExtraResultsJsonSerializer(this.entityJsonSerializer, ((CollectionRestHandlingContext)this.restHandlingContext).getObjectMapper());
    }

    @Nonnull
    protected EndpointResponse doHandleRequest(@Nonnull RestEndpointExchange exchange) {
        Query query = this.resolveQuery(exchange);
        log.debug("Generated evitaDB query for entity query of type `{}` is `{}`.", (Object)((CollectionRestHandlingContext)this.restHandlingContext).getEntitySchema(), (Object)query);
        EvitaResponse response = exchange.session().query(query, EntityClassifier.class);
        return new SuccessEndpointResponse(this.convertResultIntoSerializableObject(exchange, response));
    }

    @Override
    @Nonnull
    protected Object convertResultIntoSerializableObject(@Nonnull RestEndpointExchange exchange, @Nonnull Object response) {
        Assert.isPremiseValid((boolean)(response instanceof EvitaResponse), () -> new RestInternalError("Expected evitaDB response, but got `" + response.getClass().getName() + "`."));
        EvitaResponse evitaResponse = (EvitaResponse)response;
        QueryResponse.QueryResponseBuilder queryResponseBuilder = QueryResponse.builder().recordPage(this.serializeRecordPage((EvitaResponse<EntityClassifier>)evitaResponse));
        if (!evitaResponse.getExtraResults().isEmpty()) {
            queryResponseBuilder.extraResults(this.extraResultsJsonSerializer.serialize(evitaResponse.getExtraResults(), ((CollectionRestHandlingContext)this.restHandlingContext).getEntitySchema(), ((CollectionRestHandlingContext)this.restHandlingContext).getCatalogSchema()));
        }
        return queryResponseBuilder.build();
    }

    @Nonnull
    private DataChunkDto serializeRecordPage(@Nonnull EvitaResponse<EntityClassifier> response) {
        DataChunk recordPage = response.getRecordPage();
        EntitySerializationContext serializationContext = new EntitySerializationContext(((CollectionRestHandlingContext)this.restHandlingContext).getCatalogSchema());
        if (recordPage instanceof PaginatedList) {
            PaginatedList paginatedList = (PaginatedList)recordPage;
            return new PaginatedListDto(paginatedList, this.entityJsonSerializer.serialize(serializationContext, paginatedList.getData()));
        }
        if (recordPage instanceof StripList) {
            StripList stripList = (StripList)recordPage;
            return new StripListDto(stripList, this.entityJsonSerializer.serialize(serializationContext, stripList.getData()));
        }
        throw new RestInternalError("Unsupported data chunk type `" + recordPage.getClass().getName() + "`.");
    }
}

