/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint;

import io.evitadb.api.query.FilterConstraint;
import io.evitadb.api.query.Query;
import io.evitadb.api.query.QueryConstraints;
import io.evitadb.api.query.QueryUtils;
import io.evitadb.api.query.RequireConstraint;
import io.evitadb.api.query.filter.EntityLocaleEquals;
import io.evitadb.api.query.filter.FilterBy;
import io.evitadb.api.query.head.Collection;
import io.evitadb.api.query.order.OrderBy;
import io.evitadb.api.query.require.Require;
import io.evitadb.externalApi.http.EndpointExchange;
import io.evitadb.externalApi.rest.api.catalog.dataApi.dto.QueryEntityRequestDto;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.FetchEntityRequestDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.header.FetchEntityEndpointHeaderDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.constraint.FilterConstraintResolver;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.constraint.OrderConstraintResolver;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.constraint.RequireConstraintResolver;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.CollectionRestHandlingContext;
import io.evitadb.externalApi.rest.exception.RestInvalidArgumentException;
import io.evitadb.externalApi.rest.exception.RestRequiredParameterMissingException;
import io.evitadb.externalApi.rest.io.JsonRestHandler;
import io.evitadb.externalApi.rest.io.RestEndpointExchange;
import io.evitadb.utils.ArrayUtils;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryOrientedEntitiesHandler
extends JsonRestHandler<CollectionRestHandlingContext> {
    private static final Logger log = LoggerFactory.getLogger(QueryOrientedEntitiesHandler.class);
    @Nonnull
    private final FilterConstraintResolver filterConstraintResolver;
    @Nonnull
    private final OrderConstraintResolver orderConstraintResolver;
    @Nonnull
    private final RequireConstraintResolver requireConstraintResolver;

    protected QueryOrientedEntitiesHandler(@Nonnull CollectionRestHandlingContext restApiHandlingContext) {
        super(restApiHandlingContext);
        this.filterConstraintResolver = new FilterConstraintResolver(restApiHandlingContext);
        this.orderConstraintResolver = new OrderConstraintResolver(restApiHandlingContext);
        this.requireConstraintResolver = new RequireConstraintResolver(restApiHandlingContext, new AtomicReference<FilterConstraintResolver>(this.filterConstraintResolver), new AtomicReference<OrderConstraintResolver>(this.orderConstraintResolver));
    }

    @Nonnull
    public Set<String> getSupportedHttpMethods() {
        return Set.of("POST");
    }

    @Nonnull
    public Set<String> getSupportedRequestContentTypes() {
        return DEFAULT_SUPPORTED_CONTENT_TYPES;
    }

    @Nonnull
    public LinkedHashSet<String> getSupportedResponseContentTypes() {
        return DEFAULT_SUPPORTED_CONTENT_TYPES;
    }

    @Nonnull
    protected Query resolveQuery(@Nonnull RestEndpointExchange exchange) {
        QueryEntityRequestDto requestData = this.parseRequestBody(exchange, QueryEntityRequestDto.class);
        FilterBy filterBy = requestData.getFilterBy().map(container -> (FilterBy)this.filterConstraintResolver.resolve(FetchEntityRequestDescriptor.FILTER_BY.name(), container)).orElse(null);
        OrderBy orderBy = requestData.getOrderBy().map(container -> (OrderBy)this.orderConstraintResolver.resolve(FetchEntityRequestDescriptor.ORDER_BY.name(), container)).orElse(null);
        Require require = requestData.getRequire().map(container -> (Require)this.requireConstraintResolver.resolve(FetchEntityRequestDescriptor.REQUIRE.name(), container)).orElse(null);
        return Query.query((Collection)QueryConstraints.collection((String)((CollectionRestHandlingContext)this.restHandlingContext).getEntityType()), (FilterBy)this.addLocaleIntoFilterByWhenUrlPathLocalized(exchange, filterBy), (OrderBy)orderBy, (Require)require);
    }

    @Nonnull
    protected FilterBy addLocaleIntoFilterByWhenUrlPathLocalized(@Nonnull EndpointExchange exchange, @Nullable FilterBy filterBy) {
        if (((CollectionRestHandlingContext)this.restHandlingContext).isLocalized()) {
            Map<String, Object> parametersFromRequest = this.getParametersFromRequest(exchange);
            Locale locale = (Locale)parametersFromRequest.get(FetchEntityEndpointHeaderDescriptor.LOCALE.name());
            if (locale == null) {
                throw new RestRequiredParameterMissingException("Missing LOCALE in URL path.");
            }
            Optional<FilterConstraint> localeEquals = Optional.ofNullable(QueryUtils.findFilter((Query)Query.query((FilterBy)filterBy, (Require)QueryConstraints.require((RequireConstraint[])new RequireConstraint[0])), EntityLocaleEquals.class));
            if (localeEquals.isPresent()) {
                throw new RestInvalidArgumentException("When using localized URL path then entity_locale_equals constraint can't be present in filterBy.");
            }
            if (filterBy != null) {
                EntityLocaleEquals newLocaleConstraint = QueryConstraints.entityLocaleEquals((Locale)locale);
                return QueryConstraints.filterBy((FilterConstraint[])((FilterConstraint[])ArrayUtils.mergeArrays((Object[][])new FilterConstraint[][]{(FilterConstraint[])filterBy.getChildren(), {newLocaleConstraint}})));
            }
            return QueryConstraints.filterBy((FilterConstraint[])new FilterConstraint[]{QueryConstraints.entityLocaleEquals((Locale)locale)});
        }
        return filterBy;
    }
}

