/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint;

import io.evitadb.api.query.RequireConstraint;
import io.evitadb.api.query.require.EntityContentRequire;
import io.evitadb.api.query.require.EntityFetch;
import io.evitadb.api.query.require.Require;
import io.evitadb.api.requestResponse.data.mutation.EntityMutation;
import io.evitadb.api.requestResponse.data.mutation.EntityUpsertMutation;
import io.evitadb.api.requestResponse.data.structure.EntityReference;
import io.evitadb.externalApi.http.EndpointResponse;
import io.evitadb.externalApi.http.SuccessEndpointResponse;
import io.evitadb.externalApi.rest.api.catalog.dataApi.dto.UpsertEntityUpsertRequestDto;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.FetchEntityRequestDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.header.DeleteEntityEndpointHeaderDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.constraint.FilterConstraintResolver;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.constraint.OrderConstraintResolver;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.constraint.RequireConstraintResolver;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.CollectionRestHandlingContext;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.endpoint.EntityHandler;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.mutation.RestEntityUpsertMutationConverter;
import io.evitadb.externalApi.rest.exception.RestInvalidArgumentException;
import io.evitadb.externalApi.rest.io.RestEndpointExchange;
import io.evitadb.utils.Assert;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpsertEntityHandler
extends EntityHandler<CollectionRestHandlingContext> {
    private static final Logger log = LoggerFactory.getLogger(UpsertEntityHandler.class);
    @Nonnull
    private final RestEntityUpsertMutationConverter mutationResolver;
    @Nonnull
    private final RequireConstraintResolver requireConstraintResolver;
    private final boolean withPrimaryKeyInPath;

    public UpsertEntityHandler(@Nonnull CollectionRestHandlingContext restApiHandlingContext, boolean withPrimaryKeyInPath) {
        super(restApiHandlingContext);
        this.mutationResolver = new RestEntityUpsertMutationConverter(restApiHandlingContext.getObjectMapper(), restApiHandlingContext.getEntitySchema());
        this.requireConstraintResolver = new RequireConstraintResolver(restApiHandlingContext, new AtomicReference<FilterConstraintResolver>(new FilterConstraintResolver(restApiHandlingContext)), new AtomicReference<OrderConstraintResolver>(new OrderConstraintResolver(restApiHandlingContext)));
        this.withPrimaryKeyInPath = withPrimaryKeyInPath;
    }

    @Override
    protected boolean modifiesData() {
        return true;
    }

    @Nonnull
    protected EndpointResponse doHandleRequest(@Nonnull RestEndpointExchange exchange) {
        UpsertEntityUpsertRequestDto requestData = this.parseRequestBody(exchange, UpsertEntityUpsertRequestDto.class);
        if (this.withPrimaryKeyInPath) {
            Map<String, Object> parametersFromRequest = this.getParametersFromRequest(exchange);
            Assert.isTrue((boolean)parametersFromRequest.containsKey(DeleteEntityEndpointHeaderDescriptor.PRIMARY_KEY.name()), () -> new RestInvalidArgumentException("Primary key is not present in request's URL path."));
            requestData.setPrimaryKey((Integer)parametersFromRequest.get(DeleteEntityEndpointHeaderDescriptor.PRIMARY_KEY.name()));
        }
        EntityUpsertMutation entityMutation = this.mutationResolver.convert(requestData.getPrimaryKey().orElse(null), requestData.getEntityExistence().orElseThrow(() -> new RestInvalidArgumentException("EntityExistence is not set in request data.")), requestData.getMutations().orElseThrow(() -> new RestInvalidArgumentException("Mutations are not set in request data.")));
        EntityContentRequire[] requires = this.getEntityContentRequires(requestData).orElse(null);
        EntityReference upsertedEntity = requestData.getRequire().isPresent() ? exchange.session().upsertAndFetchEntity((EntityMutation)entityMutation, requires) : exchange.session().upsertEntity((EntityMutation)entityMutation);
        return new SuccessEndpointResponse(this.convertResultIntoSerializableObject(exchange, upsertedEntity));
    }

    @Nonnull
    public Set<String> getSupportedHttpMethods() {
        return Set.of(this.withPrimaryKeyInPath ? "PUT" : "POST");
    }

    @Nonnull
    public Set<String> getSupportedRequestContentTypes() {
        return DEFAULT_SUPPORTED_CONTENT_TYPES;
    }

    @Nonnull
    private Optional<EntityContentRequire[]> getEntityContentRequires(@Nonnull UpsertEntityUpsertRequestDto requestData) {
        return requestData.getRequire().map(it -> (Require)this.requireConstraintResolver.resolve(FetchEntityRequestDescriptor.REQUIRE.name(), it)).flatMap(require -> Arrays.stream((RequireConstraint[])require.getChildren()).filter(EntityFetch.class::isInstance).findFirst().map(entityFetch -> {
            RequireConstraint[] children = (RequireConstraint[])((EntityFetch)entityFetch).getChildren();
            EntityContentRequire[] requires = new EntityContentRequire[children.length];
            for (int i = 0; i < children.length; ++i) {
                requires[i] = (EntityContentRequire)children[i];
            }
            return requires;
        }));
    }
}

