/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.evitadb.api.query.require.QueryPriceMode;
import io.evitadb.api.requestResponse.data.AssociatedDataContract;
import io.evitadb.api.requestResponse.data.AttributesContract;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.api.requestResponse.data.EntityClassifierWithParent;
import io.evitadb.api.requestResponse.data.PriceContract;
import io.evitadb.api.requestResponse.data.PriceInnerRecordHandling;
import io.evitadb.api.requestResponse.data.ReferenceContract;
import io.evitadb.api.requestResponse.data.structure.EntityDecorator;
import io.evitadb.api.requestResponse.schema.AttributeSchemaProvider;
import io.evitadb.api.requestResponse.schema.Cardinality;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.NamedSchemaContract;
import io.evitadb.api.requestResponse.schema.ReferenceSchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.api.catalog.dataApi.model.ReferenceDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.entity.RestEntityDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.entity.SectionedAssociatedDataDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.entity.SectionedAttributesDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.serializer.EntitySerializationContext;
import io.evitadb.externalApi.rest.api.resolver.serializer.ObjectJsonSerializer;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.exception.RestQueryResolvingInternalError;
import io.evitadb.utils.Assert;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityJsonSerializer {
    private static final Logger log = LoggerFactory.getLogger(EntityJsonSerializer.class);
    protected final boolean localized;
    protected final ObjectJsonSerializer objectJsonSerializer;

    public EntityJsonSerializer(boolean localized, @Nonnull ObjectMapper objectMapper) {
        this.localized = localized;
        this.objectJsonSerializer = new ObjectJsonSerializer(objectMapper);
    }

    public JsonNode serialize(@Nonnull EntitySerializationContext ctx, @Nonnull EntityClassifier entityClassifier) {
        return this.serializeSingleEntity(ctx, entityClassifier);
    }

    public JsonNode serialize(@Nonnull EntitySerializationContext ctx, @Nonnull List<EntityClassifier> entityClassifiers) {
        ArrayNode arrayNode = this.objectJsonSerializer.arrayNode();
        for (EntityClassifier classifier : entityClassifiers) {
            arrayNode.add((JsonNode)this.serializeSingleEntity(ctx, classifier));
        }
        return arrayNode;
    }

    public JsonNode serialize(@Nonnull EntitySerializationContext ctx, @Nonnull EntityClassifier[] entityClassifiers) {
        return this.serialize(ctx, Arrays.asList(entityClassifiers));
    }

    @Nonnull
    private ObjectNode serializeSingleEntity(@Nonnull EntitySerializationContext ctx, @Nonnull EntityClassifier entityClassifier) {
        ObjectNode rootNode = this.serializeEntityClassifier(entityClassifier);
        if (entityClassifier instanceof EntityDecorator) {
            EntityDecorator entity = (EntityDecorator)entityClassifier;
            EntitySchemaContract entitySchema = ctx.getCatalogSchema().getEntitySchemaOrThrowException(entity.getType());
            this.serializeEntityBody(ctx, rootNode, entity);
            this.serializeAttributes(rootNode, entity.getLocales(), (AttributesContract<?>)entity, (NamedSchemaContract)entitySchema, (AttributeSchemaProvider<?>)entitySchema);
            this.serializeAssociatedData(rootNode, entity.getLocales(), (AssociatedDataContract)entity, entitySchema);
            this.serializePrices(ctx, rootNode, entity);
            this.serializeReferences(ctx, rootNode, entity, entitySchema);
        } else if (entityClassifier instanceof EntityClassifierWithParent) {
            EntityClassifierWithParent entity = (EntityClassifierWithParent)entityClassifier;
            entity.getParentEntity().ifPresent(parent -> rootNode.putIfAbsent(RestEntityDescriptor.PARENT_ENTITY.name(), (JsonNode)this.serializeSingleEntity(ctx, (EntityClassifier)parent)));
        }
        return rootNode;
    }

    @Nonnull
    private ObjectNode serializeEntityClassifier(@Nonnull EntityClassifier entity) {
        ObjectNode rootNode = this.objectJsonSerializer.objectNode();
        rootNode.put(RestEntityDescriptor.PRIMARY_KEY.name(), entity.getPrimaryKey());
        rootNode.put(RestEntityDescriptor.TYPE.name(), entity.getType());
        return rootNode;
    }

    private void serializeEntityBody(@Nonnull EntitySerializationContext ctx, @Nonnull ObjectNode rootNode, @Nonnull EntityDecorator entity) {
        rootNode.put(RestEntityDescriptor.VERSION.name(), entity.version());
        if (entity.parentAvailable()) {
            entity.getParentEntity().ifPresent(parent -> rootNode.putIfAbsent(RestEntityDescriptor.PARENT_ENTITY.name(), (JsonNode)this.serializeSingleEntity(ctx, (EntityClassifier)parent)));
        }
        if (!entity.getLocales().isEmpty()) {
            rootNode.putIfAbsent(RestEntityDescriptor.LOCALES.name(), this.objectJsonSerializer.serializeObject(entity.getLocales()));
        }
        if (!entity.getAllLocales().isEmpty()) {
            rootNode.putIfAbsent(RestEntityDescriptor.ALL_LOCALES.name(), this.objectJsonSerializer.serializeObject(entity.getAllLocales()));
        }
        if (entity.getPriceInnerRecordHandling() != PriceInnerRecordHandling.UNKNOWN) {
            rootNode.putIfAbsent(RestEntityDescriptor.PRICE_INNER_RECORD_HANDLING.name(), this.objectJsonSerializer.serializeObject(entity.getPriceInnerRecordHandling()));
        }
    }

    private void serializeAttributes(@Nonnull ObjectNode rootNode, @Nonnull Set<Locale> locales, @Nonnull AttributesContract<?> attributes, @Nonnull NamedSchemaContract parentSchema, @Nonnull AttributeSchemaProvider<?> attributeSchemaProvider) {
        if (attributes.attributesAvailable() && !attributes.getAttributeKeys().isEmpty()) {
            ObjectNode attributesNode = this.objectJsonSerializer.objectNode();
            rootNode.putIfAbsent(RestEntityDescriptor.ATTRIBUTES.name(), (JsonNode)attributesNode);
            Set attributeKeys = attributes.getAttributeKeys();
            if (this.localized) {
                this.writeAttributesIntoNode(attributesNode, attributeKeys, attributes, parentSchema, attributeSchemaProvider);
            } else {
                Map<String, List<AttributesContract.AttributeKey>> localeSeparatedKeys = EntityJsonSerializer.separateAttributeKeysByLocale(locales, attributeKeys);
                List<AttributesContract.AttributeKey> globalAttributes = localeSeparatedKeys.remove(SectionedAttributesDescriptor.GLOBAL.name());
                if (!globalAttributes.isEmpty()) {
                    ObjectNode globalNode = this.objectJsonSerializer.objectNode();
                    attributesNode.putIfAbsent(SectionedAttributesDescriptor.GLOBAL.name(), (JsonNode)globalNode);
                    this.writeAttributesIntoNode(globalNode, globalAttributes, attributes, parentSchema, attributeSchemaProvider);
                }
                ObjectNode localizedNode = this.objectJsonSerializer.objectNode();
                for (Map.Entry<String, List<AttributesContract.AttributeKey>> entry : localeSeparatedKeys.entrySet()) {
                    ObjectNode langNode = this.objectJsonSerializer.objectNode();
                    this.writeAttributesIntoNode(langNode, (Collection<AttributesContract.AttributeKey>)entry.getValue(), attributes, parentSchema, attributeSchemaProvider);
                    if (langNode.isEmpty()) continue;
                    localizedNode.putIfAbsent(entry.getKey(), (JsonNode)langNode);
                }
                if (!localizedNode.isEmpty()) {
                    attributesNode.putIfAbsent(SectionedAttributesDescriptor.LOCALIZED.name(), (JsonNode)localizedNode);
                }
            }
        }
    }

    private void serializeAssociatedData(@Nonnull ObjectNode rootNode, @Nonnull Set<Locale> locales, @Nonnull AssociatedDataContract associatedData, @Nonnull EntitySchemaContract entitySchema) {
        if (associatedData.associatedDataAvailable() && !associatedData.getAssociatedDataKeys().isEmpty()) {
            ObjectNode associatedDataNode = this.objectJsonSerializer.objectNode();
            Set associatedDataKeys = associatedData.getAssociatedDataKeys();
            if (this.localized) {
                this.writeAssociatedDataIntoNode(associatedDataNode, entitySchema, associatedDataKeys, associatedData);
            } else {
                Map<String, List<AssociatedDataContract.AssociatedDataKey>> localeSeparatedKeys = EntityJsonSerializer.separateAssociatedDataKeysByLocale(locales, associatedDataKeys);
                List<AssociatedDataContract.AssociatedDataKey> globalAssociatedData = localeSeparatedKeys.remove(SectionedAssociatedDataDescriptor.GLOBAL.name());
                if (!globalAssociatedData.isEmpty()) {
                    ObjectNode globalNode = this.objectJsonSerializer.objectNode();
                    associatedDataNode.putIfAbsent(SectionedAssociatedDataDescriptor.GLOBAL.name(), (JsonNode)globalNode);
                    this.writeAssociatedDataIntoNode(globalNode, entitySchema, globalAssociatedData, associatedData);
                }
                ObjectNode localizedNode = this.objectJsonSerializer.objectNode();
                for (Map.Entry<String, List<AssociatedDataContract.AssociatedDataKey>> entry : localeSeparatedKeys.entrySet()) {
                    ObjectNode langNode = this.objectJsonSerializer.objectNode();
                    this.writeAssociatedDataIntoNode(langNode, entitySchema, (Collection<AssociatedDataContract.AssociatedDataKey>)entry.getValue(), associatedData);
                    if (langNode.isEmpty()) continue;
                    localizedNode.putIfAbsent(entry.getKey(), (JsonNode)langNode);
                }
                if (!localizedNode.isEmpty()) {
                    associatedDataNode.putIfAbsent(SectionedAssociatedDataDescriptor.LOCALIZED.name(), (JsonNode)localizedNode);
                }
            }
            if (!associatedDataNode.isEmpty()) {
                rootNode.putIfAbsent(RestEntityDescriptor.ASSOCIATED_DATA.name(), (JsonNode)associatedDataNode);
            }
        }
    }

    protected void serializeReferences(@Nonnull EntitySerializationContext ctx, @Nonnull ObjectNode rootNode, @Nonnull EntityDecorator entity, @Nonnull EntitySchemaContract entitySchema) {
        if (entity.referencesAvailable() && !entity.getReferences().isEmpty()) {
            entity.getReferences().stream().map(ReferenceContract::getReferenceName).collect(Collectors.toCollection(TreeSet::new)).forEach(it -> this.serializeReferencesWithSameName(ctx, rootNode, entity, (String)it, entitySchema));
        }
    }

    protected void serializeReferencesWithSameName(@Nonnull EntitySerializationContext ctx, @Nonnull ObjectNode rootNode, @Nonnull EntityDecorator entity, @Nonnull String referenceName, @Nonnull EntitySchemaContract entitySchema) {
        Collection groupedReferences = entity.getReferences(referenceName);
        Optional anyReferenceFound = groupedReferences.stream().findFirst();
        if (anyReferenceFound.isPresent()) {
            ReferenceContract firstReference = (ReferenceContract)anyReferenceFound.get();
            String nodeReferenceName = firstReference.getReferenceSchema().map(it -> it.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).orElse(referenceName);
            if (firstReference.getReferenceCardinality() == Cardinality.EXACTLY_ONE || firstReference.getReferenceCardinality() == Cardinality.ZERO_OR_ONE) {
                Assert.isPremiseValid((groupedReferences.size() == 1 ? 1 : 0) != 0, (String)("Reference cardinality is: " + firstReference.getReferenceCardinality() + " but found " + groupedReferences.size() + " references with same name: " + referenceName));
                rootNode.putIfAbsent(nodeReferenceName, (JsonNode)this.serializeSingleReference(ctx, entity.getLocales(), firstReference, entitySchema));
            } else {
                ArrayNode referencesNode = this.objectJsonSerializer.arrayNode();
                rootNode.putIfAbsent(nodeReferenceName, (JsonNode)referencesNode);
                for (ReferenceContract groupedReference : groupedReferences) {
                    referencesNode.add((JsonNode)this.serializeSingleReference(ctx, entity.getLocales(), groupedReference, entitySchema));
                }
            }
        }
    }

    @Nonnull
    private ObjectNode serializeSingleReference(@Nonnull EntitySerializationContext ctx, @Nonnull Set<Locale> locales, @Nonnull ReferenceContract reference, @Nonnull EntitySchemaContract entitySchema) {
        ObjectNode referenceNode = this.objectJsonSerializer.objectNode();
        referenceNode.putIfAbsent(ReferenceDescriptor.REFERENCED_PRIMARY_KEY.name(), this.objectJsonSerializer.serializeObject(reference.getReferencedPrimaryKey()));
        reference.getReferencedEntity().ifPresent(sealedEntity -> referenceNode.putIfAbsent(ReferenceDescriptor.REFERENCED_ENTITY.name(), (JsonNode)this.serializeSingleEntity(ctx, (EntityClassifier)sealedEntity)));
        reference.getGroupEntity().map(it -> it).or(() -> ((ReferenceContract)reference).getGroup()).ifPresent(groupEntity -> referenceNode.putIfAbsent(ReferenceDescriptor.GROUP_ENTITY.name(), (JsonNode)this.serializeSingleEntity(ctx, (EntityClassifier)groupEntity)));
        ReferenceSchemaContract referenceSchema = (ReferenceSchemaContract)reference.getReferenceSchema().orElseThrow(() -> new RestQueryResolvingInternalError("Cannot find reference schema for `" + reference.getReferenceName() + "` in entity schema `" + entitySchema.getName() + "`."));
        this.serializeAttributes(referenceNode, locales, (AttributesContract<?>)reference, (NamedSchemaContract)referenceSchema, (AttributeSchemaProvider<?>)referenceSchema);
        return referenceNode;
    }

    private void serializePrices(@Nonnull EntitySerializationContext ctx, @Nonnull ObjectNode rootNode, @Nonnull EntityDecorator entity) {
        if (entity.pricesAvailable()) {
            Collection prices = entity.getPrices();
            ArrayNode pricesNode = this.objectJsonSerializer.arrayNode();
            rootNode.putIfAbsent(RestEntityDescriptor.PRICES.name(), (JsonNode)pricesNode);
            for (PriceContract price : prices) {
                pricesNode.add(this.objectJsonSerializer.serializeObject(price));
            }
            entity.getPriceForSaleIfAvailable().ifPresent(it -> {
                rootNode.putIfAbsent(RestEntityDescriptor.PRICE_FOR_SALE.name(), this.objectJsonSerializer.serializeObject(it));
                if (!entity.getPriceInnerRecordHandling().equals((Object)PriceInnerRecordHandling.NONE)) {
                    boolean multiplePricesForSale = this.hasMultiplePricesForSaleAvailable(ctx, entity);
                    rootNode.putIfAbsent(RestEntityDescriptor.MULTIPLE_PRICES_FOR_SALE_AVAILABLE.name(), this.objectJsonSerializer.serializeObject(multiplePricesForSale));
                }
            });
        }
    }

    private boolean hasMultiplePricesForSaleAvailable(@Nonnull EntitySerializationContext ctx, @Nonnull EntityDecorator entity) {
        boolean hasMultiplePricesForSale;
        List allPricesForSale = entity.getAllPricesForSale();
        if (allPricesForSale.size() <= 1) {
            return false;
        }
        PriceInnerRecordHandling priceInnerRecordHandling = entity.getPriceInnerRecordHandling();
        if (priceInnerRecordHandling.equals((Object)PriceInnerRecordHandling.LOWEST_PRICE)) {
            if (allPricesForSale.size() <= 1) {
                return false;
            }
            QueryPriceMode desiredPriceType = entity.getPricePredicate().getQueryPriceMode();
            long uniquePriceValuesCount = allPricesForSale.stream().map(price -> {
                if (desiredPriceType.equals((Object)QueryPriceMode.WITH_TAX)) {
                    return price.priceWithTax();
                }
                if (desiredPriceType.equals((Object)QueryPriceMode.WITHOUT_TAX)) {
                    return price.priceWithoutTax();
                }
                throw new RestInternalError("Unsupported price type `" + desiredPriceType + "`");
            }).distinct().count();
            hasMultiplePricesForSale = uniquePriceValuesCount > 1L;
        } else {
            hasMultiplePricesForSale = priceInnerRecordHandling.equals((Object)PriceInnerRecordHandling.SUM) ? allPricesForSale.size() > 1 : false;
        }
        return hasMultiplePricesForSale;
    }

    private void writeAttributesIntoNode(@Nonnull ObjectNode attributesNode, @Nonnull Collection<AttributesContract.AttributeKey> attributeKeys, @Nonnull AttributesContract<?> attributes, @Nonnull NamedSchemaContract parentSchema, @Nonnull AttributeSchemaProvider<?> attributeSchemaProvider) {
        for (AttributesContract.AttributeKey attributeKey : attributeKeys) {
            String attributeName = attributeKey.attributeName();
            Optional attributeValue = attributeKey.localized() ? attributes.getAttributeValue(attributeName, attributeKey.locale()) : attributes.getAttributeValue(attributeName);
            String serializableAttributeName = attributeSchemaProvider.getAttribute(attributeName).map(it -> it.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).orElseThrow(() -> new RestQueryResolvingInternalError("Cannot find attribute schema for `" + attributeName + "` in entity schema `" + parentSchema.getName() + "`."));
            if (attributeValue.isPresent() && ((AttributesContract.AttributeValue)attributeValue.get()).value() != null) {
                attributesNode.putIfAbsent(serializableAttributeName, this.objectJsonSerializer.serializeObject(((AttributesContract.AttributeValue)attributeValue.get()).value()));
                continue;
            }
            attributesNode.putIfAbsent(serializableAttributeName, null);
        }
    }

    private void writeAssociatedDataIntoNode(@Nonnull ObjectNode attributesNode, @Nonnull EntitySchemaContract entitySchema, @Nonnull Collection<AssociatedDataContract.AssociatedDataKey> associatedDataKeys, @Nonnull AssociatedDataContract associatedData) {
        for (AssociatedDataContract.AssociatedDataKey associatedDataKey : associatedDataKeys) {
            String associatedDataName = associatedDataKey.associatedDataName();
            Optional associatedDataValue = associatedDataKey.localized() ? associatedData.getAssociatedDataValue(associatedDataName, associatedDataKey.locale()) : associatedData.getAssociatedDataValue(associatedDataName);
            String serializableAssociatedDataName = entitySchema.getAssociatedData(associatedDataName).map(it -> it.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).orElseThrow(() -> new RestQueryResolvingInternalError("Cannot find associated data schema for `" + associatedDataName + "` in entity schema `" + entitySchema.getName() + "`."));
            if (associatedDataValue.isPresent() && ((AssociatedDataContract.AssociatedDataValue)associatedDataValue.get()).value() != null) {
                attributesNode.putIfAbsent(serializableAssociatedDataName, this.objectJsonSerializer.serializeObject(((AssociatedDataContract.AssociatedDataValue)associatedDataValue.get()).value()));
                continue;
            }
            attributesNode.putIfAbsent(serializableAssociatedDataName, null);
        }
    }

    @Nonnull
    public static Map<String, List<AttributesContract.AttributeKey>> separateAttributeKeysByLocale(@Nonnull Set<Locale> locales, @Nonnull Set<AttributesContract.AttributeKey> attributeKeys) {
        HashMap<String, List<AttributesContract.AttributeKey>> localeSeparatedKeys = new HashMap<String, List<AttributesContract.AttributeKey>>(locales.size() + 1);
        localeSeparatedKeys.put(SectionedAttributesDescriptor.GLOBAL.name(), new LinkedList());
        for (Locale locale : locales) {
            localeSeparatedKeys.put(locale.toLanguageTag(), new LinkedList());
        }
        for (AttributesContract.AttributeKey attributeKey : attributeKeys) {
            if (attributeKey.localized()) {
                List localizedKeys = (List)localeSeparatedKeys.get(attributeKey.locale().toLanguageTag());
                localizedKeys.add(attributeKey);
                continue;
            }
            List globalKeys = (List)localeSeparatedKeys.get(SectionedAttributesDescriptor.GLOBAL.name());
            globalKeys.add(attributeKey);
        }
        return localeSeparatedKeys;
    }

    @Nonnull
    public static Map<String, List<AssociatedDataContract.AssociatedDataKey>> separateAssociatedDataKeysByLocale(@Nonnull Set<Locale> locales, @Nonnull Set<AssociatedDataContract.AssociatedDataKey> associatedDataKeys) {
        HashMap<String, List<AssociatedDataContract.AssociatedDataKey>> localeSeparatedKeys = new HashMap<String, List<AssociatedDataContract.AssociatedDataKey>>(locales.size() + 1);
        localeSeparatedKeys.put(SectionedAssociatedDataDescriptor.GLOBAL.name(), new LinkedList());
        for (Locale locale : locales) {
            localeSeparatedKeys.put(locale.toLanguageTag(), new LinkedList());
        }
        for (AssociatedDataContract.AssociatedDataKey associatedDataKey : associatedDataKeys) {
            if (associatedDataKey.localized()) {
                List localizedKeys = (List)localeSeparatedKeys.get(associatedDataKey.locale().toLanguageTag());
                localizedKeys.add(associatedDataKey);
                continue;
            }
            List globalKeys = (List)localeSeparatedKeys.get(SectionedAssociatedDataDescriptor.GLOBAL.name());
            globalKeys.add(associatedDataKey);
        }
        return localeSeparatedKeys;
    }
}

