/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.evitadb.api.requestResponse.EvitaResponseExtraResult;
import io.evitadb.api.requestResponse.data.EntityClassifier;
import io.evitadb.api.requestResponse.extraResult.AttributeHistogram;
import io.evitadb.api.requestResponse.extraResult.FacetSummary;
import io.evitadb.api.requestResponse.extraResult.Hierarchy;
import io.evitadb.api.requestResponse.extraResult.PriceHistogram;
import io.evitadb.api.requestResponse.extraResult.QueryTelemetry;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.api.requestResponse.schema.ReferenceSchemaContract;
import io.evitadb.externalApi.api.ExternalApiNamingConventions;
import io.evitadb.externalApi.api.catalog.dataApi.dto.QueryTelemetryDto;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.ExtraResultsDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.FacetSummaryDescriptor;
import io.evitadb.externalApi.api.catalog.dataApi.model.extraResult.HierarchyDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.model.extraResult.LevelInfoDescriptor;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.serializer.EntityJsonSerializer;
import io.evitadb.externalApi.rest.api.catalog.dataApi.resolver.serializer.EntitySerializationContext;
import io.evitadb.externalApi.rest.api.resolver.serializer.ObjectJsonSerializer;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.exception.RestQueryResolvingInternalError;
import io.evitadb.utils.Assert;
import io.evitadb.utils.CollectionUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtraResultsJsonSerializer {
    private static final Logger log = LoggerFactory.getLogger(ExtraResultsJsonSerializer.class);
    private final EntityJsonSerializer entityJsonSerializer;
    private final ObjectJsonSerializer objectJsonSerializer;

    public ExtraResultsJsonSerializer(@Nonnull EntityJsonSerializer entityJsonSerializer, @Nonnull ObjectMapper objectMapper) {
        this.entityJsonSerializer = entityJsonSerializer;
        this.objectJsonSerializer = new ObjectJsonSerializer(objectMapper);
    }

    @Nonnull
    public JsonNode serialize(@Nonnull Map<Class<? extends EvitaResponseExtraResult>, EvitaResponseExtraResult> extraResults, @Nonnull EntitySchemaContract resultEntitySchema, @Nonnull CatalogSchemaContract catalogSchema) {
        ObjectNode rootNode = this.objectJsonSerializer.objectNode();
        for (EvitaResponseExtraResult extraResult : extraResults.values()) {
            if (extraResult instanceof QueryTelemetry) {
                QueryTelemetry queryTelemetry = (QueryTelemetry)extraResult;
                rootNode.putIfAbsent(ExtraResultsDescriptor.QUERY_TELEMETRY.name(), this.serializeQueryTelemetry(queryTelemetry));
                continue;
            }
            if (extraResult instanceof AttributeHistogram) {
                AttributeHistogram attributeHistogram = (AttributeHistogram)extraResult;
                rootNode.putIfAbsent(ExtraResultsDescriptor.ATTRIBUTE_HISTOGRAM.name(), this.serializeAttributeHistogram(attributeHistogram, resultEntitySchema));
                continue;
            }
            if (extraResult instanceof PriceHistogram) {
                PriceHistogram priceHistogram = (PriceHistogram)extraResult;
                rootNode.putIfAbsent(ExtraResultsDescriptor.PRICE_HISTOGRAM.name(), this.serializePriceHistogram(priceHistogram));
                continue;
            }
            if (extraResult instanceof Hierarchy) {
                Hierarchy hierarchyStats = (Hierarchy)extraResult;
                rootNode.putIfAbsent(ExtraResultsDescriptor.HIERARCHY.name(), this.serializeHierarchy(hierarchyStats, catalogSchema, resultEntitySchema));
                continue;
            }
            if (!(extraResult instanceof FacetSummary)) continue;
            FacetSummary facetSummary = (FacetSummary)extraResult;
            rootNode.putIfAbsent(ExtraResultsDescriptor.FACET_SUMMARY.name(), this.serializeFacetSummary(facetSummary, catalogSchema, resultEntitySchema));
        }
        return rootNode;
    }

    @Nonnull
    private JsonNode serializeFacetSummary(@Nonnull FacetSummary facetSummary, @Nonnull CatalogSchemaContract catalogSchema, @Nonnull EntitySchemaContract entitySchema) {
        Collection facetGroupStatistics = facetSummary.getReferenceStatistics();
        HashMap groupedStats = CollectionUtils.createHashMap((int)entitySchema.getReferences().size());
        for (FacetSummary.FacetGroupStatistics facetGroupStatistic : facetGroupStatistics) {
            if (groupedStats.containsKey(facetGroupStatistic.getReferenceName())) {
                ((List)groupedStats.get(facetGroupStatistic.getReferenceName())).add(facetGroupStatistic);
                continue;
            }
            LinkedList<FacetSummary.FacetGroupStatistics> groupedByReference = new LinkedList<FacetSummary.FacetGroupStatistics>();
            groupedByReference.add(facetGroupStatistic);
            groupedStats.put(facetGroupStatistic.getReferenceName(), groupedByReference);
        }
        ObjectNode facetGroupStatsNode = this.objectJsonSerializer.objectNode();
        groupedStats.forEach((key, value) -> {
            String serializableReferenceName = entitySchema.getReference(key).map(it -> it.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).orElseThrow(() -> new RestQueryResolvingInternalError("Cannot find reference schema for `" + key + "` in entity schema `" + entitySchema.getName() + "`."));
            facetGroupStatsNode.putIfAbsent(serializableReferenceName, this.serializeFacetSameGroupStatistics((List<FacetSummary.FacetGroupStatistics>)value, (ReferenceSchemaContract)entitySchema.getReference(key).orElseThrow(() -> new RestInternalError("Could not find referenc schema for `" + key + "`.")), catalogSchema));
        });
        return facetGroupStatsNode;
    }

    @Nonnull
    private JsonNode serializeFacetSameGroupStatistics(@Nonnull List<FacetSummary.FacetGroupStatistics> groupStatistics, @Nonnull ReferenceSchemaContract referenceSchema, @Nonnull CatalogSchemaContract catalogSchema) {
        if (referenceSchema.getReferencedGroupType() != null) {
            ArrayNode sameGroupStatsNode = this.objectJsonSerializer.arrayNode();
            groupStatistics.forEach(stats -> sameGroupStatsNode.add(this.serializeFacetGroupStatistics((FacetSummary.FacetGroupStatistics)stats, referenceSchema, catalogSchema)));
            return sameGroupStatsNode;
        }
        Assert.isPremiseValid((groupStatistics.size() == 1 ? 1 : 0) != 0, () -> new RestInternalError("There should be only one non-grouped facet group for reference `" + referenceSchema.getName() + "` but found `" + groupStatistics.size() + "`."));
        return this.serializeFacetGroupStatistics(groupStatistics.get(0), referenceSchema, catalogSchema);
    }

    @Nonnull
    private JsonNode serializeFacetGroupStatistics(@Nonnull FacetSummary.FacetGroupStatistics groupStatistics, @Nonnull ReferenceSchemaContract referenceSchema, @Nonnull CatalogSchemaContract catalogSchema) {
        ObjectNode groupStatsNode = this.objectJsonSerializer.objectNode();
        groupStatsNode.put(FacetSummaryDescriptor.FacetGroupStatisticsDescriptor.COUNT.name(), groupStatistics.getCount());
        if (referenceSchema.getReferencedGroupType() != null) {
            groupStatsNode.putIfAbsent(FacetSummaryDescriptor.FacetGroupStatisticsDescriptor.GROUP_ENTITY.name(), groupStatistics.getGroupEntity() != null ? this.serializeEntity(groupStatistics.getGroupEntity(), catalogSchema) : null);
        }
        ArrayNode jsonNodes = this.objectJsonSerializer.arrayNode();
        groupStatistics.getFacetStatistics().forEach(facetStats -> jsonNodes.add(this.serializeFacetStatistics((FacetSummary.FacetStatistics)facetStats, catalogSchema)));
        groupStatsNode.putIfAbsent(FacetSummaryDescriptor.FacetGroupStatisticsDescriptor.FACET_STATISTICS.name(), (JsonNode)jsonNodes);
        return groupStatsNode;
    }

    @Nonnull
    private JsonNode serializeFacetStatistics(@Nonnull FacetSummary.FacetStatistics facetStatistics, @Nonnull CatalogSchemaContract catalogSchema) {
        ObjectNode facetStatsNode = this.objectJsonSerializer.objectNode();
        facetStatsNode.putIfAbsent(FacetSummaryDescriptor.FacetStatisticsDescriptor.REQUESTED.name(), this.objectJsonSerializer.serializeObject(facetStatistics.isRequested()));
        facetStatsNode.putIfAbsent(FacetSummaryDescriptor.FacetStatisticsDescriptor.COUNT.name(), this.objectJsonSerializer.serializeObject(facetStatistics.getCount()));
        if (facetStatistics.getImpact() != null) {
            ObjectNode impactNode = this.objectJsonSerializer.objectNode();
            FacetSummary.RequestImpact impact = facetStatistics.getImpact();
            impactNode.putIfAbsent(FacetSummaryDescriptor.FacetRequestImpactDescriptor.DIFFERENCE.name(), this.objectJsonSerializer.serializeObject(impact.difference()));
            impactNode.putIfAbsent(FacetSummaryDescriptor.FacetRequestImpactDescriptor.MATCH_COUNT.name(), this.objectJsonSerializer.serializeObject(impact.matchCount()));
            impactNode.putIfAbsent(FacetSummaryDescriptor.FacetRequestImpactDescriptor.HAS_SENSE.name(), this.objectJsonSerializer.serializeObject(impact.hasSense()));
            facetStatsNode.putIfAbsent(FacetSummaryDescriptor.FacetStatisticsDescriptor.IMPACT.name(), (JsonNode)impactNode);
        }
        facetStatsNode.putIfAbsent(FacetSummaryDescriptor.FacetStatisticsDescriptor.FACET_ENTITY.name(), this.serializeEntity(facetStatistics.getFacetEntity(), catalogSchema));
        return facetStatsNode;
    }

    @Nonnull
    private JsonNode serializeHierarchy(@Nonnull Hierarchy hierarchy, @Nonnull CatalogSchemaContract catalogSchema, @Nonnull EntitySchemaContract entitySchema) {
        ObjectNode hierarchyNode = this.objectJsonSerializer.objectNode();
        Map selfHierarchy = hierarchy.getSelfHierarchy();
        if (!selfHierarchy.isEmpty()) {
            hierarchyNode.putIfAbsent(HierarchyDescriptor.SELF.name(), this.serializeHierarchyOf(selfHierarchy, catalogSchema));
        }
        hierarchy.getReferenceHierarchies().forEach((referenceName, hierarchyOfReference) -> {
            String serializableReferenceName = entitySchema.getReference(referenceName).map(it -> it.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).orElseThrow(() -> new RestQueryResolvingInternalError("Cannot find reference schema for `" + referenceName + "` in entity schema `" + entitySchema.getName() + "`."));
            hierarchyNode.putIfAbsent(serializableReferenceName, this.serializeHierarchyOf((Map<String, List<Hierarchy.LevelInfo>>)hierarchyOfReference, catalogSchema));
        });
        return hierarchyNode;
    }

    @Nonnull
    private JsonNode serializeHierarchyOf(@Nonnull Map<String, List<Hierarchy.LevelInfo>> hierarchyOf, @Nonnull CatalogSchemaContract catalogSchema) {
        ObjectNode hierarchyOfNode = this.objectJsonSerializer.objectNode();
        hierarchyOf.forEach((outputName, levelInfos) -> hierarchyOfNode.putIfAbsent(outputName, this.serializeLevelInfos((List<Hierarchy.LevelInfo>)levelInfos, catalogSchema)));
        return hierarchyOfNode;
    }

    @Nonnull
    private JsonNode serializeLevelInfos(@Nonnull List<Hierarchy.LevelInfo> levelInfos, @Nonnull CatalogSchemaContract catalogSchema) {
        ArrayNode levelInfoNodes = this.objectJsonSerializer.arrayNode();
        for (Hierarchy.LevelInfo levelInfo : levelInfos) {
            ObjectNode levelInfoNode = this.objectJsonSerializer.objectNode();
            levelInfoNode.putIfAbsent(LevelInfoDescriptor.ENTITY.name(), this.serializeEntity(levelInfo.entity(), catalogSchema));
            levelInfoNode.put(LevelInfoDescriptor.REQUESTED.name(), levelInfo.requested());
            Optional.ofNullable(levelInfo.queriedEntityCount()).ifPresent(queriedEntityCount -> levelInfoNode.put(LevelInfoDescriptor.QUERIED_ENTITY_COUNT.name(), queriedEntityCount));
            Optional.ofNullable(levelInfo.childrenCount()).ifPresent(childrenCount -> levelInfoNode.put(LevelInfoDescriptor.CHILDREN_COUNT.name(), childrenCount));
            List children = levelInfo.children();
            if (!children.isEmpty()) {
                levelInfoNode.putIfAbsent(LevelInfoDescriptor.CHILDREN.name(), this.serializeLevelInfos(children, catalogSchema));
            }
            levelInfoNodes.add((JsonNode)levelInfoNode);
        }
        return levelInfoNodes;
    }

    @Nonnull
    private JsonNode serializeEntity(@Nonnull EntityClassifier entityDecorator, @Nonnull CatalogSchemaContract catalogSchema) {
        return this.entityJsonSerializer.serialize(new EntitySerializationContext(catalogSchema), entityDecorator);
    }

    @Nonnull
    private JsonNode serializeQueryTelemetry(@Nonnull QueryTelemetry telemetry) {
        return this.objectJsonSerializer.getObjectMapper().valueToTree((Object)QueryTelemetryDto.from((QueryTelemetry)telemetry, (boolean)true));
    }

    @Nonnull
    private JsonNode serializeAttributeHistogram(@Nonnull AttributeHistogram attributeHistogram, @Nonnull EntitySchemaContract entitySchema) {
        ObjectNode histogramNode = this.objectJsonSerializer.objectNode();
        for (Map.Entry entry : attributeHistogram.getHistograms().entrySet()) {
            String attributeName = (String)entry.getKey();
            String serializableAttributeName = entitySchema.getAttribute(attributeName).map(it -> it.getNameVariant(ExternalApiNamingConventions.PROPERTY_NAME_NAMING_CONVENTION)).orElseThrow(() -> new RestQueryResolvingInternalError("Cannot find attribute schema for `" + attributeName + "` in entity schema `" + entitySchema.getName() + "`."));
            histogramNode.putIfAbsent(serializableAttributeName, this.objectJsonSerializer.getObjectMapper().valueToTree(entry.getValue()));
        }
        return histogramNode;
    }

    @Nonnull
    private JsonNode serializePriceHistogram(@Nonnull PriceHistogram priceHistogram) {
        return this.objectJsonSerializer.getObjectMapper().valueToTree((Object)priceHistogram);
    }
}

