/*
 * Decompiled with CFR 0.152.
 */
package io.evitadb.externalApi.rest.api.catalog.resolver.endpoint;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.evitadb.api.CatalogContract;
import io.evitadb.api.requestResponse.schema.CatalogSchemaContract;
import io.evitadb.api.requestResponse.schema.EntitySchemaContract;
import io.evitadb.core.Evita;
import io.evitadb.externalApi.rest.exception.RestInternalError;
import io.evitadb.externalApi.rest.io.RestHandlingContext;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import java.util.Map;
import javax.annotation.Nonnull;

public class CatalogRestHandlingContext
extends RestHandlingContext {
    @Nonnull
    protected final CatalogContract catalog;
    @Nonnull
    protected final CatalogSchemaContract catalogSchema;

    public CatalogRestHandlingContext(@Nonnull ObjectMapper objectMapper, @Nonnull Evita evita, @Nonnull CatalogSchemaContract catalogSchema, @Nonnull OpenAPI openApi, @Nonnull Map<String, Class<? extends Enum<?>>> enumMapping, @Nonnull Operation endpointOperation, boolean localized) {
        super(objectMapper, evita, openApi, enumMapping, endpointOperation, localized);
        this.catalog = evita.getCatalogInstanceOrThrowException(catalogSchema.getName());
        this.catalogSchema = catalogSchema;
    }

    @Nonnull
    public EntitySchemaContract getEntitySchema(@Nonnull String entityName) {
        return (EntitySchemaContract)this.catalog.getEntitySchema(entityName).orElseThrow(() -> new RestInternalError("No schema found for entity: " + entityName + " in catalog: " + this.catalogSchema.getName()));
    }

    @Nonnull
    public CatalogSchemaContract getCatalogSchema() {
        return this.catalogSchema;
    }
}

